/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.RealMatrix;

@Deprecated
public class LeastSquaresConverter
implements MultivariateFunction {
    private final MultivariateVectorFunction function;
    private final double[] observations;
    private final double[] weights;
    private final RealMatrix scale;

    public LeastSquaresConverter(MultivariateVectorFunction function, double[] observations) {
        this.function = function;
        this.observations = (double[])observations.clone();
        this.weights = null;
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorFunction function, double[] observations, double[] weights) {
        if (observations.length != weights.length) {
            throw new DimensionMismatchException(observations.length, weights.length);
        }
        this.function = function;
        this.observations = (double[])observations.clone();
        this.weights = (double[])weights.clone();
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorFunction function, double[] observations, RealMatrix scale2) {
        if (observations.length != scale2.getColumnDimension()) {
            throw new DimensionMismatchException(observations.length, scale2.getColumnDimension());
        }
        this.function = function;
        this.observations = (double[])observations.clone();
        this.weights = null;
        this.scale = scale2.copy();
    }

    public double value(double[] point) {
        double[] residuals = this.function.value(point);
        if (residuals.length != this.observations.length) {
            throw new DimensionMismatchException(residuals.length, this.observations.length);
        }
        for (int i2 = 0; i2 < residuals.length; ++i2) {
            int n2 = i2;
            residuals[n2] = residuals[n2] - this.observations[i2];
        }
        double sumSquares = 0.0;
        if (this.weights != null) {
            for (int i3 = 0; i3 < residuals.length; ++i3) {
                double ri = residuals[i3];
                sumSquares += this.weights[i3] * ri * ri;
            }
        } else if (this.scale != null) {
            for (double yi : this.scale.operate(residuals)) {
                sumSquares += yi * yi;
            }
        } else {
            for (double ri : residuals) {
                sumSquares += ri * ri;
            }
        }
        return sumSquares;
    }
}

