/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import java.util.StringTokenizer;

public class PdfDestination
extends PdfArray {
    public static final int XYZ = 0;
    public static final int FIT = 1;
    public static final int FITH = 2;
    public static final int FITV = 3;
    public static final int FITR = 4;
    public static final int FITB = 5;
    public static final int FITBH = 6;
    public static final int FITBV = 7;
    private boolean status = false;

    public PdfDestination(PdfDestination d2) {
        super(d2);
        this.status = d2.status;
    }

    public PdfDestination(int type2) {
        if (type2 == 5) {
            this.add(PdfName.FITB);
        } else {
            this.add(PdfName.FIT);
        }
    }

    public PdfDestination(int type2, float parameter) {
        super(new PdfNumber(parameter));
        switch (type2) {
            default: {
                this.addFirst(PdfName.FITH);
                break;
            }
            case 3: {
                this.addFirst(PdfName.FITV);
                break;
            }
            case 6: {
                this.addFirst(PdfName.FITBH);
                break;
            }
            case 7: {
                this.addFirst(PdfName.FITBV);
            }
        }
    }

    public PdfDestination(int type2, float left2, float top2, float zoom) {
        super(PdfName.XYZ);
        if (left2 < 0.0f) {
            this.add(PdfNull.PDFNULL);
        } else {
            this.add(new PdfNumber(left2));
        }
        if (top2 < 0.0f) {
            this.add(PdfNull.PDFNULL);
        } else {
            this.add(new PdfNumber(top2));
        }
        this.add(new PdfNumber(zoom));
    }

    public PdfDestination(int type2, float left2, float bottom2, float right2, float top2) {
        super(PdfName.FITR);
        this.add(new PdfNumber(left2));
        this.add(new PdfNumber(bottom2));
        this.add(new PdfNumber(right2));
        this.add(new PdfNumber(top2));
    }

    public PdfDestination(String dest) {
        StringTokenizer tokens = new StringTokenizer(dest);
        if (tokens.hasMoreTokens()) {
            this.add(new PdfName(tokens.nextToken()));
        }
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("null".equals(token)) {
                this.add(new PdfNull());
                continue;
            }
            try {
                this.add(new PdfNumber(token));
            }
            catch (RuntimeException e2) {
                this.add(new PdfNull());
            }
        }
    }

    public boolean hasPage() {
        return this.status;
    }

    public boolean addPage(PdfIndirectReference page) {
        if (!this.status) {
            this.addFirst(page);
            this.status = true;
            return true;
        }
        return false;
    }
}

