/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.RenderingHints;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.MarkerData;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.StrutMetrics;

public class ListItemPainter {
    public static void paint(RenderingContext c2, BlockBox box) {
        if (box.getMarkerData() == null) {
            return;
        }
        MarkerData markerData = box.getMarkerData();
        if (markerData.getImageMarker() != null) {
            ListItemPainter.drawImage(c2, box, markerData);
        } else {
            CalculatedStyle style = box.getStyle();
            IdentValue listStyle = style.getIdent(CSSName.LIST_STYLE_TYPE);
            c2.getOutputDevice().setColor(style.getColor());
            if (markerData.getGlyphMarker() != null) {
                ListItemPainter.drawGlyph(c2, box, style, listStyle);
            } else if (markerData.getTextMarker() != null) {
                ListItemPainter.drawText(c2, box, listStyle);
            }
        }
    }

    private static void drawImage(RenderingContext c2, BlockBox box, MarkerData markerData) {
        FSImage img = null;
        MarkerData.ImageMarker marker = markerData.getImageMarker();
        img = marker.getImage();
        if (img != null) {
            StrutMetrics strutMetrics = box.getMarkerData().getStructMetrics();
            int x2 = ListItemPainter.getReferenceX(c2, box);
            c2.getOutputDevice().drawImage(img, x2 += -marker.getLayoutWidth() + (marker.getLayoutWidth() / 2 - img.getWidth() / 2), (int)((float)ListItemPainter.getReferenceBaseline(c2, box) - strutMetrics.getAscent() / 2.0f - (float)(img.getHeight() / 2)));
        }
    }

    private static int getReferenceX(RenderingContext c2, BlockBox box) {
        MarkerData markerData = box.getMarkerData();
        if (markerData.getReferenceLine() != null) {
            return markerData.getReferenceLine().getAbsX();
        }
        return box.getAbsX() + (int)box.getMargin(c2).left();
    }

    private static int getReferenceBaseline(RenderingContext c2, BlockBox box) {
        MarkerData markerData = box.getMarkerData();
        StrutMetrics strutMetrics = box.getMarkerData().getStructMetrics();
        if (markerData.getReferenceLine() != null) {
            return markerData.getReferenceLine().getAbsY() + strutMetrics.getBaseline();
        }
        return box.getAbsY() + box.getTy() + strutMetrics.getBaseline();
    }

    private static void drawGlyph(RenderingContext c2, BlockBox box, CalculatedStyle style, IdentValue listStyle) {
        Object aa_key = c2.getOutputDevice().getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        c2.getOutputDevice().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        StrutMetrics strutMetrics = box.getMarkerData().getStructMetrics();
        MarkerData.GlyphMarker marker = box.getMarkerData().getGlyphMarker();
        int x2 = ListItemPainter.getReferenceX(c2, box);
        x2 += -marker.getLayoutWidth();
        int y2 = ListItemPainter.getReferenceBaseline(c2, box) - (int)strutMetrics.getAscent() / 2 - marker.getDiameter() / 2;
        if (listStyle == IdentValue.DISC) {
            c2.getOutputDevice().fillOval(x2, y2, marker.getDiameter(), marker.getDiameter());
        } else if (listStyle == IdentValue.SQUARE) {
            c2.getOutputDevice().fillRect(x2, y2, marker.getDiameter(), marker.getDiameter());
        } else if (listStyle == IdentValue.CIRCLE) {
            c2.getOutputDevice().drawOval(x2, y2, marker.getDiameter(), marker.getDiameter());
        }
        c2.getOutputDevice().setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa_key == null ? RenderingHints.VALUE_ANTIALIAS_DEFAULT : aa_key);
    }

    private static void drawText(RenderingContext c2, BlockBox box, IdentValue listStyle) {
        MarkerData.TextMarker text2 = box.getMarkerData().getTextMarker();
        int x2 = ListItemPainter.getReferenceX(c2, box);
        int y2 = ListItemPainter.getReferenceBaseline(c2, box);
        c2.getOutputDevice().setColor(box.getStyle().getColor());
        c2.getOutputDevice().setFont(box.getStyle().getFSFont(c2));
        c2.getTextRenderer().drawString(c2.getOutputDevice(), text2.getText(), x2 += -text2.getLayoutWidth(), y2);
    }
}

