/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.GDE;
import gde.config.GraphicsTemplate;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.device.skyrc.MC3000;
import gde.device.skyrc.MC3000Dialog;
import gde.device.skyrc.MC3000UsbPort;
import gde.device.skyrc.MC3000_FM_NiMH_LiIo;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.WaitTimer;
import java.util.Objects;
import java.util.logging.Logger;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbNotClaimedException;

public class MC3000FmGathererThread
extends Thread {
    protected static final int USB_QUERY_DELAY = GDE.IS_WINDOWS ? 70 : 160;
    static final String $CLASS_NAME = MC3000FmGathererThread.class.getName();
    static final Logger log = Logger.getLogger(MC3000FmGathererThread.class.getName());
    static final int WAIT_TIME_RETRYS_END_SEC = 300;
    static final int WAIT_TIME_RETRYS_MAX_SEC = 14460;
    final DataExplorer application;
    final Settings settings;
    final MC3000UsbPort usbPort;
    final MC3000_FM_NiMH_LiIo device;
    final MC3000Dialog dialog;
    final Channels channels;
    final Channel channel;
    final int channelNumber;
    String recordSetKey = Messages.getString((String)"GDE_MSGT0272");
    boolean isPortOpenedByLiveGatherer = false;
    boolean isGatheredRecordSetVisible = true;
    boolean isCollectDataStopped = false;
    UsbInterface usbInterface = null;
    boolean isProgrammExecuting1 = false;
    boolean isProgrammExecuting2 = false;
    boolean isProgrammExecuting3 = false;
    boolean isProgrammExecuting4 = false;
    boolean wasProgrammExecuting1 = false;
    boolean wasProgrammExecuting2 = false;
    boolean wasProgrammExecuting3 = false;
    boolean wasProgrammExecuting4 = false;
    boolean[] isAlerted4Finish = new boolean[]{false, false, false, false};
    int retryCounterRest_sec = 14460;
    int retryCounterEnd_sec = 300;
    int retryCounterEnd_1_sec = 300;
    int retryCounterEnd_2_sec = 300;
    int retryCounterEnd_3_sec = 300;
    int retryCounterEnd_4_sec = 300;
    int lastNumberDisplayableRecords = 0;

    public MC3000FmGathererThread(DataExplorer currentApplication, MC3000_FM_NiMH_LiIo useDevice, MC3000UsbPort useSerialPort, int channelConfigNumber, MC3000Dialog useDialog) throws ApplicationConfigurationException, UsbDisconnectedException, UsbException {
        super("dataGatherer");
        this.application = currentApplication;
        this.settings = Settings.getInstance();
        this.device = useDevice;
        this.dialog = useDialog;
        this.usbPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        if (!this.usbPort.isConnected()) {
            this.usbInterface = this.usbPort.openUsbPort(this.device);
            this.isPortOpenedByLiveGatherer = true;
        }
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String $METHOD_NAME = "run";
            RecordSet recordSet5 = null;
            int[] points1 = new int[9];
            int[] points2 = new int[9];
            int[] points3 = new int[9];
            int[] points4 = new int[9];
            int[] points5 = new int[this.device.getNumberOfMeasurements(1)];
            this.isProgrammExecuting1 = false;
            this.isProgrammExecuting2 = false;
            this.isProgrammExecuting3 = false;
            this.isProgrammExecuting4 = false;
            this.wasProgrammExecuting1 = false;
            this.wasProgrammExecuting2 = false;
            this.wasProgrammExecuting3 = false;
            this.wasProgrammExecuting4 = false;
            long lastCycleTime = 0L;
            byte[] dataBuffer1 = null;
            byte[] dataBuffer2 = null;
            byte[] dataBuffer3 = null;
            byte[] dataBuffer4 = null;
            Object recordSetKey5 = Messages.getString((String)"GDE_MSGT0272");
            String processBatteryType = null;
            this.isCollectDataStopped = false;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
            }
            lastCycleTime = System.nanoTime() / 1000000L;
            while (!this.isCollectDataStopped && this.usbPort.isConnected()) {
                try {
                    if (this.dialog != null && !this.dialog.isDisposed() && this.dialog.getTabFolderSelectionIndex() == 0) {
                        System.out.println();
                    } else {
                        if (this.application != null) {
                            this.application.setSerialTxOn();
                            this.application.setSerialRxOn();
                        }
                        if (this.usbPort.isConnected()) {
                            dataBuffer1 = this.usbPort.getData(this.usbInterface, MC3000UsbPort.TakeMtuData.SLOT_0.value());
                        }
                        WaitTimer.delay((long)USB_QUERY_DELAY);
                        if (this.usbPort.isConnected()) {
                            dataBuffer2 = this.usbPort.getData(this.usbInterface, MC3000UsbPort.TakeMtuData.SLOT_1.value());
                        }
                        if (this.application != null) {
                            this.application.setSerialTxOff();
                        }
                        WaitTimer.delay((long)USB_QUERY_DELAY);
                        if (this.usbPort.isConnected()) {
                            dataBuffer3 = this.usbPort.getData(this.usbInterface, MC3000UsbPort.TakeMtuData.SLOT_2.value());
                        }
                        WaitTimer.delay((long)USB_QUERY_DELAY);
                        if (this.usbPort.isConnected()) {
                            dataBuffer4 = this.usbPort.getData(this.usbInterface, MC3000UsbPort.TakeMtuData.SLOT_3.value());
                        }
                        if (this.application != null) {
                            this.application.setSerialRxOff();
                        }
                        if (dataBuffer1 != null && dataBuffer1.length >= 6 && dataBuffer1[5] == 4) {
                            --this.retryCounterEnd_1_sec;
                        }
                        boolean bl = this.isProgrammExecuting1 = this.device.isProcessing(1, dataBuffer1) && this.retryCounterEnd_1_sec >= 0;
                        if (this.isProgrammExecuting1 && !this.wasProgrammExecuting1) {
                            this.wasProgrammExecuting1 = this.isProgrammExecuting1;
                            MC3000_FM_NiMH_LiIo mC3000_FM_NiMH_LiIo = this.device;
                            Objects.requireNonNull(mC3000_FM_NiMH_LiIo);
                            this.retryCounterEnd_1_sec = mC3000_FM_NiMH_LiIo.new MC3000.SlotSettings(this.usbPort.getSlotData(this.usbInterface, MC3000UsbPort.QuerySlotData.SLOT_0.value()), this.device.getFirmwareVersionAsInt()).getChargeRestingTime() * 60;
                            log.log(Level.OFF, "Resting time slot 1 [min] " + this.retryCounterEnd_1_sec / 60);
                        } else if (!this.isProgrammExecuting1) {
                            this.wasProgrammExecuting1 = this.isProgrammExecuting1;
                        }
                        if (dataBuffer2 != null && dataBuffer2.length >= 6 && dataBuffer2[5] == 4) {
                            --this.retryCounterEnd_2_sec;
                        }
                        boolean bl2 = this.isProgrammExecuting2 = this.device.isProcessing(2, dataBuffer2) && this.retryCounterEnd_2_sec >= 0;
                        if (this.isProgrammExecuting2 && !this.wasProgrammExecuting2) {
                            this.wasProgrammExecuting2 = this.isProgrammExecuting2;
                            MC3000_FM_NiMH_LiIo mC3000_FM_NiMH_LiIo = this.device;
                            Objects.requireNonNull(mC3000_FM_NiMH_LiIo);
                            this.retryCounterEnd_2_sec = mC3000_FM_NiMH_LiIo.new MC3000.SlotSettings(this.usbPort.getSlotData(this.usbInterface, MC3000UsbPort.QuerySlotData.SLOT_1.value()), this.device.getFirmwareVersionAsInt()).getChargeRestingTime() * 60;
                            log.log(Level.OFF, "Resting time slot 2 [min] " + this.retryCounterEnd_2_sec / 60);
                        } else if (!this.isProgrammExecuting2) {
                            this.wasProgrammExecuting2 = this.isProgrammExecuting2;
                        }
                        if (dataBuffer3 != null && dataBuffer3.length >= 6 && dataBuffer3[5] == 4) {
                            --this.retryCounterEnd_3_sec;
                        }
                        boolean bl3 = this.isProgrammExecuting3 = this.device.isProcessing(3, dataBuffer3) && this.retryCounterEnd_3_sec >= 0;
                        if (this.isProgrammExecuting3 && !this.wasProgrammExecuting3) {
                            this.wasProgrammExecuting3 = this.isProgrammExecuting3;
                            MC3000_FM_NiMH_LiIo mC3000_FM_NiMH_LiIo = this.device;
                            Objects.requireNonNull(mC3000_FM_NiMH_LiIo);
                            this.retryCounterEnd_3_sec = mC3000_FM_NiMH_LiIo.new MC3000.SlotSettings(this.usbPort.getSlotData(this.usbInterface, MC3000UsbPort.QuerySlotData.SLOT_2.value()), this.device.getFirmwareVersionAsInt()).getChargeRestingTime() * 60;
                            log.log(Level.OFF, "Resting time slot 3 [min] " + this.retryCounterEnd_3_sec / 60);
                        } else if (!this.isProgrammExecuting3) {
                            this.wasProgrammExecuting3 = this.isProgrammExecuting3;
                        }
                        if (dataBuffer4 != null && dataBuffer4.length >= 6 && dataBuffer4[5] == 4) {
                            --this.retryCounterEnd_4_sec;
                        }
                        boolean bl4 = this.isProgrammExecuting4 = this.device.isProcessing(4, dataBuffer4) && this.retryCounterEnd_4_sec >= 0;
                        if (this.isProgrammExecuting4 && !this.wasProgrammExecuting4) {
                            this.wasProgrammExecuting4 = this.isProgrammExecuting4;
                            MC3000_FM_NiMH_LiIo mC3000_FM_NiMH_LiIo = this.device;
                            Objects.requireNonNull(mC3000_FM_NiMH_LiIo);
                            this.retryCounterEnd_4_sec = mC3000_FM_NiMH_LiIo.new MC3000.SlotSettings(this.usbPort.getSlotData(this.usbInterface, MC3000UsbPort.QuerySlotData.SLOT_3.value()), this.device.getFirmwareVersionAsInt()).getChargeRestingTime() * 60;
                            log.log(Level.OFF, "Resting time slot 4 [min] " + this.retryCounterEnd_4_sec / 60);
                        } else if (!this.isProgrammExecuting4) {
                            this.wasProgrammExecuting4 = this.isProgrammExecuting4;
                        }
                        if (this.isProgrammExecuting1 || this.isProgrammExecuting2 || this.isProgrammExecuting3 || this.isProgrammExecuting4) {
                            RecordSet activeRecordSet;
                            int lastEnergie1 = points1[4];
                            points1 = new int[9];
                            int lastEnergie2 = points2[4];
                            points2 = new int[9];
                            int lastEnergie3 = points3[4];
                            points3 = new int[9];
                            int lastEnergie4 = points4[4];
                            points4 = new int[9];
                            if (this.isProgrammExecuting1) {
                                points1[4] = lastEnergie1;
                                this.device.convertDataBytes(points1, dataBuffer1);
                                String string = processBatteryType = processBatteryType == null ? this.device.getProcessingBatteryTypeName(dataBuffer1) : processBatteryType;
                            }
                            if (this.isProgrammExecuting2) {
                                points2[4] = lastEnergie2;
                                this.device.convertDataBytes(points2, dataBuffer2);
                                String string = processBatteryType = processBatteryType == null ? this.device.getProcessingBatteryTypeName(dataBuffer2) : processBatteryType;
                            }
                            if (this.isProgrammExecuting3) {
                                points3[4] = lastEnergie3;
                                this.device.convertDataBytes(points3, dataBuffer3);
                                String string = processBatteryType = processBatteryType == null ? this.device.getProcessingBatteryTypeName(dataBuffer3) : processBatteryType;
                            }
                            if (this.isProgrammExecuting4) {
                                points4[4] = lastEnergie4;
                                this.device.convertDataBytes(points4, dataBuffer4);
                                String string = processBatteryType = processBatteryType == null ? this.device.getProcessingBatteryTypeName(dataBuffer4) : processBatteryType;
                            }
                            if (points5.length != 0 && (this.isProgrammExecuting1 || this.isProgrammExecuting2 || this.isProgrammExecuting3 || this.isProgrammExecuting4)) {
                                points5[0] = points1[0];
                                points5[1] = points2[0];
                                points5[2] = points3[0];
                                points5[3] = points4[0];
                                points5[4] = points1[1];
                                points5[5] = points2[1];
                                points5[6] = points3[1];
                                points5[7] = points4[1];
                                points5[8] = points1[2];
                                points5[9] = points2[2];
                                points5[10] = points3[2];
                                points5[11] = points4[2];
                                points5[12] = points1[5];
                                points5[13] = points2[5];
                                points5[14] = points3[5];
                                points5[15] = points4[5];
                                points5[16] = points1[6];
                                points5[17] = points2[6];
                                points5[18] = points3[6];
                                points5[19] = points4[6];
                                if (this.isProgrammExecuting1) {
                                    points5[20] = points1[7];
                                } else if (this.isProgrammExecuting2) {
                                    points5[20] = points2[7];
                                } else if (this.isProgrammExecuting3) {
                                    points5[20] = points3[7];
                                } else if (this.isProgrammExecuting4) {
                                    points5[20] = points4[7];
                                }
                                points5[21] = points1[8];
                                points5[22] = points2[8];
                                points5[23] = points3[8];
                                points5[24] = points4[8];
                                String processName = Messages.getString((String)"GDE_MSGT3630");
                                Channel slotChannel = (Channel)this.channels.get((Object)1);
                                if (!(slotChannel == null || recordSet5 != null && ((String)recordSetKey5).contains(processName))) {
                                    this.application.setStatusMessage("");
                                    recordSetKey5 = slotChannel.getNextRecordSetNumber() + ") " + processName;
                                    recordSetKey5 = ((String)recordSetKey5).length() <= 40 ? recordSetKey5 : ((String)recordSetKey5).substring(0, 40);
                                    slotChannel.put(recordSetKey5, (Object)RecordSet.createRecordSet((String)recordSetKey5, (IDevice)this.application.getActiveDevice(), (int)slotChannel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                                    Object templateFileName = this.device.getName().substring(0, this.device.getName().indexOf("_", 9) + 1);
                                    switch (processBatteryType) {
                                        default: {
                                            templateFileName = (String)templateFileName + "NiMH";
                                            break;
                                        }
                                        case "LiIo": 
                                        case "LiIo4.35": 
                                        case "LiFe": 
                                        case "LTO": 
                                        case "RAM": {
                                            templateFileName = (String)templateFileName + "LiIo";
                                        }
                                    }
                                    GraphicsTemplate graphicsTemplate = new GraphicsTemplate((String)templateFileName);
                                    graphicsTemplate.load();
                                    if (graphicsTemplate.isAvailable()) {
                                        slotChannel.setTemplate((String)templateFileName);
                                    }
                                    if (slotChannel.getType() == ChannelTypes.TYPE_CONFIG) {
                                        slotChannel.applyTemplate((String)recordSetKey5, false);
                                    } else {
                                        slotChannel.applyTemplateBasics((String)recordSetKey5);
                                    }
                                    log.logp(Level.FINE, $CLASS_NAME, "run", (String)recordSetKey5 + " created for channel " + slotChannel.getName());
                                    recordSet5 = (RecordSet)slotChannel.get(recordSetKey5);
                                    recordSet5.setAllDisplayable();
                                    String description = recordSet5.getRecordSetDescription();
                                    recordSet5.setRecordSetDescription(description + GDE.LINE_SEPARATOR + this.device.getHardwareString() + " " + this.device.getFirmwareString() + " Template : " + (String)templateFileName);
                                    slotChannel.switchRecordSet((String)recordSetKey5);
                                }
                                if (recordSet5 != null) {
                                    recordSet5.addPoints(points5);
                                }
                                if (recordSet5 != null && (recordSet5.get(0).realSize() < 3 || recordSet5.get(0).realSize() % 10 == 0)) {
                                    this.device.updateVisibilityStatus(recordSet5, true);
                                }
                            }
                            if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null && activeRecordSet.size() > 0) {
                                this.application.updateAllTabs(false, this.lastNumberDisplayableRecords != activeRecordSet.getConfiguredDisplayable());
                                this.lastNumberDisplayableRecords = activeRecordSet.getConfiguredDisplayable();
                            }
                            this.application.setStatusMessage("");
                            if (this.device.isProcessingStatusStandByOrFinished(dataBuffer1) && this.device.isProcessingStatusStandByOrFinished(dataBuffer2) && this.device.isProcessingStatusStandByOrFinished(dataBuffer3) && this.device.isProcessingStatusStandByOrFinished(dataBuffer4)) {
                                if (0 >= --this.retryCounterEnd_sec) {
                                    log.log(Level.INFO, "all device operations finished");
                                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI3602"));
                                    this.stopDataGatheringThread(false, null);
                                }
                            } else {
                                this.retryCounterRest_sec = 14460;
                                this.retryCounterEnd_sec = 300;
                            }
                        } else {
                            this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3600"));
                            log.logp(Level.FINE, $CLASS_NAME, "run", "wait for device activation ...");
                            if (0 >= --this.retryCounterRest_sec) {
                                log.log(Level.INFO, "device activation timeout");
                                this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI3601"));
                                this.stopDataGatheringThread(false, null);
                            }
                        }
                    }
                }
                catch (DataInconsitsentException e) {
                    String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                    this.cleanup(message);
                }
                catch (Throwable e) {
                    if (e instanceof TimeOutException) {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3600"));
                        if (log.isLoggable(Level.FINE)) {
                            log.logp(Level.FINE, $CLASS_NAME, "run", Messages.getString((String)"GDE_MSGI3600"));
                        }
                    }
                    if (e instanceof UsbNotClaimedException) {
                        this.stopDataGatheringThread(false, e);
                    }
                    if (e instanceof UsbException) {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGE0050"));
                        this.stopDataGatheringThread(false, e);
                    }
                    log.log(Level.FINE, "data gathering end detected");
                    this.stopDataGatheringThread(true, e);
                }
                long delay = (lastCycleTime += 1000L) - System.nanoTime() / 1000000L;
                if (delay > 0L) {
                    WaitTimer.delay((long)delay);
                }
                if (!log.isLoggable(Level.TIME)) continue;
                log.log(Level.TIME, String.format("delay = %d", delay));
            }
            this.application.setStatusMessage("");
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
            }
            if (!this.isCollectDataStopped) {
                this.stopDataGatheringThread(false, null);
            }
        }
        catch (Exception e1) {
            log.log(Level.SEVERE, e1.getMessage(), e1);
        }
        finally {
            try {
                if (this.usbInterface != null) {
                    this.device.usbPort.closeUsbPort(this.usbInterface);
                    log.log(Level.FINE, "USB interface closed");
                }
            }
            catch (UsbException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        RecordSet recordSet;
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.usbPort != null && this.usbPort.getXferErrors() > 0) {
            log.log(Level.WARNING, "During complete data transfer " + this.usbPort.getXferErrors() + " number of errors occured!");
        }
        if (this.usbPort != null && this.usbPort.isConnected() && this.isPortOpenedByLiveGatherer && this.usbPort.isConnected()) {
            try {
                this.usbPort.closeUsbPort(null);
            }
            catch (UsbException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if ((recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null && recordSet.getRecordDataSize(true) > 5) {
            this.finalizeRecordSet(false);
            if (enableEndMessage) {
                this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGT3603"));
            }
        } else if (throwable != null) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage()}) + Messages.getString((String)"GDE_MSGT3602"));
        } else if (enableEndMessage) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0026") + Messages.getString((String)"GDE_MSGT3602"));
        }
    }

    void finalizeRecordSet(boolean doClosePort) {
        RecordSet tmpRecordSet;
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.usbPort.isConnected()) {
            try {
                this.usbPort.closeUsbPort(null);
            }
            catch (UsbException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, false);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        if (this.channel.get((Object)this.recordSetKey) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey)).clear();
            this.channel.remove(this.recordSetKey);
            if (Thread.currentThread().getId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey, true);
                this.application.openMessageDialog(this.dialog.getDialogShell(), message);
            } else {
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MC3000FmGathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        MC3000FmGathererThread.this.application.updateStatisticsData();
                        MC3000FmGathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        MC3000FmGathererThread.this.application.openMessageDialog(MC3000FmGathererThread.this.dialog.getDialogShell(), message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(this.dialog.getDialogShell(), message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    public UsbInterface getUsbInterface() {
        return this.usbInterface;
    }
}

