/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.GDE;
import gde.device.IDevice;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.ApplicationLauncher;
import gde.utils.FileUtils;
import gde.utils.WindowsHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;

public class OperatingSystemHelper {
    private static final Logger log = Logger.getLogger(OperatingSystemHelper.class.getName());
    private static final String STRING_LINK_POINTER = " -> ";

    public static boolean createDesktopLink() {
        boolean isCreated = false;
        URL url = FileUtils.class.getProtectionDomain().getCodeSource().getLocation();
        String sourceBasePath = url.getPath();
        if (url.getPath().endsWith("/")) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "started inside Eclipse -> skip creation of shortcut");
            }
        } else {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "started outside with: java -jar *.jar");
            }
            if (GDE.IS_WINDOWS) {
                try {
                    String launchFilename = "DataExplorer.exe";
                    sourceBasePath = sourceBasePath.substring(1, sourceBasePath.lastIndexOf(47) + 1).replace("%20", " ");
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "sourceBasePath = " + sourceBasePath);
                    }
                    String sourceLaunchFilePath = sourceBasePath + launchFilename;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "sourceLaunchFilePath = " + sourceLaunchFilePath);
                    }
                    String targetBasePath = System.getenv("USERPROFILE") + "/Desktop/";
                    String targetDesktopLaucherFilePath = targetBasePath + "DataExplorer.lnk";
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "fqShellLinkPath = " + targetDesktopLaucherFilePath);
                    }
                    String fqExecutablePath = sourceLaunchFilePath.replace("/", GDE.FILE_SEPARATOR);
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "fqExecutablePath = " + fqExecutablePath);
                    }
                    String executableArguments = "";
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "executableArguments = " + executableArguments);
                    }
                    String workingDirectory = sourceBasePath.replace("/", GDE.FILE_SEPARATOR);
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "workingDirectory = " + workingDirectory);
                    }
                    String fqIconPath = fqExecutablePath;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "fqIconPath = " + fqIconPath);
                    }
                    String description = Messages.getString("GDE_MSGT0000");
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "description = " + description);
                    }
                    String[] shellLinkArgs = new String[]{targetDesktopLaucherFilePath, fqExecutablePath, executableArguments, workingDirectory, fqIconPath, description};
                    WindowsHelper.createDesktopLink(shellLinkArgs[0], shellLinkArgs[1], shellLinkArgs[2], shellLinkArgs[3], shellLinkArgs[4], 0, shellLinkArgs[5]);
                    sourceBasePath = url.getPath();
                    launchFilename = "DevicePropertiesEditor.exe";
                    sourceBasePath = sourceBasePath.substring(1, sourceBasePath.lastIndexOf(47) + 1).replace("%20", " ");
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "sourceBasePath = " + sourceBasePath);
                    }
                    sourceLaunchFilePath = sourceBasePath + launchFilename;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "sourceLaunchFilePath = " + sourceLaunchFilePath);
                    }
                    targetBasePath = System.getenv("USERPROFILE") + "/Desktop/";
                    targetDesktopLaucherFilePath = targetBasePath + "DeviceProperties Editor.lnk";
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "fqShellLinkPath = " + targetDesktopLaucherFilePath);
                    }
                    fqExecutablePath = sourceLaunchFilePath.replace("/", GDE.FILE_SEPARATOR);
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "fqExecutablePath = " + fqExecutablePath);
                    }
                    executableArguments = "";
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "executableArguments = " + executableArguments);
                    }
                    fqIconPath = fqExecutablePath;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "fqIconPath = " + fqIconPath);
                    }
                    description = Messages.getString("GDE_MSGT0595");
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "description = " + description);
                    }
                    shellLinkArgs = new String[]{targetDesktopLaucherFilePath, fqExecutablePath, executableArguments, workingDirectory, fqIconPath, description};
                    WindowsHelper.createDesktopLink(shellLinkArgs[0], shellLinkArgs[1], shellLinkArgs[2], shellLinkArgs[3], shellLinkArgs[4], 0, shellLinkArgs[5]);
                    isCreated = true;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.getMessage());
                }
            } else if (GDE.IS_LINUX) {
                try {
                    String targetDesktopLaucherFilePath;
                    String targetBasePath;
                    String jarFilePath;
                    File targetFile;
                    sourceBasePath = sourceBasePath.substring(0, sourceBasePath.lastIndexOf(47) + 1);
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "sourceBasePath = " + sourceBasePath);
                    }
                    String desktopFileName = "DataExplorer.desktop";
                    String extractTargetFilePath = sourceBasePath + desktopFileName;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "extractTargetFilePath = " + extractTargetFilePath);
                    }
                    if ((targetFile = new File(extractTargetFilePath)).exists() && targetFile.canWrite()) {
                        jarFilePath = sourceBasePath + "DataExplorer.jar";
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "jarFilePath = " + jarFilePath);
                        }
                        FileUtils.extractWhileReplace("@GDE_DIR@", sourceBasePath, jarFilePath, desktopFileName, extractTargetFilePath, "UTF-8", "UTF-8");
                        targetBasePath = System.getenv("HOME") + "/Desktop/";
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "targetBasePath = " + targetBasePath);
                        }
                        targetDesktopLaucherFilePath = targetBasePath + desktopFileName;
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "targetDesktopLaucherFilePath = " + targetDesktopLaucherFilePath);
                        }
                        FileUtils.copyFile(new File(extractTargetFilePath), new File(targetDesktopLaucherFilePath));
                    } else {
                        log.log(Level.WARNING, extractTargetFilePath + " does not exist or does not have write (755) pernission, a desktop launcher can not created");
                    }
                    desktopFileName = "DevicePropertiesEditor.desktop";
                    extractTargetFilePath = sourceBasePath + desktopFileName;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "extractTargetFilePath = " + extractTargetFilePath);
                    }
                    if ((targetFile = new File(extractTargetFilePath)).exists() && targetFile.canWrite()) {
                        jarFilePath = sourceBasePath + "DataExplorer.jar";
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "jarFilePath = " + jarFilePath);
                        }
                        FileUtils.extractWhileReplace("@GDE_DIR@", sourceBasePath, jarFilePath, desktopFileName, extractTargetFilePath, "UTF-8", "UTF-8");
                        targetBasePath = System.getenv("HOME") + "/Desktop/";
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "targetBasePath = " + targetBasePath);
                        }
                        targetDesktopLaucherFilePath = targetBasePath + desktopFileName;
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "targetDesktopLaucherFilePath = " + targetDesktopLaucherFilePath);
                        }
                        FileUtils.copyFile(new File(extractTargetFilePath), new File(targetDesktopLaucherFilePath));
                    } else {
                        log.log(Level.WARNING, extractTargetFilePath + " does not exist or does not have write (755) pernission, a desktop launcher can not created");
                    }
                    isCreated = true;
                }
                catch (UnsupportedEncodingException e) {
                    log.log(Level.WARNING, e.getMessage());
                }
                catch (FileNotFoundException e) {
                    log.log(Level.WARNING, e.getMessage());
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.getMessage());
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.getMessage());
                }
            } else if (GDE.IS_MAC) {
                isCreated = true;
                log.log(Level.INFO, "No desktop link for OS " + System.getProperty("os.name"));
            } else {
                log.log(Level.WARNING, "not supported OS");
                DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGW0032", new Object[]{"createDesktopLink", System.getProperty("os.name")}));
                isCreated = true;
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "DataExplorer desktop created = " + isCreated);
        }
        return isCreated;
    }

    public static boolean removeDesktopLink() {
        boolean isRemoved = false;
        try {
            if (GDE.IS_WINDOWS) {
                String targetBasePath = System.getenv("USERPROFILE") + "\\Desktop\\";
                String targetDesktopLaucherFilePath = targetBasePath + "DataExplorer.lnk";
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "fqShellLinkPath = " + targetDesktopLaucherFilePath);
                }
                Process process = new ProcessBuilder("cmd", "/C", "erase", "/F", targetDesktopLaucherFilePath).start();
                process.waitFor();
                if (process.exitValue() != 0) {
                    log.log(Level.WARNING, "failed to remove desktop launcher " + targetBasePath);
                }
                targetDesktopLaucherFilePath = targetBasePath + "DeviceProperties*.lnk";
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "fqShellLinkPath = " + targetDesktopLaucherFilePath);
                }
                process = new ProcessBuilder("cmd", "/C", "erase", "/F", targetDesktopLaucherFilePath).start();
                process.waitFor();
                if (process.exitValue() != 0) {
                    log.log(Level.WARNING, "failed to remove desktop launcher " + targetBasePath);
                }
                isRemoved = true;
            } else if (GDE.IS_LINUX) {
                String desktopFileName = "DataExplorer.desktop";
                String targetBasePath = System.getenv("HOME") + "/Desktop/";
                log.log(Level.INFO, "targetBasePath = " + targetBasePath);
                String targetDesktopLaucherFilePath = targetBasePath + desktopFileName;
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "targetDesktopLaucherFilePath = " + targetDesktopLaucherFilePath);
                }
                Process process = new ProcessBuilder("rm", "-f", targetDesktopLaucherFilePath).start();
                process.waitFor();
                if (process.exitValue() != 0) {
                    log.log(Level.WARNING, "failed to remove desktop launcher " + desktopFileName);
                }
                desktopFileName = "DevicePropertiesEditor.desktop";
                targetBasePath = System.getenv("HOME") + "/Desktop/";
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "targetBasePath = " + targetBasePath);
                }
                targetDesktopLaucherFilePath = targetBasePath + desktopFileName;
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "targetDesktopLaucherFilePath = " + targetDesktopLaucherFilePath);
                }
                process = new ProcessBuilder("rm", "-f", targetDesktopLaucherFilePath).start();
                process.waitFor();
                if (process.exitValue() != 0) {
                    log.log(Level.WARNING, "failed to remove desktop launcher " + desktopFileName);
                }
                isRemoved = true;
            } else {
                DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGW0034", new Object[]{System.getProperty("os.name")}));
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerApplication() {
        int rc = -1;
        String targetDir = GDE.JAVA_IO_TMPDIR;
        Object command = " ";
        BufferedReader besr = null;
        BufferedReader bisr = null;
        try {
            URL url = FileUtils.class.getProtectionDomain().getCodeSource().getLocation();
            if (url.getPath().endsWith("/")) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "started inside Eclipse -> skip creation of shortcut");
                }
            } else {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "started outside with: java -jar *.jar");
                }
                String jarBasePath = FileUtils.getJarBasePath();
                String jarFilePath = jarBasePath + "/DataExplorer.jar";
                JarFile jarFile = new JarFile(jarFilePath);
                if (GDE.IS_WINDOWS) {
                    if (32 == DataExplorer.getInstance().openOkCancelMessageDialog(Messages.getString("GDE_MSGI0029"))) {
                        String line;
                        String regExe = "Register" + GDE.BIT_MODE + ".exe";
                        log.log(Level.INFO, "register exe = " + regExe);
                        FileUtils.extract(jarFile, regExe, "", targetDir, "WIN");
                        String targetBasePath = jarBasePath.replace('/', '\\');
                        targetBasePath = targetBasePath.startsWith("\\") ? targetBasePath.substring(1) : targetBasePath;
                        targetBasePath = targetBasePath.endsWith("\\") ? targetBasePath.substring(0, targetBasePath.length() - 1) : targetBasePath;
                        command = "cmd /C " + targetDir + regExe + " " + targetBasePath;
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "executing: " + (String)command);
                        }
                        Process process = new ProcessBuilder("cmd", "/C", targetDir + regExe, targetBasePath).start();
                        process.waitFor();
                        bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        StringBuilder sb = new StringBuilder();
                        while ((line = bisr.readLine()) != null) {
                            sb.append(line);
                        }
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "std.out = " + sb.toString());
                        }
                        sb = new StringBuilder();
                        while ((line = besr.readLine()) != null) {
                            sb.append(line);
                        }
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "std.err = " + sb.toString());
                        }
                        if (process.exitValue() != 0) {
                            String msg = "failed to execute \"" + (String)command + "\" rc = " + process.exitValue();
                            log.log(Level.SEVERE, msg);
                            if (msg.contains("740")) {
                                throw new IOException("error=740");
                            }
                            throw new UnsatisfiedLinkError(msg);
                        }
                        bisr.close();
                        besr.close();
                        command = "cmd /C assoc .osd";
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "executing \"" + (String)command + "\" to check association");
                        }
                        process = Runtime.getRuntime().exec((String)command);
                        process.waitFor();
                        bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        sb = new StringBuilder();
                        while ((line = bisr.readLine()) != null) {
                            sb.append(line);
                        }
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "std.out = " + sb.toString());
                        }
                        sb = new StringBuilder();
                        while ((line = besr.readLine()) != null) {
                            sb.append(line);
                        }
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "std.err = " + sb.toString());
                            log.log(Level.INFO, "\"" + (String)command + "\" rc = " + process.exitValue());
                        }
                        if (process.exitValue() != 0) {
                            log.log(Level.WARNING, "failed to register DataExplorer MIME type rc = " + process.exitValue());
                            throw new IOException("error=740");
                        }
                    }
                    rc = 0;
                } else if (GDE.IS_LINUX) {
                    File targetFile;
                    String desktopFileName = "DataExplorer.desktop";
                    String extractTargetFilePath = jarBasePath + desktopFileName;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "extractTargetFilePath = " + extractTargetFilePath);
                    }
                    if ((targetFile = new File(extractTargetFilePath)).exists() && targetFile.canWrite()) {
                        FileUtils.extractWhileReplace("@GDE_DIR@", jarBasePath, jarFilePath, desktopFileName, extractTargetFilePath, "UTF-8", "UTF-8");
                        desktopFileName = "DevicePropertiesEditor.desktop";
                        extractTargetFilePath = jarBasePath + desktopFileName;
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "extractTargetFilePath = " + extractTargetFilePath);
                        }
                        if ((targetFile = new File(extractTargetFilePath)).exists() && targetFile.canWrite()) {
                            FileUtils.extractWhileReplace("@GDE_DIR@", jarBasePath, jarFilePath, desktopFileName, extractTargetFilePath, "UTF-8", "UTF-8");
                        } else {
                            log.log(Level.WARNING, extractTargetFilePath + " does not exist or does not have write (755) pernission, the DataExplorer MIME-type can not registered");
                        }
                    } else {
                        log.log(Level.WARNING, extractTargetFilePath + " does not exist or does not have write (755) pernission, the DataExplorer MIME-type can not registered");
                    }
                    if (Runtime.getRuntime().exec("which xdg-mime").waitFor() != 0) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "DataExplorer program can not registered until xdg-utils are installed and in path");
                        }
                        DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGI0030"));
                        rc = 0;
                    } else {
                        FileUtils.extract(jarFile, "register.sh", "", targetDir, "555");
                        command = "chmod +x " + targetDir + "/register.sh";
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "executing: " + (String)command);
                        }
                        Runtime.getRuntime().exec((String)command).waitFor();
                        command = targetDir + "/register.sh";
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "executing: " + (String)command);
                        }
                        rc = Runtime.getRuntime().exec((String)command).waitFor();
                    }
                } else if (GDE.IS_MAC) {
                    DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGI0031"));
                    rc = 0;
                } else {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "Unsupported OS, shell integration, MIME registration NOT IMPLEMENTED");
                    }
                    DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGW0024", new Object[]{System.getProperty("os.name")}));
                    rc = 0;
                }
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            if (e.getMessage().contains("error=740") || e instanceof IOException) {
                DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGW0023", new Object[]{command}));
                rc = 0;
            } else if (e instanceof UnsatisfiedLinkError) {
                DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGE0037", new Object[]{e.getClass().getSimpleName()}) + Messages.getString("GDE_MSGI0033"));
            } else {
                DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGE0039"));
            }
        }
        finally {
            try {
                if (bisr != null) {
                    bisr.close();
                }
                if (besr != null) {
                    besr.close();
                }
            }
            catch (IOException url) {}
        }
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "DataExplorer MIME registered = " + (rc == 0));
        }
        return rc == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deregisterApplication() {
        int rc;
        block47: {
            rc = -1;
            String targetDir = GDE.JAVA_IO_TMPDIR;
            Object command = " ";
            String jarBasePath = FileUtils.getJarBasePath();
            String jarFilePath = jarBasePath + "/DataExplorer.jar";
            BufferedReader besr = null;
            BufferedReader bisr = null;
            try {
                JarFile jarFile = new JarFile(jarFilePath);
                if (GDE.IS_WINDOWS) {
                    String line;
                    try {
                        DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGI0029"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String regExe = "Register" + GDE.BIT_MODE + ".exe";
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "register exe = " + regExe);
                    }
                    FileUtils.extract(jarFile, regExe, "", targetDir, "WIN");
                    command = "cmd /C " + targetDir + regExe;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "executing: " + (String)command);
                    }
                    Process process = new ProcessBuilder("cmd", "/C", targetDir + regExe).start();
                    process.waitFor();
                    bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((line = bisr.readLine()) != null) {
                        sb.append(line);
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "std.out = " + sb.toString());
                    }
                    sb = new StringBuilder();
                    while ((line = besr.readLine()) != null) {
                        sb.append(line);
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "std.err = " + sb.toString());
                    }
                    if (process.exitValue() != 0) {
                        String msg = "failed to execute \"" + (String)command + "\" rc = " + process.exitValue();
                        log.log(Level.SEVERE, msg);
                        if (msg.contains("740")) {
                            throw new IOException("error=740");
                        }
                        throw new UnsatisfiedLinkError(msg);
                    }
                    bisr.close();
                    besr.close();
                    process = Runtime.getRuntime().exec("cmd /C assoc .osd");
                    process.waitFor();
                    bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    sb = new StringBuilder();
                    while ((line = bisr.readLine()) != null) {
                        sb.append(line);
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "std.out = " + sb.toString());
                    }
                    sb = new StringBuilder();
                    while ((line = besr.readLine()) != null) {
                        sb.append(line);
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "std.err = " + sb.toString());
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "\"cmd /C assoc .osd\" rc = " + process.exitValue());
                    }
                    if (process.exitValue() == 0) {
                        log.log(Level.WARNING, "failed to deregister DataExplorer MIME type to OS rc = " + process.exitValue());
                        throw new IOException("error=740");
                    }
                    rc = 0;
                    break block47;
                }
                if (GDE.IS_LINUX) {
                    File targetFile;
                    String desktopFileName = "DataExplorer.desktop";
                    String extractTargetFilePath = jarBasePath + desktopFileName;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "extractTargetFilePath = " + extractTargetFilePath);
                    }
                    if ((targetFile = new File(extractTargetFilePath)).exists() && targetFile.canWrite()) {
                        FileUtils.extractWhileReplace("@GDE_DIR@", jarBasePath, jarFilePath, desktopFileName, extractTargetFilePath, "UTF-8", "UTF-8");
                        desktopFileName = "DevicePropertiesEditor.desktop";
                        extractTargetFilePath = jarBasePath + desktopFileName;
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "extractTargetFilePath = " + extractTargetFilePath);
                        }
                        if ((targetFile = new File(extractTargetFilePath)).exists() && targetFile.canWrite()) {
                            FileUtils.extractWhileReplace("@GDE_DIR@", jarBasePath, jarFilePath, desktopFileName, extractTargetFilePath, "UTF-8", "UTF-8");
                        } else {
                            log.log(Level.WARNING, extractTargetFilePath + " does not exist or does not have write (755) pernission, the DataExplorer MIME-type can not registered");
                        }
                    } else {
                        log.log(Level.WARNING, extractTargetFilePath + " does not exist or does not have write (755) pernission, the DataExplorer MIME-type can not registered");
                    }
                    if (Runtime.getRuntime().exec("which xdg-mime").waitFor() != 0) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "DataExplorer program can not registered until xdg-utils are installed and in path");
                        }
                        DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGI0030"));
                        rc = 0;
                    } else {
                        FileUtils.extract(jarFile, "unregister.sh", "", targetDir, "555");
                        command = "chmod +x " + targetDir + "/unregister.sh";
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "executing: " + (String)command);
                        }
                        Runtime.getRuntime().exec((String)command).waitFor();
                        command = targetDir + "/unregister.sh";
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "executing: " + (String)command);
                        }
                        rc = Runtime.getRuntime().exec((String)command).waitFor();
                    }
                } else {
                    DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGI0032", new Object[]{System.getProperty("os.name")}));
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                if (e.getMessage().contains("error=740") || e instanceof IOException) {
                    DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGW0023", new Object[]{command}));
                    rc = 0;
                } else if (e instanceof UnsatisfiedLinkError) {
                    DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGE0037", new Object[]{e.getClass().getSimpleName()}) + Messages.getString("GDE_MSGI0033"));
                } else {
                    DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGE0039"));
                }
            }
            finally {
                try {
                    if (bisr != null) {
                        bisr.close();
                    }
                    if (besr != null) {
                        besr.close();
                    }
                }
                catch (IOException jarFile) {}
            }
        }
        return rc == 0;
    }

    public static void createFileLink(String fullQualifiedSourceFilePath, String fullQualifiedTargetFilePath) {
        try {
            if (FileUtils.checkFileExist((String)fullQualifiedTargetFilePath)) {
                if (128 == DataExplorer.getInstance().openYesNoMessageDialog(Messages.getString("GDE_MSGI0062", new Object[]{fullQualifiedTargetFilePath}))) {
                    return;
                }
                String existingSourcePath = OperatingSystemHelper.getLinkContainedFilePath((String)fullQualifiedTargetFilePath).replace('\\', '/');
                if (!existingSourcePath.equals(fullQualifiedSourceFilePath)) {
                    fullQualifiedTargetFilePath = ((String)fullQualifiedTargetFilePath).substring(0, ((String)fullQualifiedTargetFilePath).length() - 4) + "_.osd";
                    DataExplorer.getInstance().openMessageDialogAsync(Messages.getString("GDE_MSGW0033", new Object[]{fullQualifiedTargetFilePath, existingSourcePath, existingSourcePath, fullQualifiedTargetFilePath}));
                }
            }
            if (GDE.IS_WINDOWS) {
                try {
                    fullQualifiedSourceFilePath = fullQualifiedSourceFilePath.replace('/', '\\');
                    fullQualifiedTargetFilePath = ((String)fullQualifiedTargetFilePath).replace('/', '\\');
                    String sourceBasePath = fullQualifiedSourceFilePath.substring(0, fullQualifiedSourceFilePath.lastIndexOf(92) + 1);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "sourceBasePath = " + sourceBasePath);
                    }
                    String targetFileLinkPath = ((String)fullQualifiedTargetFilePath).replace('/', '\\');
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "targetFileLinkPath = " + targetFileLinkPath);
                    }
                    String[] shellLinkArgs = new String[]{targetFileLinkPath, fullQualifiedSourceFilePath, "", sourceBasePath, fullQualifiedSourceFilePath, ""};
                    WindowsHelper.createDesktopLink(shellLinkArgs[0], shellLinkArgs[1], shellLinkArgs[2], shellLinkArgs[3], shellLinkArgs[4], 0, shellLinkArgs[5]);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.getMessage());
                }
            } else if (GDE.IS_LINUX) {
                try {
                    String line;
                    String fullQualifiedLinkTargetPath = fullQualifiedSourceFilePath.replace('\\', '/');
                    String fullQualifiedLinkPath = ((String)fullQualifiedTargetFilePath).replace('\\', '/');
                    String command = "ln -s '" + fullQualifiedLinkTargetPath + "' '" + fullQualifiedLinkPath + "'";
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "executing: " + command);
                    }
                    Process process = new ProcessBuilder("ln", "-s", fullQualifiedLinkTargetPath, fullQualifiedLinkPath).start();
                    process.waitFor();
                    BufferedReader bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    BufferedReader besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((line = bisr.readLine()) != null) {
                        log.log(Level.FINE, "std.out = " + line);
                    }
                    while ((line = besr.readLine()) != null) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "std.err = " + line);
                    }
                    if (process.exitValue() != 0) {
                        String msg = "failed to execute \"" + command + "\" rc = " + process.exitValue();
                        log.log(Level.SEVERE, msg);
                    }
                    besr.close();
                    bisr.close();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.getMessage());
                }
            } else if (GDE.IS_MAC) {
                fullQualifiedSourceFilePath = fullQualifiedSourceFilePath.replace('\\', '/');
                fullQualifiedTargetFilePath = ((String)fullQualifiedTargetFilePath).replace('\\', '/');
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "sourceBasePath = " + fullQualifiedSourceFilePath + ", targetFileLinkPath = " + (String)fullQualifiedTargetFilePath);
                }
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)fullQualifiedTargetFilePath), "UTF-8"));
                writer.write(fullQualifiedSourceFilePath);
                writer.write(GDE.LINE_SEPARATOR);
                writer.close();
            } else {
                log.log(Level.WARNING, "not supported OS");
                DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGI0035", new Object[]{System.getProperty("os.name")}));
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public static boolean isLinkContained(String filePath) throws IOException {
        filePath = filePath.replace('\\', '/');
        boolean isFileLink = false;
        Object line = "";
        if (GDE.IS_WINDOWS) {
            boolean isZippedFile = false;
            try (ZipInputStream zip_input = new ZipInputStream(new FileInputStream(new File(filePath)));){
                isZippedFile = zip_input.getNextEntry() != null;
            }
            if (!isZippedFile) {
                char[] tmpChars = new char[25];
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));){
                    if (reader.read(tmpChars) != 25) {
                        log.log(Level.WARNING, "failed reading " + filePath);
                    }
                }
                line = new String(tmpChars);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "line = " + (String)line);
                }
                if (!(((String)line).isEmpty() || ((String)line).contains("DataExplorer") || ((String)line).contains("OpenSerialData"))) {
                    isFileLink = true;
                }
            }
        } else if (GDE.IS_LINUX) {
            try {
                String command = "ls -al " + filePath;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "executing: " + command);
                }
                Process process = new ProcessBuilder("ls", "-al", filePath).start();
                process.waitFor();
                BufferedReader bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = bisr.readLine()) != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "std.out = " + (String)line);
                    }
                    if (!((String)line).contains(STRING_LINK_POINTER)) continue;
                    isFileLink = true;
                }
                while ((line = besr.readLine()) != null) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "std.err = " + (String)line);
                }
                if (process.exitValue() != 0) {
                    String msg = "failed to execute \"" + command + "\" rc = " + process.exitValue();
                    log.log(Level.SEVERE, msg);
                }
                besr.close();
                bisr.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else if (GDE.IS_MAC) {
            ZipInputStream zip_input = new ZipInputStream(new FileInputStream(new File(filePath)));
            if (zip_input.getNextEntry() == null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
                char[] tmpChars = new char[25];
                if (25 != reader.read(tmpChars)) {
                    log.log(Level.WARNING, "failed to read from " + filePath);
                }
                line = new String(tmpChars);
                log.log(Level.FINE, "line = " + (String)line);
                if (!((String)line).contains("DataExplorer") && !((String)line).contains("OpenSerialData")) {
                    line = (String)line + reader.readLine();
                    isFileLink = true;
                }
                reader.close();
            }
            zip_input.close();
        } else {
            log.log(Level.WARNING, "Operating System implementation not available");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "isFileLink " + isFileLink);
        }
        return isFileLink;
    }

    public static String getLinkContainedFilePath(String filePath) throws IOException {
        String ret = filePath = filePath.replace('\\', '/');
        Object line = "";
        if (GDE.IS_WINDOWS) {
            boolean isZippedFile = false;
            try (ZipInputStream zip_input = new ZipInputStream(new FileInputStream(new File(filePath)));){
                isZippedFile = zip_input.getNextEntry() != null;
            }
            if (!isZippedFile) {
                char[] tmpChars = new char[25];
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));){
                    if (reader.read(tmpChars) != 25) {
                        log.log(Level.WARNING, "failed reading " + filePath);
                    }
                }
                line = new String(tmpChars);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "line = " + (String)line);
                }
                if (!(((String)line).isEmpty() || ((String)line).contains("DataExplorer") || ((String)line).contains("OpenSerialData"))) {
                    log.log(Level.FINE, "source filePath = " + filePath);
                    ret = WindowsHelper.getFilePathFromLink(filePath);
                    log.log(Level.FINE, "returned FilePath = " + ret);
                    if (ret.startsWith("GDE_MSGE")) {
                        String msgKey = ret.split(";")[0];
                        String msgValue = ret.split("; ")[1];
                        throw new UnsatisfiedLinkError(filePath + " - " + Messages.getString(msgKey, new Object[]{msgValue}));
                    }
                }
            }
        } else if (GDE.IS_LINUX) {
            try {
                String command = "ls -al " + filePath;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "executing: " + command);
                }
                Process process = new ProcessBuilder("ls", "-al", filePath).start();
                process.waitFor();
                BufferedReader bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = bisr.readLine()) != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "std.out = " + (String)line);
                    }
                    if (!((String)line).contains(STRING_LINK_POINTER)) continue;
                    ret = ((String)line).split(STRING_LINK_POINTER)[1].trim();
                }
                while ((line = besr.readLine()) != null) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "std.err = " + (String)line);
                }
                if (process.exitValue() != 0) {
                    String msg = "failed to execute \"" + command + "\" rc = " + process.exitValue();
                    log.log(Level.SEVERE, msg);
                }
                besr.close();
                bisr.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else if (GDE.IS_MAC) {
            ZipInputStream zip_input = new ZipInputStream(new FileInputStream(new File(filePath)));
            if (zip_input.getNextEntry() == null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
                char[] tmpChars = new char[25];
                if (25 != reader.read(tmpChars)) {
                    log.log(Level.WARNING, "failed to read from " + filePath);
                }
                line = new String(tmpChars);
                log.log(Level.FINE, "line = " + (String)line);
                if (!((String)line).contains("DataExplorer") && !((String)line).contains("OpenSerialData")) {
                    line = (String)line + reader.readLine();
                    ret = ((String)line).trim();
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "returned FilePath = " + ret);
                    }
                }
                reader.close();
            }
            zip_input.close();
        } else {
            log.log(Level.WARNING, "Operating System implementation not available");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, ret);
        }
        return ret;
    }

    public static String getClasspathAsString() {
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        URL[] urls = ((URLClassLoader)sysClassLoader).getURLs();
        StringBuilder sb = new StringBuilder();
        String pathSeparator = System.getProperty("path.separator");
        for (URL url : urls) {
            sb.append(url.getFile()).append(pathSeparator);
        }
        return sb.toString();
    }

    public static void printClassLoader() {
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        URL[] urls = ((URLClassLoader)sysClassLoader).getURLs();
        StringBuilder sb = new StringBuilder().append("SystemClassLoader = ");
        String pathSeparator = System.getProperty("path.separator");
        for (URL url : urls) {
            sb.append(url.getFile()).append(pathSeparator);
        }
        log.log(Level.INFO, sb.toString());
    }

    public static boolean isUucpMember() {
        boolean isMember = false;
        try {
            String line;
            String command = "groups";
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "executing: " + command);
            }
            Process process = new ProcessBuilder(command).start();
            process.waitFor();
            BufferedReader bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = bisr.readLine()) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "std.out = " + line);
                }
                if (!line.contains("uucp")) continue;
                isMember = true;
            }
            while ((line = besr.readLine()) != null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "std.err = " + line);
            }
            if (process.exitValue() != 0) {
                String msg = "failed to execute \"" + command + "\" rc = " + process.exitValue();
                log.log(Level.SEVERE, msg);
            }
            besr.close();
            bisr.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return isMember;
    }

    public static String dereferenceLink(String directory, String grepChunk) {
        String result = grepChunk;
        try {
            String line;
            String[] command = new String[]{"/bin/sh", "-c", "ls -l " + directory + " | grep " + grepChunk};
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "executing: ls -l " + directory + " | grep " + grepChunk);
            }
            Process process = new ProcessBuilder(command).start();
            process.waitFor();
            BufferedReader bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = bisr.readLine()) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "std.out = " + line);
                }
                if (!line.contains("->")) continue;
                result = line.substring(0, line.lastIndexOf("->") - 1);
            }
            while ((line = besr.readLine()) != null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "std.err = " + line);
            }
            besr.close();
            bisr.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return result;
    }

    public static void launchGoogleEarth(IDevice activeDevice) {
        ApplicationLauncher launcher = GDE.IS_MAC ? new ApplicationLauncher("open", new String[]{"Google Earth"}, "/Applications/Google Earth.app") : (GDE.IS_LINUX ? new ApplicationLauncher("xdg-open", new String[]{"googleearth", "google-earth"}, "which") : new ApplicationLauncher("rundll32.exe", new String[]{"Google Earth.kmzfile", "Google Earth.kmlfile"}, "Registry - HKEY_CLASSES_ROOT und HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes"));
        if (launcher.isLaunchable()) {
            String kmzFilePath = activeDevice.exportFile("kmz", true);
            ArrayList<String> argumentList = new ArrayList<String>();
            argumentList.add(kmzFilePath);
            launcher.execute(argumentList);
        }
    }

    public static void launchInstallApplication(String installablePath) {
        ApplicationLauncher launcher;
        if (GDE.IS_MAC) {
            launcher = new ApplicationLauncher("open", new String[0], "");
        } else if (GDE.IS_LINUX) {
            URL url = GDE.class.getProtectionDomain().getCodeSource().getLocation();
            if (url.getFile().endsWith(".jar")) {
                String installpath = url.getFile().substring(0, url.getPath().lastIndexOf(47));
                installpath = installpath.substring(0, installpath.lastIndexOf(47));
                String command = "cd " + installpath + "\nsudo tar -xzf " + installablePath + "\"";
                DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGI0055", new String[]{command}));
            }
            launcher = new ApplicationLauncher("bash", new String[0], "");
        } else {
            launcher = new ApplicationLauncher("rundll32.exe", new String[0], "");
        }
        if (launcher.isLaunchable()) {
            ArrayList<String> argumentList = new ArrayList<String>();
            argumentList.add(installablePath);
            launcher.execute(argumentList);
        }
    }
}

