/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.transitions;

import gde.data.RecordSet;
import gde.histo.transitions.Transition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class GroupTransitions {
    private final Map<Integer, TransitionChronicle> groupTransitions = new HashMap<Integer, TransitionChronicle>();
    private final RecordSet recordSet;
    private final int recordDataSize;

    public GroupTransitions(RecordSet recordSet) {
        this.recordSet = recordSet;
        this.recordDataSize = recordSet.getRecordDataSize(true);
    }

    public boolean isGatheringMode(RecordSet currentRecordSet) {
        if (!currentRecordSet.equals(this.recordSet)) {
            throw new IllegalArgumentException();
        }
        return this.recordDataSize != currentRecordSet.getRecordDataSize(true);
    }

    public boolean isEmpty() {
        return this.groupTransitions.isEmpty();
    }

    public TransitionChronicle get(int transitionGroupId) {
        return this.groupTransitions.get(transitionGroupId);
    }

    public TransitionChronicle put(int transitionGroupId, TransitionChronicle transitions) {
        return this.groupTransitions.put(transitionGroupId, transitions);
    }

    public boolean containsKey(int transitionGroupId) {
        return this.groupTransitions.containsKey(transitionGroupId);
    }

    public static final class TransitionChronicle {
        private final TreeMap<Long, Transition> transitionChronicle;

        public TransitionChronicle() {
            this.transitionChronicle = new TreeMap();
        }

        public TransitionChronicle(TransitionChronicle transitionChronicle) {
            this.transitionChronicle = new TreeMap<Long, Transition>((SortedMap<Long, Transition>)transitionChronicle.transitionChronicle);
        }

        public Transition get(long thresholdStartTimestamp_ms) {
            return this.transitionChronicle.get(thresholdStartTimestamp_ms);
        }

        public Transition put(long thresholdStartTimestamp_ms, Transition transition) {
            return this.transitionChronicle.put(thresholdStartTimestamp_ms, transition);
        }

        public boolean isEmpty() {
            return this.transitionChronicle.isEmpty();
        }

        public Collection<? extends Long> keySet() {
            return this.transitionChronicle.keySet();
        }

        public Map.Entry<Long, Transition> ceilingEntry(long thresholdStartTimeStamp_ms) {
            return this.transitionChronicle.ceilingEntry(thresholdStartTimeStamp_ms);
        }

        public Transition remove(long thresholdStartTimeStamp_ms) {
            return this.transitionChronicle.remove(thresholdStartTimeStamp_ms);
        }

        public Set<Map.Entry<Long, Transition>> entrySet() {
            return this.transitionChronicle.entrySet();
        }

        public Collection<Transition> values() {
            return this.transitionChronicle.values();
        }

        public void putAll(TransitionChronicle newTransitions) {
            this.transitionChronicle.putAll(newTransitions.transitionChronicle);
        }

        public String toString() {
            return "TransitionChronicle [transitionChronicleSize=" + this.transitionChronicle.size() + ", transitionChronicle=" + String.valueOf(this.transitionChronicle) + "]";
        }
    }
}

