/****************************************************************************
**
*W  permutat.h                  GAP source                   Martin Schönert
**                                                           & Alice Niemeyer
**
**
*Y  Copyright (C)  1996,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
**
**  This file defines the functions for permutations (small and large).
*/

#ifndef libGAP_GAP_PERMUTAT_H
#define libGAP_GAP_PERMUTAT_H


/****************************************************************************
**

*F  NEW_PERM2(<deg>)  . . . . . . . . . . . .  make a new (small) permutation
*F  DEG_PERM2(<perm>) . . . . . . . . . . . . . degree of (small) permutation
*F  ADDR_PERM2(<perm>)  . . . . . . . absolute address of (small) permutation
*F  NEW_PERM4(<deg>)  . . . . . . . . . . . .  make a new (large) permutation
*F  DEG_PERM4(<perm>) . . . . . . . . . . . . . degree of (large) permutation
*F  ADDR_PERM4(<perm>)  . . . . . . . absolute address of (large) permutation
*/
#define libGAP_NEW_PERM2(deg)          libGAP_NewBag( libGAP_T_PERM2, (deg) * sizeof(libGAP_UInt2))
#define libGAP_DEG_PERM2(perm)         (libGAP_SIZE_OBJ(perm) / sizeof(libGAP_UInt2))
#define libGAP_ADDR_PERM2(perm)        ((libGAP_UInt2*)libGAP_ADDR_OBJ(perm))
#define libGAP_NEW_PERM4(deg)          libGAP_NewBag( libGAP_T_PERM4, (deg) * sizeof(libGAP_UInt4))
#define libGAP_DEG_PERM4(perm)         (libGAP_SIZE_OBJ(perm) / sizeof(libGAP_UInt4))
#define libGAP_ADDR_PERM4(perm)        ((libGAP_UInt4*)libGAP_ADDR_OBJ(perm))


/****************************************************************************
**
*V  IdentityPerm  . . . . . . . . . . . . . . . . . . .  identity permutation
**
**  'IdentityPerm' is an identity permutation.
*/
extern  libGAP_Obj             libGAP_IdentityPerm;


/****************************************************************************
**
*F  OnTuplesPerm( <tup>, <perm> )  . . . .  operations on tuples of points
**
**  'OnTuplesPerm'  returns  the  image  of  the  tuple  <tup>   under  the
**  permutation <perm>.  It is called from 'FunOnTuples'.
*/
extern  libGAP_Obj             libGAP_OnTuplesPerm (
            libGAP_Obj                 tup,
            libGAP_Obj                 perm );


/****************************************************************************
**
*F  OnSetsPerm( <set>, <perm> ) . . . . . . . .  operations on sets of points
**
**  'OnSetsPerm' returns the  image of the  tuple <set> under the permutation
**  <perm>.  It is called from 'FunOnSets'.
*/
extern  libGAP_Obj             libGAP_OnSetsPerm (
            libGAP_Obj                 set,
            libGAP_Obj                 perm );


/****************************************************************************
**
*F  Array2Perm( <array> ) . . . . . . . . . convert array of cycles into perm
*/
extern libGAP_Obj libGAP_Array2Perm (
    libGAP_Obj                 array );


/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/

/****************************************************************************
**

*F  InitInfoPermutat()  . . . . . . . . . . . . . . . table of init functions
*/
libGAP_StructInitInfo * libGAP_InitInfoPermutat ( void );


#endif // GAP_PERMUTAT_H

/****************************************************************************
**

*E  permutat.c  . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
