untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8opmpTbQxWTEe33ykjSI9h/fJIEjsvcionUGKMD6KNIIhTzFOGOBGd8QWZLnrINLjvwWSMIF1kvlsr+rtNbTdwAE=

OpenBSD 7.6 errata 023, September 30, 2025:

Fix out-of-bounds read and write, memory leaks and incorrect error
check for CMS enveloped data.

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 023_libcrypto.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
    cd /usr/src/lib/libcrypto
    make obj
    make
    make install

Index: lib/libcrypto/cms/cms_pwri.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/cms/cms_pwri.c,v
diff -u -p -r1.31 cms_pwri.c
--- lib/libcrypto/cms/cms_pwri.c	14 Jan 2024 18:40:24 -0000	1.31
+++ lib/libcrypto/cms/cms_pwri.c	26 Sep 2025 19:29:15 -0000
@@ -267,7 +267,7 @@ kek_unwrap_key(unsigned char *out, size_
 		/* Check byte failure */
 		goto err;
 	}
-	if (inlen < (size_t)(tmp[0] - 4)) {
+	if (inlen < 4 + (size_t)tmp[0]) {
 		/* Invalid length value */
 		goto err;
 	}
@@ -368,13 +368,13 @@ cms_RecipientInfo_pwri_crypt(CMS_Content
 	kekcipher = EVP_get_cipherbyobj(kekalg->algorithm);
 	if (!kekcipher) {
 		CMSerror(CMS_R_UNKNOWN_CIPHER);
-		return 0;
+		goto err;
 	}
 
 	kekctx = EVP_CIPHER_CTX_new();
 	if (kekctx == NULL) {
 		CMSerror(ERR_R_MALLOC_FAILURE);
-		return 0;
+		goto err;
 	}
 	/* Fixup cipher based on AlgorithmIdentifier to set IV etc */
 	if (!EVP_CipherInit_ex(kekctx, kekcipher, NULL, NULL, NULL, en_de))
@@ -389,8 +389,8 @@ cms_RecipientInfo_pwri_crypt(CMS_Content
 
 	/* Finish password based key derivation to setup key in "ctx" */
 
-	if (EVP_PBE_CipherInit(algtmp->algorithm, (char *)pwri->pass,
-	    pwri->passlen, algtmp->parameter, kekctx, en_de) < 0) {
+	if (!EVP_PBE_CipherInit(algtmp->algorithm, (char *)pwri->pass,
+	    pwri->passlen, algtmp->parameter, kekctx, en_de)) {
 		CMSerror(ERR_R_EVP_LIB);
 		goto err;
 	}
