/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.impl;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.Field;
import javax.swing.RepaintManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationEx;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationManagerEx;

@ApiStatus.Internal
public final class InvocationUtil {
    @NotNull
    public static final Class<? extends Runnable> REPAINT_PROCESSING_CLASS = InvocationUtil.findProcessingClass();
    @NotNull
    private static final Field INVOCATION_EVENT_RUNNABLE_FIELD = InvocationUtil.findRunnableField();

    private InvocationUtil() {
    }

    @NotNull
    private static Class<? extends Runnable> findProcessingClass() {
        Class<Runnable> clazz;
        try {
            clazz = Class.forName("javax.swing.RepaintManager$ProcessingRunnable", false, InvocationUtil.class.getClassLoader()).asSubclass(Runnable.class);
        }
        catch (ClassNotFoundException e) {
            throw new InternalAPIChangedException(RepaintManager.class, e);
        }
        if (clazz == null) {
            InvocationUtil.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    @NotNull
    private static Field findRunnableField() {
        for (Class aClass = InvocationEvent.class; aClass != null; aClass = aClass.getSuperclass()) {
            Field field;
            try {
                Field result2 = aClass.getDeclaredField("runnable");
                result2.setAccessible(true);
                field = result2;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            if (field == null) {
                InvocationUtil.$$$reportNull$$$0(3);
            }
            return field;
        }
        throw new InternalAPIChangedException(InvocationEvent.class, new NoSuchFieldException("Class: " + InvocationEvent.class + " fieldName: runnable fieldType: " + Runnable.class));
    }

    public static boolean priorityEventPending() {
        AWTEvent event;
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (app != null) {
            app.flushNativeEventQueue();
        }
        return (event = Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent()) != null && event.getClass().getName().equals("sun.awt.PeerEvent");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/InvocationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/InvocationUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findProcessingClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findRunnableField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFlushNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractRunnable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class InternalAPIChangedException
    extends RuntimeException {
        InternalAPIChangedException(@NotNull Class<?> targetClass, @Nullable ReflectiveOperationException cause) {
            if (targetClass == null) {
                InternalAPIChangedException.$$$reportNull$$$0(0);
            }
            super(targetClass + " class internal API has been changed", cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/kotlin/com/intellij/openapi/application/impl/InvocationUtil$InternalAPIChangedException", "<init>"));
        }
    }
}

