from __future__ import annotations

from typing import Any
from typing import List
from typing import Tuple
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from alembic.autogenerate import RevisionContext


class CommandError(Exception):
    """Base command error for all exceptions"""


class DatabaseNotAtHead(CommandError):
    """Indicates the database is not at current head revisions.

    Raised by the :func:`.command.current` command when the
    :paramref:`.command.current.check_heads` parameter is used.

    .. versionadded:: 1.17.1

    """


class AutogenerateDiffsDetected(CommandError):
    """Raised when diffs were detected by the :func:`.command.check`
    command.

    .. versionadded:: 1.9.0

    """

    def __init__(
        self,
        message: str,
        revision_context: RevisionContext,
        diffs: List[Tuple[Any, ...]],
    ) -> None:
        super().__init__(message)
        self.revision_context = revision_context
        self.diffs = diffs
