/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.decompiler.CancelationManager;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ContextUnit {
    private static AtomicInteger THREAD_ID = new AtomicInteger(0);
    private final IContextSource source;
    private final boolean own;
    private final boolean root;
    private final IResultSaver resultSaver;
    private final IDecompiledData decompiledData;
    private volatile boolean entriesInitialized;
    private List<String> classEntries = List.of();
    private List<String> dirEntries = List.of();
    private List<IContextSource.Entry> otherEntries = List.of();
    private List<IContextSource> childContexts = List.of();

    public ContextUnit(IContextSource source, boolean own, boolean root, IResultSaver resultSaver, IDecompiledData decompiledData) {
        this.source = source;
        this.own = own;
        this.root = root;
        this.resultSaver = resultSaver;
        this.decompiledData = decompiledData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEntries() {
        if (this.isLazy()) {
            return;
        }
        if (!this.entriesInitialized) {
            ContextUnit contextUnit = this;
            synchronized (contextUnit) {
                if (!this.entriesInitialized) {
                    IContextSource.Entries entries = this.source.getEntries();
                    this.classEntries = entries.classes().stream().filter(ent -> ent.multirelease() == -1).map(entry -> entry.basePath()).collect(Collectors.toUnmodifiableList());
                    this.dirEntries = entries.directories();
                    boolean includeExtras = !DecompilerContext.getOption("skip-extra-files");
                    this.otherEntries = new ArrayList<IContextSource.Entry>();
                    for (IContextSource.Entry entry2 : entries.others()) {
                        if ("fernflower_abstract_parameter_names.txt".equals(entry2.basePath())) {
                            try (InputStream is = this.source.getInputStream(entry2);){
                                byte[] data = is.readAllBytes();
                                DecompilerContext.getStructContext().loadAbstractMetadata(new String(data, StandardCharsets.UTF_8));
                            }
                            catch (IOException ex) {
                                DecompilerContext.getLogger().writeMessage("Failed to load abstract parameter names file", IFernflowerLogger.Severity.ERROR, ex);
                            }
                            continue;
                        }
                        if (!includeExtras) continue;
                        this.otherEntries.add(entry2);
                    }
                    this.childContexts = entries.childContexts();
                    this.entriesInitialized = true;
                }
            }
        }
    }

    public List<String> getClassNames() {
        this.initEntries();
        return this.classEntries;
    }

    public boolean hasClass(String className) throws IOException {
        return this.source.hasClass(className);
    }

    public byte[] getClassBytes(String className) throws IOException {
        return this.source.getClassBytes(className);
    }

    public List<String> getDirectoryNames() {
        this.initEntries();
        return this.dirEntries;
    }

    public List<IContextSource.Entry> getOtherEntries() {
        this.initEntries();
        return this.otherEntries;
    }

    public List<IContextSource> getChildContexts() {
        this.initEntries();
        return this.childContexts;
    }

    public String getName() {
        return this.source.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        ContextUnit contextUnit = this;
        synchronized (contextUnit) {
            this.entriesInitialized = false;
            this.classEntries = List.of();
            this.dirEntries = List.of();
            this.otherEntries = List.of();
        }
    }

    public void save(Function<String, StructClass> loader) throws IOException {
        this.initEntries();
        IContextSource.IOutputSink sink = this.source.createOutputSink(this.resultSaver);
        if (sink == null) {
            throw new IllegalStateException("Context source " + String.valueOf(this.source) + " cannot be saved, but had a save requested.");
        }
        sink.begin();
        for (String dirEntry : this.dirEntries) {
            sink.acceptDirectory(dirEntry);
        }
        for (IContextSource.Entry otherEntry : this.otherEntries) {
            sink.acceptOther(otherEntry.path());
        }
        ArrayList futures = new ArrayList();
        int threads = Integer.parseInt((String)DecompilerContext.getProperty("thread-count"));
        if (threads <= 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        ForkJoinPool pool = new ForkJoinPool(threads, ContextUnit.namingScheme(), null, true);
        DecompilerContext rootContext = DecompilerContext.getCurrentContext();
        ArrayList<ClassContext> toDump = new ArrayList<ClassContext>(this.classEntries.size());
        LinkedHashSet<String> seen = new LinkedHashSet<String>();
        for (int i = 0; i < this.classEntries.size(); ++i) {
            StructClass cl = loader.apply(this.classEntries.get(i));
            String entryName = this.decompiledData.getClassEntryName(cl, this.classEntries.get(i));
            if (entryName == null) continue;
            if (seen.add(cl.qualifiedName)) {
                toDump.add(new ClassContext(cl, entryName));
                continue;
            }
            DecompilerContext.getLogger().writeMessage("Skipping writing already existing class: " + cl.qualifiedName, IFernflowerLogger.Severity.ERROR);
        }
        for (ClassContext classCtx : toDump) {
            futures.add(pool.submit(() -> {
                this.setContext(rootContext);
                classCtx.ctx = DecompilerContext.getCurrentContext();
                try {
                    this.decompiledData.processClass(classCtx.cl);
                }
                catch (Throwable thr) {
                    DecompilerContext.getLogger().writeMessage("Class " + classCtx.cl.qualifiedName + " couldn't be fully decompiled.", thr);
                    classCtx.onError(thr);
                }
                finally {
                    DecompilerContext.setCurrentContext(null);
                }
            }));
        }
        ContextUnit.waitForAll(futures);
        futures.clear();
        for (ClassContext classCtx : toDump) {
            if (classCtx.pendingError != null) {
                TextBuffer buf = new TextBuffer();
                ClassWriter.writeException(buf, classCtx.pendingError);
                classCtx.classContent = buf.convertToStringAndAllowDataDiscard();
                continue;
            }
            futures.add(pool.submit(() -> {
                DecompilerContext.setCurrentContext(classCtx.ctx);
                classCtx.classContent = this.decompiledData.getClassContent(classCtx.cl);
                if (DecompilerContext.getOption("bytecode-source-mapping")) {
                    classCtx.mapping = DecompilerContext.getBytecodeSourceMapper().getOriginalLinesMapping();
                }
            }));
        }
        ContextUnit.waitForAll(futures);
        futures.clear();
        pool.shutdown();
        THREAD_ID.set(0);
        for (ClassContext cls : toDump) {
            if (cls.classContent == null) continue;
            sink.acceptClass(cls.cl.qualifiedName, cls.entryName, cls.classContent, cls.mapping);
        }
        sink.close();
    }

    private static ForkJoinPool.ForkJoinWorkerThreadFactory namingScheme() {
        return pool -> {
            ForkJoinWorkerThread thread = new ForkJoinWorkerThread(pool){};
            thread.setName("Vineflower-DecompilerThread-" + THREAD_ID.getAndIncrement());
            return thread;
        };
    }

    public void setContext(DecompilerContext rootContext) {
        DecompilerContext current = DecompilerContext.getCurrentContext();
        if (current == null) {
            current = new DecompilerContext(new HashMap<String, Object>(rootContext.properties), rootContext.logger, rootContext.structContext, rootContext.classProcessor, rootContext.poolInterceptor);
            current.renamerFactory = rootContext.renamerFactory;
            DecompilerContext.setCurrentContext(current);
        }
    }

    private static void waitForAll(List<Future<?>> futures) {
        for (int i = futures.size() - 1; i >= 0; --i) {
            Future<?> future = futures.get(i);
            try {
                future.get();
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CancelationManager.CanceledException) {
                    throw (CancelationManager.CanceledException)e.getCause();
                }
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isOwn() {
        return this.own;
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean isLazy() {
        return !this.own && this.source.isLazy();
    }

    void close() throws Exception {
        if (this.source instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.source)).close();
        }
        this.clear();
    }

    static final class ClassContext {
        private final StructClass cl;
        DecompilerContext ctx;
        private final String entryName;
        String classContent;
        int[] mapping;
        private Throwable pendingError;

        ClassContext(StructClass cl, String entryName) {
            this.cl = cl;
            this.entryName = entryName;
        }

        void onError(Throwable thr) {
            if (this.pendingError == null) {
                this.pendingError = thr;
                return;
            }
            this.pendingError.addSuppressed(thr);
        }
    }
}

