/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.networknt.schema.AbsoluteIri;
import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.net.URI;
import java.net.URLEncoder;

public class AbsoluteIris {
    public static String toUri(AbsoluteIri iri) {
        String iriString = iri.toString();
        boolean ascii = AbsoluteIris.isAscii(iriString);
        if (ascii) {
            int index = iriString.indexOf(63);
            if (index == -1) {
                return iriString;
            }
            String rest = iriString.substring(0, index + 1);
            String query = iriString.substring(index + 1);
            StringBuilder result = new StringBuilder(rest);
            AbsoluteIris.handleQuery(result, query);
            return result.toString();
        }
        String[] parts = iriString.split(":");
        if (parts.length == 2) {
            StringBuilder result = new StringBuilder(parts[0]);
            result.append(":");
            String rest = parts[1];
            if (rest.startsWith("//")) {
                rest = rest.substring(2);
                result.append("//");
            } else if (rest.startsWith("/")) {
                rest = rest.substring(1);
                result.append("/");
            }
            String[] query = rest.split("\\?");
            String[] restParts = query[0].split("/");
            for (int x = 0; x < restParts.length; ++x) {
                String p = restParts[x];
                if (x == 0) {
                    if (AbsoluteIris.isAscii(p)) {
                        result.append(p);
                    } else {
                        result.append(AbsoluteIris.unicodeToASCII(p));
                    }
                } else {
                    result.append(p);
                }
                if (x == restParts.length - 1) continue;
                result.append("/");
            }
            if (query[0].endsWith("/")) {
                result.append("/");
            }
            if (query.length == 2) {
                result.append("?");
                AbsoluteIris.handleQuery(result, query[1]);
            }
            return URI.create(result.toString()).toASCIIString();
        }
        return iriString;
    }

    static boolean isAscii(String value) {
        return value.codePoints().allMatch(ch -> ch < 127);
    }

    static void handleQuery(StringBuilder result, String query) {
        String[] queryParts = query.split("&");
        for (int y = 0; y < queryParts.length; ++y) {
            String queryPart = queryParts[y];
            String[] nameValue = queryPart.split("=");
            try {
                result.append(URLEncoder.encode(nameValue[0], "UTF-8"));
                if (nameValue.length == 2) {
                    result.append("=");
                    result.append(URLEncoder.encode(nameValue[1], "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
            if (y == queryParts.length - 1) continue;
            result.append("&");
        }
    }

    static String unicodeToASCII(String input) {
        try {
            String ascii = IDN.toASCII(input);
            if (IDNBUGHOLDER.IDN_TOASCII_PRESERVES_TRAILING_DOTS) {
                return ascii;
            }
            int length = input.length();
            if (length == 0) {
                return input;
            }
            char lastChar = input.charAt(length - 1);
            switch (lastChar) {
                case '.': 
                case '\u3002': 
                case '\uff0e': 
                case '\uff61': {
                    return ascii + ".";
                }
            }
            return ascii;
        }
        catch (IllegalArgumentException e) {
            return input;
        }
    }

    private static class IDNBUGHOLDER {
        private static final boolean IDN_TOASCII_PRESERVES_TRAILING_DOTS = IDNBUGHOLDER.keepsTrailingDot();

        private IDNBUGHOLDER() {
        }

        private static boolean keepsTrailingDot() {
            String input = "a.";
            return "a.".equals(IDN.toASCII("a."));
        }
    }
}

