/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Command;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class OsmAndProtocolDecoder
extends BaseHttpProtocolDecoder {
    public OsmAndProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        String contentType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null && contentType.startsWith(HttpHeaderValues.APPLICATION_JSON.toString())) {
            return this.decodeJson(channel, remoteAddress, request);
        }
        return this.decodeQuery(channel, remoteAddress, request);
    }

    private Object decodeQuery(Channel channel, SocketAddress remoteAddress, FullHttpRequest request) throws Exception {
        QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
        Map params = decoder.parameters();
        if (params.isEmpty()) {
            decoder = new QueryStringDecoder(request.content().toString(StandardCharsets.US_ASCII), false);
            params = decoder.parameters();
        }
        Position position = new Position(this.getProtocolName());
        position.setValid(true);
        Network network = new Network();
        Double latitude = null;
        Double longitude = null;
        for (Map.Entry entry : params.entrySet()) {
            block53: for (String value : (List)entry.getValue()) {
                block23 : switch ((String)entry.getKey()) {
                    case "id": 
                    case "deviceid": {
                        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                        if (deviceSession == null) {
                            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
                            return null;
                        }
                        position.setDeviceId(deviceSession.getDeviceId());
                        break;
                    }
                    case "notificationToken": {
                        if (position.getDeviceId() <= 0L) continue block53;
                        this.getCommandsManager().updateNotificationToken(position.getDeviceId(), value);
                        break;
                    }
                    case "valid": {
                        position.setValid(Boolean.parseBoolean(value) || "1".equals(value));
                        break;
                    }
                    case "timestamp": {
                        try {
                            long timestamp = Long.parseLong(value);
                            if (timestamp < Integer.MAX_VALUE) {
                                timestamp *= 1000L;
                            }
                            position.setTime(new Date(timestamp));
                        }
                        catch (NumberFormatException error) {
                            if (value.contains("T")) {
                                position.setTime(DateUtil.parseDate(value));
                                break;
                            }
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            position.setTime(dateFormat.parse(value));
                        }
                        break;
                    }
                    case "lat": {
                        latitude = Double.parseDouble(value);
                        break;
                    }
                    case "lon": {
                        longitude = Double.parseDouble(value);
                        break;
                    }
                    case "location": {
                        String[] location = value.split(",");
                        latitude = Double.parseDouble(location[0]);
                        longitude = Double.parseDouble(location[1]);
                        break;
                    }
                    case "cell": {
                        String[] cell = value.split(",");
                        if (cell.length > 4) {
                            network.addCellTower(CellTower.from(Integer.parseInt(cell[0]), Integer.parseInt(cell[1]), Integer.parseInt(cell[2]), Integer.parseInt(cell[3]), Integer.parseInt(cell[4])));
                            break;
                        }
                        network.addCellTower(CellTower.from(Integer.parseInt(cell[0]), Integer.parseInt(cell[1]), Integer.parseInt(cell[2]), Integer.parseInt(cell[3])));
                        break;
                    }
                    case "wifi": {
                        String[] wifi = value.split(",");
                        network.addWifiAccessPoint(WifiAccessPoint.from(wifi[0].replace('-', ':'), Integer.parseInt(wifi[1])));
                        break;
                    }
                    case "speed": {
                        position.setSpeed(this.convertSpeed(Double.parseDouble(value), "kn"));
                        break;
                    }
                    case "bearing": 
                    case "heading": {
                        position.setCourse(Double.parseDouble(value));
                        break;
                    }
                    case "altitude": {
                        position.setAltitude(Double.parseDouble(value));
                        break;
                    }
                    case "accuracy": {
                        position.setAccuracy(Double.parseDouble(value));
                        break;
                    }
                    case "hdop": {
                        position.set("hdop", Double.parseDouble(value));
                        break;
                    }
                    case "batt": {
                        position.set("batteryLevel", Double.parseDouble(value));
                        break;
                    }
                    case "driverUniqueId": {
                        position.set("driverUniqueId", value);
                        break;
                    }
                    case "charge": {
                        position.set("charge", Boolean.parseBoolean(value));
                        break;
                    }
                    default: {
                        try {
                            position.set((String)entry.getKey(), Double.parseDouble(value));
                            break;
                        }
                        catch (NumberFormatException e) {
                            switch (value) {
                                case "true": {
                                    position.set((String)entry.getKey(), true);
                                    break block23;
                                }
                                case "false": {
                                    position.set((String)entry.getKey(), false);
                                    break block23;
                                }
                            }
                            position.set((String)entry.getKey(), value);
                        }
                    }
                }
            }
        }
        if (position.getFixTime() == null) {
            position.setTime(new Date());
        }
        if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
            position.setNetwork(network);
        }
        if (latitude != null && longitude != null) {
            position.setLatitude(latitude);
            position.setLongitude(longitude);
        } else {
            this.getLastLocation(position, position.getDeviceTime());
        }
        if (position.getDeviceId() != 0L) {
            String response = null;
            for (Command command : this.getCommandsManager().readQueuedCommands(position.getDeviceId(), 1)) {
                response = command.getString("data");
            }
            if (response != null) {
                this.sendResponse(channel, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)response, (Charset)StandardCharsets.UTF_8));
            } else {
                this.sendResponse(channel, HttpResponseStatus.OK);
            }
            return position;
        }
        this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
        return null;
    }

    private Object decodeJson(Channel channel, SocketAddress remoteAddress, FullHttpRequest request) throws Exception {
        JsonObject extras;
        String content = request.content().toString(StandardCharsets.UTF_8);
        JsonObject root = Json.createReader((Reader)new StringReader(content)).readObject();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, root.getString("device_id"));
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.NOT_FOUND);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        JsonObject location = root.getJsonObject("location");
        position.setTime(DateUtil.parseDate(location.getString("timestamp")));
        if (location.containsKey((Object)"coords")) {
            double heading;
            JsonObject coordinates = location.getJsonObject("coords");
            position.setValid(true);
            position.setLatitude(coordinates.getJsonNumber("latitude").doubleValue());
            position.setLongitude(coordinates.getJsonNumber("longitude").doubleValue());
            double speed = coordinates.getJsonNumber("speed").doubleValue();
            if (speed >= 0.0) {
                position.setSpeed(UnitsConverter.knotsFromMps(speed));
            }
            if ((heading = coordinates.getJsonNumber("heading").doubleValue()) >= 0.0) {
                position.setCourse(heading);
            }
            if (speed < 0.0 && heading < 0.0) {
                position.setAccuracy(coordinates.getJsonNumber("accuracy").doubleValue());
            }
            position.setAltitude(coordinates.getJsonNumber("altitude").doubleValue());
        } else {
            this.getLastLocation(position, null);
        }
        if (location.containsKey((Object)"event")) {
            position.set("event", location.getString("event"));
        }
        if (location.containsKey((Object)"is_moving")) {
            position.set("motion", location.getBoolean("is_moving"));
        }
        if (location.containsKey((Object)"odometer")) {
            position.set("odometer", location.getInt("odometer"));
        }
        if (location.containsKey((Object)"mock")) {
            position.set("mock", location.getBoolean("mock"));
        }
        if (location.containsKey((Object)"activity")) {
            position.set("activity", location.getJsonObject("activity").getString("type"));
        }
        if (location.containsKey((Object)"battery")) {
            JsonObject battery = location.getJsonObject("battery");
            double level = battery.getJsonNumber("level").doubleValue();
            if (level >= 0.0) {
                position.set("batteryLevel", (int)(level * 100.0));
            }
            if (battery.getBoolean("is_charging")) {
                position.set("charge", true);
            }
        }
        if (location.containsKey((Object)"alarm")) {
            position.set("alarm", location.getString("alarm"));
        } else if (location.containsKey((Object)"extras") && (extras = location.getJsonObject("extras")).containsKey((Object)"alarm")) {
            position.set("alarm", extras.getString("alarm"));
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }

    @Override
    protected void sendQueuedCommands(Channel channel, SocketAddress remoteAddress, long deviceId) {
    }
}

