/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.classfile;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.classfile.ClassfileParser;
import dotty.tools.dotc.core.classfile.ClassfileParser$;
import dotty.tools.dotc.core.classfile.ClassfileParser$Header$Version$;
import dotty.tools.dotc.core.classfile.DataReader;
import dotty.tools.dotc.core.classfile.ReusableDataReader;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.ReusableInstance;
import dotty.tools.dotc.util.SrcPos;
import dotty.tools.io.AbstractFile;
import dotty.tools.tasty.TastyReader;
import dotty.tools.tasty.TastyReader$;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import scala.Char$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.immutable.Seq;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ClassfileTastyUUIDParser {
    private final AbstractFile classfile;
    private ConstantPool pool;
    private long classfileVersion;

    public ClassfileTastyUUIDParser(AbstractFile classfile, Contexts.Context ictx) {
        this.classfile = classfile;
        this.classfileVersion = ClassfileParser$Header$Version$.MODULE$.Unknown();
    }

    public void checkTastyUUID(UUID tastyUUID, Contexts.Context x$2) {
        try {
            ReusableInstance<ReusableDataReader> ReusableInstance_this = x$2.base().reusableDataReader();
            JProcedure1 & Serializable action$proxy1 = (JProcedure1 & Serializable)reader -> {
                ReusableDataReader reader2 = reader.reset(this.classfile);
                this.classfileVersion = ClassfileParser$.MODULE$.parseHeader(this.classfile, reader2);
                this.pool = new ConstantPool(reader2);
                this.checkTastyAttr(tastyUUID, x$2, reader2);
                this.pool = null;
            };
            if (ReusableInstance_this.inline$taken() == ReusableInstance_this.inline$cache().size()) {
                ReusableInstance_this.inline$cache().$plus$eq((Object)ReusableInstance_this.inline$make());
            }
            ReusableInstance_this.inline$taken_$eq(ReusableInstance_this.inline$taken() + 1);
            try {
                action$proxy1.apply(ReusableInstance_this.inline$cache().apply(ReusableInstance_this.inline$taken() - 1));
            }
            finally {
                ReusableInstance_this.inline$taken_$eq(ReusableInstance_this.inline$taken() - 1);
            }
        }
        catch (RuntimeException e) {
            if (x$2.debug()) {
                e.printStackTrace();
            }
            String addendum = ClassfileParser$Header$Version$.MODULE$.brokenVersionAddendum(this.classfileVersion, x$2);
            throw new IOException(Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"  class file ", " is broken", ",\n          |  reading aborted with ", ":\n          |  ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)this.classfile.canonicalPath()), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)addendum), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Class()).apply(e.getClass()), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(Option$.MODULE$.apply((Object)e.getMessage()).getOrElse(ClassfileTastyUUIDParser::checkTastyUUID$$anonfun$1))}), x$2));
        }
    }

    private void checkTastyAttr(UUID tastyUUID, Contexts.Context ctx, DataReader in) {
        in.nextChar();
        in.nextChar();
        this.skipSuperclasses(in);
        this.skipMembers(in);
        this.skipMembers(in);
        char attrs = in.nextChar();
        int attrbp = in.bp();
        if (this.scan$1(in, attrbp, attrs, (Names.TypeName)StdNames$.MODULE$.tpnme().TASTYATTR())) {
            int attrLen = in.nextInt();
            byte[] bytes = in.nextBytes(attrLen);
            if (attrLen == 16) {
                UUID expectedUUID;
                TastyReader reader = new TastyReader(bytes, 0, 16, TastyReader$.MODULE$.$lessinit$greater$default$4());
                UUID uUID = expectedUUID = new UUID(reader.readUncompressedLong(), reader.readUncompressedLong());
                UUID uUID2 = tastyUUID;
                if (uUID == null ? uUID2 != null : !((Object)uUID).equals(uUID2)) {
                    report$.MODULE$.warning((Function0<String>)((Function0 & Serializable)this::checkTastyAttr$$anonfun$1), (SrcPos)NoSourcePosition$.MODULE$, ctx);
                    return;
                }
                return;
            }
            report$.MODULE$.error((Function0<String>)((Function0 & Serializable)this::checkTastyAttr$$anonfun$2), (SrcPos)NoSourcePosition$.MODULE$, ctx);
            return;
        }
    }

    private void skipAttributes(DataReader in) {
        char attrCount = in.nextChar();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Char$.MODULE$.char2int(attrCount)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            in.skip(2);
            in.skip(in.nextInt());
        });
    }

    private void skipMembers(DataReader in) {
        char memberCount = in.nextChar();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Char$.MODULE$.char2int(memberCount)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            in.skip(6);
            this.skipAttributes(in);
        });
    }

    private void skipSuperclasses(DataReader in) {
        in.skip(2);
        char ifaces = in.nextChar();
        in.skip(2 * ifaces);
    }

    private static final String checkTastyUUID$$anonfun$1() {
        return "";
    }

    private final boolean scan$1(DataReader in$1, int attrbp$1, char attrs$1, Names.TypeName target) {
        int i;
        in$1.bp_$eq(attrbp$1);
        for (i = 0; i < attrs$1; ++i) {
            Names.TypeName typeName = this.pool.getName(Char$.MODULE$.char2int(in$1.nextChar()), in$1).name().toTypeName();
            Names.TypeName typeName2 = target;
            if (!(typeName == null ? typeName2 != null : !((Object)typeName).equals(typeName2))) break;
            int attrLen = in$1.nextInt();
            in$1.skip(attrLen);
        }
        return i < attrs$1;
    }

    private final String checkTastyAttr$$anonfun$1() {
        return new StringBuilder(98).append(this.classfile).append(" is out of sync with its TASTy file. Loaded TASTy file. Try cleaning the project to fix this issue").toString();
    }

    private final String checkTastyAttr$$anonfun$2() {
        return new StringBuilder(113).append("Found a TASTY attribute with a length different from 16 in ").append(this.classfile).append(". This is likely a bug in the compiler. Please report.").toString();
    }

    public class ConstantPool
    extends ClassfileParser.AbstractConstantPool {
        public ConstantPool(DataReader in) {
            if (ClassfileTastyUUIDParser.this == null) {
                throw new NullPointerException();
            }
            super(in);
        }

        @Override
        public Types.Type getClassOrArrayType(int index, Contexts.Context ctx, DataReader in) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Symbols.Symbol getClassSymbol(int index, Contexts.Context ctx, DataReader in) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Types.Type getType(int index, boolean isVarargs, Contexts.Context x$3, DataReader x$4) {
            throw new UnsupportedOperationException();
        }

        public final /* synthetic */ ClassfileTastyUUIDParser dotty$tools$dotc$core$classfile$ClassfileTastyUUIDParser$ConstantPool$$$outer() {
            return ClassfileTastyUUIDParser.this;
        }
    }
}

