/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul / u64vec2(10ul, 12ul)) => u64vec2(0ul, 0ul)
 * (0ul / u64vec2(42ul, 48ul)) => u64vec2(0ul, 0ul)
 * (3ul / u64vec2(10ul, 12ul)) => u64vec2(0ul, 0ul)
 * (3ul / u64vec2(42ul, 48ul)) => u64vec2(0ul, 0ul)
 * (1192ul / u64vec2(10ul, 12ul)) => u64vec2(119ul, 99ul)
 * (1192ul / u64vec2(42ul, 48ul)) => u64vec2(28ul, 24ul)
 * (1048576ul / u64vec2(10ul, 12ul)) => u64vec2(104857ul, 87381ul)
 * (1048576ul / u64vec2(42ul, 48ul)) => u64vec2(24966ul, 21845ul)
 * (4251475ul / u64vec2(10ul, 12ul)) => u64vec2(425147ul, 354289ul)
 * (4251475ul / u64vec2(42ul, 48ul)) => u64vec2(101225ul, 88572ul)
 * (29852643761ul / u64vec2(10ul, 12ul)) => u64vec2(2985264376ul, 2487720313ul)
 * (29852643761ul / u64vec2(42ul, 48ul)) => u64vec2(710777232ul, 621930078ul)
 * (4398046511104ul / u64vec2(10ul, 12ul)) => u64vec2(439804651110ul, 366503875925ul)
 * (4398046511104ul / u64vec2(42ul, 48ul)) => u64vec2(104715393121ul, 91625968981ul)
 * (3948976685146ul / u64vec2(10ul, 12ul)) => u64vec2(394897668514ul, 329081390428ul)
 * (3948976685146ul / u64vec2(42ul, 48ul)) => u64vec2(94023254408ul, 82270347607ul)
 * (135763469567146206ul / u64vec2(10ul, 12ul)) => u64vec2(13576346956714620ul, 11313622463928850ul)
 * (135763469567146206ul / u64vec2(42ul, 48ul)) => u64vec2(3232463561122528ul, 2828405615982212ul)
 * (11654173250180970009ul / u64vec2(10ul, 12ul)) => u64vec2(1165417325018097000ul, 971181104181747500ul)
 * (11654173250180970009ul / u64vec2(42ul, 48ul)) => u64vec2(277480315480499285ul, 242795276045436875ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul / u64vec2(10ul, 12ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((0ul / u64vec2(42ul, 48ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((3ul / u64vec2(10ul, 12ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array2;
  float[all(equal((3ul / u64vec2(42ul, 48ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array3;
  float[all(equal((1192ul / u64vec2(10ul, 12ul)), u64vec2(119ul, 99ul))) ? 1 : -1] array4;
  float[all(equal((1192ul / u64vec2(42ul, 48ul)), u64vec2(28ul, 24ul))) ? 1 : -1] array5;
  float[all(equal((1048576ul / u64vec2(10ul, 12ul)), u64vec2(104857ul, 87381ul))) ? 1 : -1] array6;
  float[all(equal((1048576ul / u64vec2(42ul, 48ul)), u64vec2(24966ul, 21845ul))) ? 1 : -1] array7;
  float[all(equal((4251475ul / u64vec2(10ul, 12ul)), u64vec2(425147ul, 354289ul))) ? 1 : -1] array8;
  float[all(equal((4251475ul / u64vec2(42ul, 48ul)), u64vec2(101225ul, 88572ul))) ? 1 : -1] array9;
  float[all(equal((29852643761ul / u64vec2(10ul, 12ul)), u64vec2(2985264376ul, 2487720313ul))) ? 1 : -1] array10;
  float[all(equal((29852643761ul / u64vec2(42ul, 48ul)), u64vec2(710777232ul, 621930078ul))) ? 1 : -1] array11;
  float[all(equal((4398046511104ul / u64vec2(10ul, 12ul)), u64vec2(439804651110ul, 366503875925ul))) ? 1 : -1] array12;
  float[all(equal((4398046511104ul / u64vec2(42ul, 48ul)), u64vec2(104715393121ul, 91625968981ul))) ? 1 : -1] array13;
  float[all(equal((3948976685146ul / u64vec2(10ul, 12ul)), u64vec2(394897668514ul, 329081390428ul))) ? 1 : -1] array14;
  float[all(equal((3948976685146ul / u64vec2(42ul, 48ul)), u64vec2(94023254408ul, 82270347607ul))) ? 1 : -1] array15;
  float[all(equal((135763469567146206ul / u64vec2(10ul, 12ul)), u64vec2(13576346956714620ul, 11313622463928850ul))) ? 1 : -1] array16;
  float[all(equal((135763469567146206ul / u64vec2(42ul, 48ul)), u64vec2(3232463561122528ul, 2828405615982212ul))) ? 1 : -1] array17;
  float[all(equal((11654173250180970009ul / u64vec2(10ul, 12ul)), u64vec2(1165417325018097000ul, 971181104181747500ul))) ? 1 : -1] array18;
  float[all(equal((11654173250180970009ul / u64vec2(42ul, 48ul)), u64vec2(277480315480499285ul, 242795276045436875ul))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
