/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.List;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationSerializer;
import org.infinispan.persistence.remote.configuration.SecurityConfiguration;

@BuiltBy(value=RemoteStoreConfigurationBuilder.class)
@ConfigurationFor(value=RemoteStore.class)
@SerializedWith(value=RemoteStoreConfigurationSerializer.class)
public class RemoteStoreConfiguration
extends AbstractStoreConfiguration<RemoteStoreConfiguration> {
    static final AttributeDefinition<String> BALANCING_STRATEGY = AttributeDefinition.builder((Enum)Attribute.BALANCING_STRATEGY, (Object)RoundRobinBalancingStrategy.class.getName()).immutable().build();
    static final AttributeDefinition<Long> CONNECTION_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.CONNECT_TIMEOUT, (Object)2000L).build();
    static final AttributeDefinition<Boolean> FORCE_RETURN_VALUES = AttributeDefinition.builder((Enum)Attribute.FORCE_RETURN_VALUES, (Object)false).immutable().build();
    static final AttributeDefinition<Boolean> HOTROD_WRAPPING = AttributeDefinition.builder((Enum)Attribute.HOTROD_WRAPPING, (Object)false).immutable().build();
    static final AttributeDefinition<Boolean> RAW_VALUES = AttributeDefinition.builder((Enum)Attribute.RAW_VALUES, (Object)false).immutable().build();
    @Deprecated(forRemoval=true, since="12.0")
    static final AttributeDefinition<Integer> KEY_SIZE_ESTIMATE = AttributeDefinition.builder((Enum)Attribute.KEY_SIZE_ESTIMATE, (Object)64).immutable().build();
    @Deprecated(forRemoval=true, since="12.0")
    static final AttributeDefinition<Integer> VALUE_SIZE_ESTIMATE = AttributeDefinition.builder((Enum)Attribute.VALUE_SIZE_ESTIMATE, (Object)512).immutable().build();
    static final AttributeDefinition<String> MARSHALLER = AttributeDefinition.builder((Enum)Attribute.MARSHALLER, null, String.class).immutable().build();
    static final AttributeDefinition<ProtocolVersion> PROTOCOL_VERSION = AttributeDefinition.builder((Enum)Attribute.PROTOCOL_VERSION, (Object)ProtocolVersion.DEFAULT_PROTOCOL_VERSION).immutable().build();
    static final AttributeDefinition<String> REMOTE_CACHE_CONTAINER = AttributeDefinition.builder((Enum)Attribute.REMOTE_CACHE_CONTAINER, (Object)"").immutable().build();
    static final AttributeDefinition<String> REMOTE_CACHE_NAME = AttributeDefinition.builder((Enum)Attribute.REMOTE_CACHE_NAME, (Object)"").immutable().build();
    static final AttributeDefinition<String> URI = AttributeDefinition.builder((Enum)Attribute.URI, null, String.class).immutable().serializer((writer, name, value) -> writer.writeAttribute(name, HotRodURI.create((String)value).toString(writer.clearTextSecrets()))).build();
    static final AttributeDefinition<Long> SOCKET_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.SOCKET_TIMEOUT, (Object)2000L).build();
    static final AttributeDefinition<Boolean> TCP_NO_DELAY = AttributeDefinition.builder((Enum)Attribute.TCP_NO_DELAY, (Object)true).build();
    private final ConnectionPoolConfiguration connectionPool;
    private final ExecutorFactoryConfiguration asyncExecutorFactory;
    private final SecurityConfiguration security;
    private final List<RemoteServerConfiguration> servers;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RemoteStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{BALANCING_STRATEGY, CONNECTION_TIMEOUT, FORCE_RETURN_VALUES, HOTROD_WRAPPING, RAW_VALUES, KEY_SIZE_ESTIMATE, MARSHALLER, PROTOCOL_VERSION, REMOTE_CACHE_CONTAINER, REMOTE_CACHE_NAME, SOCKET_TIMEOUT, TCP_NO_DELAY, VALUE_SIZE_ESTIMATE, URI});
    }

    public RemoteStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, ExecutorFactoryConfiguration asyncExecutorFactory, ConnectionPoolConfiguration connectionPool, SecurityConfiguration security, List<RemoteServerConfiguration> servers) {
        super((Enum)Element.REMOTE_STORE, attributes, async, new ConfigurationElement[0]);
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.connectionPool = connectionPool;
        this.security = security;
        this.servers = servers;
    }

    public String uri() {
        return (String)this.attributes.attribute(URI).get();
    }

    public ExecutorFactoryConfiguration asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public String balancingStrategy() {
        return (String)this.attributes.attribute(BALANCING_STRATEGY).get();
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public long connectionTimeout() {
        return (Long)this.attributes.attribute(CONNECTION_TIMEOUT).get();
    }

    public boolean forceReturnValues() {
        return (Boolean)this.attributes.attribute(FORCE_RETURN_VALUES).get();
    }

    @Deprecated(forRemoval=true, since="12.0")
    public boolean hotRodWrapping() {
        return (Boolean)this.attributes.attribute(RAW_VALUES).get();
    }

    @Deprecated(forRemoval=true, since="12.0")
    public int keySizeEstimate() {
        return (Integer)this.attributes.attribute(KEY_SIZE_ESTIMATE).get();
    }

    public String marshaller() {
        return (String)this.attributes.attribute(MARSHALLER).get();
    }

    public ProtocolVersion protocol() {
        return (ProtocolVersion)this.attributes.attribute(PROTOCOL_VERSION).get();
    }

    @Deprecated(forRemoval=true, since="12.0")
    public boolean rawValues() {
        return (Boolean)this.attributes.attribute(RAW_VALUES).get();
    }

    public String remoteCacheContainer() {
        return (String)this.attributes.attribute(REMOTE_CACHE_CONTAINER).get();
    }

    public String remoteCacheName() {
        return (String)this.attributes.attribute(REMOTE_CACHE_NAME).get();
    }

    public List<RemoteServerConfiguration> servers() {
        return this.servers;
    }

    public long socketTimeout() {
        return (Long)this.attributes.attribute(SOCKET_TIMEOUT).get();
    }

    public boolean tcpNoDelay() {
        return (Boolean)this.attributes.attribute(TCP_NO_DELAY).get();
    }

    @Deprecated(forRemoval=true, since="12.0")
    public int valueSizeEstimate() {
        return (Integer)this.attributes.attribute(VALUE_SIZE_ESTIMATE).get();
    }

    public SecurityConfiguration security() {
        return this.security;
    }
}

