/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.admin;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;

public class AdminEvent {
    private String id;
    private long time;
    private String realmId;
    private String realmName;
    private AuthDetails authDetails;
    private String resourceType;
    private OperationType operationType;
    private String resourcePath;
    private String representation;
    private String error;
    private Map<String, String> details;

    public AdminEvent() {
    }

    public AdminEvent(AdminEvent toCopy) {
        this.id = toCopy.getId();
        this.time = toCopy.getTime();
        this.realmId = toCopy.getRealmId();
        this.realmName = toCopy.getRealmName();
        this.authDetails = new AuthDetails(toCopy.getAuthDetails());
        this.resourceType = toCopy.getResourceTypeAsString();
        this.operationType = toCopy.getOperationType();
        this.resourcePath = toCopy.getResourcePath();
        this.representation = toCopy.getRepresentation();
        this.error = toCopy.getError();
        this.details = toCopy.getDetails() == null ? null : new HashMap<String, String>(toCopy.getDetails());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public AuthDetails getAuthDetails() {
        return this.authDetails;
    }

    public void setAuthDetails(AuthDetails authDetails) {
        this.authDetails = authDetails;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(String representation) {
        this.representation = representation;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public ResourceType getResourceType() {
        if (this.resourceType == null) {
            return null;
        }
        try {
            return ResourceType.valueOf(this.resourceType);
        }
        catch (IllegalArgumentException e) {
            return ResourceType.CUSTOM;
        }
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType == null ? null : resourceType.toString();
    }

    public String getResourceTypeAsString() {
        return this.resourceType;
    }

    public void setResourceTypeAsString(String resourceType) {
        this.resourceType = resourceType;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }
}

