/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Component;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.TP;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.RouterStub;
import org.jgroups.stack.RouterStubManager;
import org.jgroups.util.NameCache;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.TLS;
import org.jgroups.util.Util;

public class TUNNEL
extends TP
implements RouterStub.StubReceiver {
    @Property(description="Interval in msec to attempt connecting back to router in case of torn connection", type=AttributeType.TIME)
    protected long reconnect_interval = 5000L;
    @Property(description="Should TCP no delay flag be turned on")
    protected boolean tcp_nodelay;
    @Property(description="Whether to use blocking (false) or non-blocking (true) connections. If GossipRouter is used, this needs to be false; if GossipRouterNio is used, it needs to be true")
    protected boolean use_nio;
    @Property(description="A comma-separated list of GossipRouter hosts, e.g. HostA[12001],HostB[12001]")
    protected String gossip_router_hosts;
    @Property(description="Sends a heartbeat to the GossipRouter every heartbeat_interval ms (0 disables this)", type=AttributeType.TIME)
    protected long heartbeat_interval;
    @Property(description="Max time (ms) with no received message or heartbeat after which the connection to a GossipRouter is closed. Ignored when heartbeat_interval is 0.", type=AttributeType.TIME)
    protected long heartbeat_timeout;
    @Property(description="SO_LINGER in seconds. Default of -1 disables it")
    protected int linger = -1;
    @Property(description="use bounded queues for sending (https://issues.redhat.com/browse/JGRP-2759)")
    protected boolean non_blocking_sends;
    @Property(description="when sending and non_blocking, how many messages to queue max")
    protected int max_send_queue = 128;
    protected final List<InetSocketAddress> gossip_routers = new ArrayList<InetSocketAddress>();
    protected TUNNELPolicy tunnel_policy = new DefaultTUNNELPolicy();
    protected DatagramSocket sock;
    protected volatile RouterStubManager stubManager;
    @Component(name="tls", description="Contains the attributes for TLS (SSL sockets) when enabled=true")
    protected TLS tls = new TLS();

    public long getReconnectInterval() {
        return this.reconnect_interval;
    }

    public TUNNEL setReconnectInterval(long r) {
        this.reconnect_interval = r;
        return this;
    }

    public boolean isTcpNodelay() {
        return this.tcp_nodelay;
    }

    public TUNNEL setTcpNodelay(boolean nd) {
        this.tcp_nodelay = nd;
        return this;
    }

    public boolean useNio() {
        return this.use_nio;
    }

    public TUNNEL useNio(boolean use_nio) {
        this.use_nio = use_nio;
        return this;
    }

    public TLS tls() {
        return this.tls;
    }

    public TUNNEL tls(TLS t) {
        this.tls = t;
        return this;
    }

    public int getLinger() {
        return this.linger;
    }

    public TUNNEL setLinger(int l) {
        this.linger = l;
        return this;
    }

    public boolean nonBlockingSends() {
        return this.non_blocking_sends;
    }

    public TUNNEL nonBlockingSends(boolean b) {
        this.non_blocking_sends = b;
        return this;
    }

    public int maxSendQueue() {
        return this.max_send_queue;
    }

    public TUNNEL maxSendQueue(int s) {
        this.max_send_queue = s;
        return this;
    }

    @Override
    public boolean supportsMulticasting() {
        return true;
    }

    public TUNNEL setGossipRouterHosts(String hosts) throws UnknownHostException {
        this.gossip_routers.clear();
        if (hosts.startsWith("[") && hosts.endsWith("]")) {
            hosts = hosts.substring(1, hosts.length() - 1);
        }
        this.gossip_router_hosts = hosts;
        return this;
    }

    @ManagedAttribute(description="Is the reconnector task running?")
    public boolean isReconnectorTaskRunning() {
        return this.stubManager != null && this.stubManager.reconnectorRunning();
    }

    @ManagedAttribute(description="Is the heartbeat task running?")
    public boolean isHeartbeatTaskRunning() {
        return this.stubManager != null && this.stubManager.heartbeaterRunning();
    }

    @ManagedAttribute(description="Is the timeout check task running?")
    public boolean isTimeoutCheckTaskRunning() {
        return this.stubManager != null && this.stubManager.timeouterRunning();
    }

    @ManagedOperation(description="Prints all stubs and the reconnect list")
    public String print() {
        RouterStubManager mgr = this.stubManager;
        return mgr != null ? mgr.print() : "n/a";
    }

    @ManagedOperation(description="Prints all currently connected stubs")
    public String printStubs() {
        RouterStubManager mgr = this.stubManager;
        return mgr != null ? mgr.printStubs() : "n/a";
    }

    @ManagedOperation(description="Prints the reconnect list")
    public String printReconnectList() {
        RouterStubManager mgr = this.stubManager;
        return mgr != null ? mgr.printReconnectList() : "n/a";
    }

    public RouterStubManager getStubManager() {
        return this.stubManager;
    }

    @Override
    public String toString() {
        return "TUNNEL";
    }

    public synchronized TUNNEL setTUNNELPolicy(TUNNELPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Tunnel policy has to be non null");
        }
        this.tunnel_policy = policy;
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        if (this.port_range > 0) {
            this.log.warn("%s: port_range=%d; setting it to 0 (https://issues.redhat.com/browse/JGRP-2806)", this.local_addr, this.port_range);
            this.port_range = 0;
        }
        this.gossip_routers.clear();
        this.gossip_routers.addAll(Util.parseCommaDelimitedHosts2(this.gossip_router_hosts, this.port_range));
        if (this.gossip_routers.isEmpty()) {
            throw new IllegalStateException("gossip_router_hosts needs to contain at least one address of a GossipRouter");
        }
        this.log.debug("gossip routers are %s", this.gossip_routers);
        this.stubManager = RouterStubManager.emptyGossipClientStubManager(this.log, this.timer).useNio(this.use_nio).nonBlockingSends(this.non_blocking_sends).maxSendQueue(this.max_send_queue);
        this.sock = this.getSocketFactory().createDatagramSocket("jgroups.tunnel.ucast_sock", 0, this.bind_addr);
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.tls.enabled()) {
            SocketFactory factory = this.tls.createSocketFactory();
            this.setSocketFactory(factory);
        }
    }

    @Override
    public void destroy() {
        if (this.stubManager != null) {
            this.stubManager.destroyStubs();
        }
        Util.close((Closeable)this.sock);
        super.destroy();
    }

    private void disconnectStub() {
        this.stubManager.disconnectStubs();
    }

    @Override
    public Object down(Event evt) {
        Object retEvent = super.down(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                String group = (String)evt.getArg();
                Address local = this.local_addr;
                if (this.stubManager != null) {
                    this.stubManager.destroyStubs();
                }
                PhysicalAddress physical_addr = this.getPhysicalAddressFromCache(local);
                String logical_name = NameCache.get(local);
                this.stubManager = new RouterStubManager(this.log, this.timer, group, local, logical_name, physical_addr, this.reconnect_interval).useNio(this.use_nio).socketFactory(this.getSocketFactory()).heartbeat(this.heartbeat_interval, this.heartbeat_timeout).nonBlockingSends(this.non_blocking_sends).maxSendQueue(this.max_send_queue);
                for (InetSocketAddress gr : this.gossip_routers) {
                    try {
                        InetSocketAddress target = gr.isUnresolved() ? new InetSocketAddress(gr.getHostString(), gr.getPort()) : new InetSocketAddress(gr.getAddress(), gr.getPort());
                        this.stubManager.createAndRegisterStub(new InetSocketAddress(this.bind_addr, this.bind_port), target, this.linger).receiver(this).tcpNoDelay(this.tcp_nodelay);
                    }
                    catch (Throwable t) {
                        this.log.error("%s: failed creating stub to %s: %s", local, this.bind_addr + ":" + this.bind_port, t);
                    }
                }
                this.stubManager.connectStubs();
                break;
            }
            case 4: {
                this.disconnectStub();
            }
        }
        return retEvent;
    }

    @Override
    public void receive(GossipData data) {
        switch (data.getType()) {
            case MESSAGE: {
                if (Objects.equals(this.local_addr, data.getSender())) {
                    return;
                }
                byte[] msg = data.getBuffer();
                this.receive(data.getSender(), msg, 0, msg.length);
                break;
            }
            case SUSPECT: {
                Address suspect = data.getAddress();
                if (suspect == null) break;
                this.log.debug("%s: firing suspect event for %s", this.local_addr, suspect);
                this.up(new Event(9, Collections.singletonList(suspect)));
            }
        }
    }

    @Override
    public void sendToAll(byte[] data, int offset, int length) throws Exception {
        String group = this.cluster_name != null ? this.cluster_name.toString() : null;
        this.tunnel_policy.sendToAllMembers(group, this.local_addr, data, offset, length);
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        String group = this.cluster_name != null ? this.cluster_name.toString() : null;
        this.tunnel_policy.sendToSingleMember(group, dest, this.local_addr, data, offset, length);
    }

    @Override
    protected void sendTo(Address dest, byte[] buf, int offset, int length) throws Exception {
        if (dest instanceof PhysicalAddress) {
            throw new IllegalArgumentException(String.format("destination %s cannot be a physical address", dest));
        }
        this.sendUnicast(dest, buf, offset, length);
    }

    protected void sendUnicast(Address dest, byte[] data, int offset, int length) throws Exception {
        String group = this.cluster_name != null ? this.cluster_name.toString() : null;
        this.tunnel_policy.sendToSingleMember(group, dest, this.local_addr, data, offset, length);
    }

    @Override
    public String getInfo() {
        return this.stubManager.printStubs();
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.sock != null ? new IpAddress(this.bind_addr, this.sock.getLocalPort()) : null;
    }

    private class DefaultTUNNELPolicy
    implements TUNNELPolicy {
        private DefaultTUNNELPolicy() {
        }

        @Override
        public void sendToAllMembers(String group, Address sender, byte[] data, int offset, int length) throws Exception {
            TUNNEL.this.stubManager.forAny(stub -> {
                try {
                    if (TUNNEL.this.log.isTraceEnabled()) {
                        TUNNEL.this.log.trace("%s: sending a message to all members, GR used %s", TUNNEL.this.local_addr, stub.gossipRouterAddress());
                    }
                    stub.sendToAllMembers(group, sender, data, offset, length);
                }
                catch (Exception ex) {
                    TUNNEL.this.log.warn("%s: failed sending a message to all members, router used %s: %s", TUNNEL.this.local_addr, stub.gossipRouterAddress(), ex);
                }
            });
        }

        @Override
        public void sendToSingleMember(String group, Address dest, Address sender, byte[] data, int offset, int length) throws Exception {
            TUNNEL.this.stubManager.forAny(stub -> {
                try {
                    if (TUNNEL.this.log.isTraceEnabled()) {
                        TUNNEL.this.log.trace("%s: sending a message to %s (router used %s)", TUNNEL.this.local_addr, dest, stub.gossipRouterAddress());
                    }
                    stub.sendToMember(group, dest, sender, data, offset, length);
                }
                catch (Exception ex) {
                    TUNNEL.this.log.warn("%s: failed sending a message to %s (router used %s): %s", TUNNEL.this.local_addr, dest, stub.gossipRouterAddress(), ex);
                }
            });
        }
    }

    public static interface TUNNELPolicy {
        public void sendToAllMembers(String var1, Address var2, byte[] var3, int var4, int var5) throws Exception;

        public void sendToSingleMember(String var1, Address var2, Address var3, byte[] var4, int var5, int var6) throws Exception;
    }
}

