/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jetbrains.relocated.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.dom.util.XLinkSupport;
import org.jetbrains.relocated.apache.batik.ext.awt.image.PadMode;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.AffineRable8Bit;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.Filter;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.jetbrains.relocated.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.jetbrains.relocated.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGFeImageElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feImage";
    }

    @Override
    public Filter createFilter(BridgeContext ctx2, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        String uriStr = XLinkSupport.getXLinkHref(filterElement);
        if (uriStr.length() == 0) {
            throw new BridgeException(ctx2, filterElement, "attribute.missing", new Object[]{"xlink:href"});
        }
        Document document = filterElement.getOwnerDocument();
        boolean isUse = uriStr.indexOf(35) != -1;
        Element contentElement = null;
        contentElement = isUse ? document.createElementNS("http://www.w3.org/2000/svg", "use") : document.createElementNS("http://www.w3.org/2000/svg", "image");
        contentElement.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", uriStr);
        Element proxyElement = document.createElementNS("http://www.w3.org/2000/svg", "g");
        proxyElement.appendChild(contentElement);
        Rectangle2D defaultRegion = filterRegion;
        Element filterDefElement = (Element)filterElement.getParentNode();
        Rectangle2D primitiveRegion = SVGUtilities.getBaseFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, ctx2);
        contentElement.setAttributeNS(null, "x", String.valueOf(primitiveRegion.getX()));
        contentElement.setAttributeNS(null, "y", String.valueOf(primitiveRegion.getY()));
        contentElement.setAttributeNS(null, "width", String.valueOf(primitiveRegion.getWidth()));
        contentElement.setAttributeNS(null, "height", String.valueOf(primitiveRegion.getHeight()));
        GraphicsNode node = ctx2.getGVTBuilder().build(ctx2, proxyElement);
        Filter filter2 = node.getGraphicsNodeRable(true);
        String s = SVGUtilities.getChainableAttributeNS(filterDefElement, null, "primitiveUnits", ctx2);
        short coordSystemType = s.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(filterDefElement, "primitiveUnits", s, ctx2);
        AffineTransform at = new AffineTransform();
        if (coordSystemType == 2) {
            at = SVGUtilities.toObjectBBox(at, filteredNode);
        }
        filter2 = new AffineRable8Bit(filter2, at);
        SVGFeImageElementBridge.handleColorInterpolationFilters(filter2, filterElement);
        Rectangle2D primitiveRegionUserSpace = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx2);
        filter2 = new PadRable8Bit(filter2, primitiveRegionUserSpace, PadMode.ZERO_PAD);
        SVGFeImageElementBridge.updateFilterMap(filterElement, filter2, filterMap);
        return filter2;
    }

    protected static Filter createSVGFeImage(BridgeContext ctx2, Rectangle2D primitiveRegion, Element refElement, boolean toBBoxNeeded, Element filterElement, GraphicsNode filteredNode) {
        GraphicsNode node = ctx2.getGVTBuilder().build(ctx2, refElement);
        Filter filter2 = node.getGraphicsNodeRable(true);
        AffineTransform at = new AffineTransform();
        if (toBBoxNeeded) {
            Element filterDefElement = (Element)filterElement.getParentNode();
            String s = SVGUtilities.getChainableAttributeNS(filterDefElement, null, "primitiveUnits", ctx2);
            int coordSystemType = s.length() == 0 ? 1 : (int)SVGUtilities.parseCoordinateSystem(filterDefElement, "primitiveUnits", s, ctx2);
            if (coordSystemType == 2) {
                at = SVGUtilities.toObjectBBox(at, filteredNode);
            }
            Rectangle2D bounds = filteredNode.getGeometryBounds();
            at.preConcatenate(AffineTransform.getTranslateInstance(primitiveRegion.getX() - bounds.getX(), primitiveRegion.getY() - bounds.getY()));
        } else {
            at.translate(primitiveRegion.getX(), primitiveRegion.getY());
        }
        return new AffineRable8Bit(filter2, at);
    }

    protected static Filter createRasterFeImage(BridgeContext ctx2, Rectangle2D primitiveRegion, ParsedURL purl) {
        Filter filter2 = ImageTagRegistry.getRegistry().readURL(purl);
        Rectangle2D bounds = filter2.getBounds2D();
        AffineTransform scale = new AffineTransform();
        scale.translate(primitiveRegion.getX(), primitiveRegion.getY());
        scale.scale(primitiveRegion.getWidth() / (bounds.getWidth() - 1.0), primitiveRegion.getHeight() / (bounds.getHeight() - 1.0));
        scale.translate(-bounds.getX(), -bounds.getY());
        return new AffineRable8Bit(filter2, scale);
    }
}

