/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.parser;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ByteBufferWrapper {
    private final ByteBuffer buffer;

    public ByteBufferWrapper(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBufferWrapper view(int size) {
        return this;
    }

    public ByteBufferWrapper slice() {
        return new ByteBufferWrapper(this.buffer.slice());
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public static ByteBufferWrapper wrap(byte[] data) {
        return new ByteBufferWrapper(ByteBuffer.wrap(data));
    }

    public int limit() {
        return this.buffer.limit();
    }

    public Buffer position(int index) {
        return this.buffer.position(index);
    }

    public ByteBuffer get(byte[] bytes) {
        return this.buffer.get(bytes);
    }

    public void get(byte[] dst, int off, int len) {
        this.buffer.get(dst, off, len);
    }

    public byte get() {
        return this.buffer.get();
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public float getFloat() {
        return this.buffer.getFloat();
    }

    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }
}

