/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.model;

import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.ultimate.jfr.KotlinInlineJFRMethodCall;
import com.intellij.profiler.ultimate.model.BaseJavaCall;
import com.intellij.profiler.ultimate.model.JavaCallStackElementsKt;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ImplicitClassSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.Interner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.util.FormatToolkit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000 72\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0005H&J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\u0006\u0010\u0019\u001a\u00020\u0005J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0005J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0005H\u0005J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010'\u001a\u00020\rH\u0002J\u001d\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010*J\u001d\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010*J\u0012\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001d\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0\u00132\u0006\u0010.\u001a\u00020#H\u0014\u00a2\u0006\u0002\u0010/J/\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u0002000\u00132\u0006\u0010.\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u00101J\u0013\u00102\u001a\u00020\r2\b\u00103\u001a\u0004\u0018\u000104H\u0096\u0002J\b\u00105\u001a\u000206H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u001a\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u001b\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000f\u00a8\u00068"}, d2={"Lcom/intellij/profiler/ultimate/model/BaseJavaMethodCall;", "Lcom/intellij/profiler/ultimate/model/BaseJavaCall;", "<init>", "()V", "fullPackageName", "", "getFullPackageName", "()Ljava/lang/String;", "className", "getClassName", "methodName", "getMethodName", "inlined", "", "getInlined", "()Z", "formalDescriptor", "getFormalDescriptor", "argumentTypes", "", "getArgumentTypes", "()[Ljava/lang/String;", "copyWithCustomName", "name", "fullName", "argumentTypesString", "toString", "isNavigatable", "findVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "findContainingFile", "Lcom/intellij/psi/PsiFile;", "findClass", "Lcom/intellij/psi/PsiClass;", "simpleClassName", "findImplicitClassIfCompact", "Lcom/intellij/psi/PsiImplicitClass;", "isMaybeMethodInCompactSource", "calcNavigatables", "Lcom/intellij/psi/NavigatablePsiElement;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/psi/NavigatablePsiElement;", "findInOuterClass", "handleKotlinLambdas", "findNavigatableMethod", "cls", "(Lcom/intellij/psi/PsiClass;)[Lcom/intellij/psi/NavigatablePsiElement;", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiClass;Ljava/lang/String;Ljava/lang/String;)[Lcom/intellij/psi/PsiMethod;", "equals", "other", "", "hashCode", "", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJavaCallStackElements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCallStackElements.kt\ncom/intellij/profiler/ultimate/model/BaseJavaMethodCall\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n67#2:323\n3829#3:324\n4344#3,2:325\n3829#3:331\n4344#3,2:332\n3829#3:339\n4344#3,2:340\n37#4:327\n36#4,3:328\n37#4:334\n36#4,3:335\n37#4:342\n36#4,3:343\n1#5:338\n*S KotlinDebug\n*F\n+ 1 JavaCallStackElements.kt\ncom/intellij/profiler/ultimate/model/BaseJavaMethodCall\n*L\n65#1:323\n159#1:324\n159#1:325,2\n164#1:331\n164#1:332,2\n84#1:339\n84#1:340,2\n159#1:327\n159#1:328,3\n165#1:334\n165#1:335,3\n84#1:342\n84#1:343,3\n*E\n"})
public abstract class BaseJavaMethodCall
extends BaseJavaCall {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isNavigatable;
    @NotNull
    private static final String METHOD_ARGS_SEPARATOR = ", ";

    public BaseJavaMethodCall() {
        this.isNavigatable = true;
    }

    @NotNull
    public abstract String getFullPackageName();

    @NotNull
    public abstract String getClassName();

    @NotNull
    public abstract String getMethodName();

    public abstract boolean getInlined();

    @Nullable
    public abstract String getFormalDescriptor();

    @Nullable
    public abstract String[] getArgumentTypes();

    @NotNull
    public abstract BaseJavaMethodCall copyWithCustomName(@NotNull String var1);

    @NotNull
    public String fullName() {
        StringBuilder stringBuilder;
        StringBuilder $this$fullName_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$fullName_u24lambda_u240.append(StringUtil.getQualifiedName((String)this.getFullPackageName(), (String)this.getClassName()));
        String[] stringArray = new String[]{".", this.getMethodName(), this.argumentTypesString()};
        StringsKt.append((StringBuilder)$this$fullName_u24lambda_u240, (String[])stringArray);
        return stringBuilder.toString();
    }

    @NotNull
    public final String argumentTypesString() {
        Object[] objectArray = this.getArgumentTypes();
        String string = objectArray != null ? ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)METHOD_ARGS_SEPARATOR, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null) : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public String toString() {
        return this.fullName();
    }

    public boolean isNavigatable() {
        return this.isNavigatable;
    }

    @Nullable
    public final VirtualFile findVirtualFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (VirtualFile)ActionsKt.runReadAction(() -> BaseJavaMethodCall.findVirtualFile$lambda$1(this, project));
    }

    @RequiresReadLock
    @Nullable
    protected final PsiFile findContainingFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String topClassName = StringsKt.substringBefore$default((String)this.getClassName(), (String)"$", null, (int)2, null);
        PsiClass psiClass = this.findClass(project, topClassName);
        return psiClass != null ? psiClass.getContainingFile() : null;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @Nullable
    protected final PsiClass findClass(@NotNull Project project, @NotNull String simpleClassName) {
        PsiClass navigationElement;
        PsiClass psiClass;
        PsiClass psiClass2;
        PsiClass psiClass3;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)simpleClassName, (String)"simpleClassName");
        String string = StringUtil.getQualifiedName((String)this.getFullPackageName(), (String)simpleClassName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        String qualifiedName = string;
        PsiClass psiClass4 = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)qualifiedName, null, (boolean)true);
        if (psiClass4 == null) {
            psiClass4 = (PsiClass)this.findImplicitClassIfCompact(simpleClassName, project);
        }
        if ((psiClass3 = (psiClass2 = psiClass4)) != null && (psiClass3 = psiClass3.getNavigationElement()) != null) {
            void $this$parentOfType$iv;
            PsiClass psiClass5 = psiClass3;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiClass.class, (boolean)false);
        } else {
            psiClass = null;
        }
        PsiClass psiClass6 = navigationElement = psiClass;
        if (psiClass6 != null) {
            return psiClass6;
        }
        return psiClass2;
    }

    private final PsiImplicitClass findImplicitClassIfCompact(String simpleClassName, Project project) {
        PsiImplicitClass psiImplicitClass;
        if (this.isMaybeMethodInCompactSource()) {
            Query query = ImplicitClassSearch.search((String)simpleClassName, (Project)project, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
            psiImplicitClass = (PsiImplicitClass)CollectionsKt.firstOrNull((Iterable)((Iterable)query));
        } else {
            psiImplicitClass = null;
        }
        return psiImplicitClass;
    }

    private final boolean isMaybeMethodInCompactSource() {
        return ((CharSequence)this.getFullPackageName()).length() == 0;
    }

    @NotNull
    public NavigatablePsiElement[] calcNavigatables(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = ReadAction.compute(() -> BaseJavaMethodCall.calcNavigatables$lambda$4(this, project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (NavigatablePsiElement[])object;
    }

    private final NavigatablePsiElement[] findInOuterClass(Project project) {
        NavigatablePsiElement kotlinMethodWithLambda = this.handleKotlinLambdas(project);
        if (kotlinMethodWithLambda != null) {
            NavigatablePsiElement[] navigatablePsiElementArray = new NavigatablePsiElement[]{kotlinMethodWithLambda};
            return navigatablePsiElementArray;
        }
        String simpleClassName = JavaCallStackElementsKt.access$substringBefore(StringsKt.substringBefore$default((String)this.getClassName(), (String)"$$Lambda", null, (int)2, null), new Regex("\\$\\d"));
        PsiClass psiClass = this.findClass(project, simpleClassName);
        if (psiClass == null && (psiClass = this.findClass(project, StringsKt.substringBefore$default((String)simpleClassName, (String)"$", null, (int)2, null))) == null) {
            return new NavigatablePsiElement[0];
        }
        PsiClass clazz = psiClass;
        PsiClass[] psiClassArray = new PsiClass[]{clazz};
        return (NavigatablePsiElement[])psiClassArray;
    }

    private final NavigatablePsiElement handleKotlinLambdas(Project project) {
        if (!Intrinsics.areEqual((Object)this.getMethodName(), (Object)"invoke")) {
            return null;
        }
        String simpleClassName = JavaCallStackElementsKt.access$substringBefore(StringsKt.substringBefore$default((String)this.getClassName(), (String)"$$", null, (int)2, null), new Regex("\\$\\d"));
        int index;
        while ((index = StringsKt.lastIndexOf$default((CharSequence)simpleClassName, (char)'$', (int)0, (boolean)false, (int)6, null)) >= 0) {
            String className;
            Intrinsics.checkNotNullExpressionValue((Object)simpleClassName.substring(0, index), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)simpleClassName.substring(index + 1), (String)"substring(...)");
            PsiClass clazz = this.findClass(project, className);
            if (clazz != null) {
                String methodName;
                Object[] psiMethods = this.findNavigatableMethod(clazz, methodName, null);
                if (!(psiMethods.length == 0)) {
                    return (NavigatablePsiElement)ArraysKt.first((Object[])psiMethods);
                }
                return (NavigatablePsiElement)clazz;
            }
            simpleClassName = className;
        }
        return null;
    }

    @NotNull
    protected NavigatablePsiElement[] findNavigatableMethod(@NotNull PsiClass cls) {
        Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
        String methodName = StringsKt.removePrefix((String)this.getMethodName(), (CharSequence)"access$");
        PsiMethod[] methods = this.findNavigatableMethod(cls, methodName, this.getFormalDescriptor());
        if (!(methods.length == 0)) {
            return (NavigatablePsiElement[])methods;
        }
        methods = this.findNavigatableMethod(cls, methodName = StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)methodName, (String)"$lambda", null, (int)2, null), (String)"$default", null, (int)2, null), null);
        if (!(methods.length == 0)) {
            return (NavigatablePsiElement[])methods;
        }
        String string = KotlinInlineJFRMethodCall.Companion.getFunctionNameOfInlineLambdaCall$intellij_profiler_ultimate(methodName);
        if (string == null) {
            return new NavigatablePsiElement[0];
        }
        String inlineCallMethodName = string;
        return (NavigatablePsiElement[])this.findNavigatableMethod(cls, inlineCallMethodName, null);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiMethod[] findNavigatableMethod(PsiClass cls, String methodName, String formalDescriptor) {
        PsiMethod[] psiMethodArray;
        if (Intrinsics.areEqual((Object)methodName, (Object)"<init>")) {
            psiMethodArray = cls.getConstructors();
        } else {
            PsiMethod[] psiMethodArray2 = cls.findMethodsByName(methodName, false);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray2, (String)"findMethodsByName(...)");
            PsiMethod[] res = psiMethodArray2;
            if (!(res.length == 0)) {
                psiMethodArray = res;
            } else {
                void $this$toTypedArray$iv;
                void $this$filterTo$iv$iv;
                PsiMethod[] psiMethodArray3 = cls.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray3, (String)"getMethods(...)");
                Object $this$filter$iv = psiMethodArray3;
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    PsiMethod it = (PsiMethod)element$iv$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)(methodName + "$"), (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                psiMethodArray = thisCollection$iv.toArray(new PsiMethod[0]);
            }
        }
        PsiMethod[] psiMethodArray4 = psiMethodArray;
        Intrinsics.checkNotNull((Object)psiMethodArray4);
        PsiMethod[] methods = psiMethodArray4;
        if (formalDescriptor != null && methods.length > 1) {
            try {
                PsiMethod[] psiMethodArray5;
                void $this$filterTo$iv$iv;
                PsiMethod[] $this$filter$iv = methods;
                boolean $i$f$filter = false;
                PsiMethod[] $i$f$toTypedArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)JVMNameUtil.getJVMSignature((PsiMethod)it).getName(null), (Object)formalDescriptor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List matched = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = matched;
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PsiMethod[] psiMethodArray6 = thisCollection$iv.toArray(new PsiMethod[0]);
                if (psiMethodArray6.length == 0) {
                    boolean bl = false;
                    psiMethodArray5 = methods;
                } else {
                    psiMethodArray5 = psiMethodArray6;
                }
                return psiMethodArray5;
            }
            catch (Exception e) {
                JavaCallStackElementsKt.access$getLogger$p().error((Throwable)e);
            }
        }
        return methods;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BaseJavaMethodCall)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getFormalDescriptor(), (Object)((BaseJavaMethodCall)((Object)other)).getFormalDescriptor()) && Intrinsics.areEqual((Object)this.getMethodName(), (Object)((BaseJavaMethodCall)((Object)other)).getMethodName()) && Intrinsics.areEqual((Object)this.getClassName(), (Object)((BaseJavaMethodCall)((Object)other)).getClassName()) && Intrinsics.areEqual((Object)this.getFullPackageName(), (Object)((BaseJavaMethodCall)((Object)other)).getFullPackageName());
    }

    public int hashCode() {
        int result = this.getFullPackageName().hashCode();
        result = 31 * result + this.getClassName().hashCode();
        result = 31 * result + this.getMethodName().hashCode();
        String string = this.getFormalDescriptor();
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    private static final VirtualFile findVirtualFile$lambda$1(BaseJavaMethodCall this$0, Project $project) {
        PsiFile psiFile = this$0.findContainingFile($project);
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final NavigatablePsiElement[] calcNavigatables$lambda$4(BaseJavaMethodCall this$0, Project $project) {
        NavigatablePsiElement[] navigatablePsiElementArray;
        NavigatablePsiElement[] methods;
        NavigatablePsiElement[] navigatablePsiElementArray2;
        PsiClass psiClass = this$0.findClass($project, this$0.getClassName());
        if (psiClass == null) {
            return this$0.findInOuterClass($project);
        }
        PsiClass cls = psiClass;
        if (Intrinsics.areEqual((Object)this$0.getMethodName(), (Object)"<clinit>")) {
            void $this$toTypedArray$iv;
            void $this$filterTo$iv$iv;
            PsiClassInitializer[] psiClassInitializerArray = cls.getInitializers();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassInitializerArray, (String)"getInitializers(...)");
            Object $this$filter$iv = psiClassInitializerArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiClassInitializer it = (PsiClassInitializer)element$iv$iv;
                boolean bl = false;
                if (!it.hasModifier(JvmModifier.STATIC)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            navigatablePsiElementArray2 = (NavigatablePsiElement[])thisCollection$iv.toArray(new PsiClassInitializer[0]);
        } else {
            navigatablePsiElementArray2 = this$0.findNavigatableMethod(cls);
        }
        NavigatablePsiElement[] navigatablePsiElementArray3 = methods = navigatablePsiElementArray2;
        if (navigatablePsiElementArray3.length == 0) {
            boolean bl = false;
            PsiClass[] psiClassArray = new PsiClass[]{cls};
            navigatablePsiElementArray = (NavigatablePsiElement[])psiClassArray;
        } else {
            navigatablePsiElementArray = navigatablePsiElementArray3;
        }
        return navigatablePsiElementArray;
    }

    @JvmStatic
    @NotNull
    public static final String simplifyGeneratedClassName(@NotNull String className) {
        return Companion.simplifyGeneratedClassName(className);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ultimate/model/BaseJavaMethodCall$Companion;", "", "<init>", "()V", "METHOD_ARGS_SEPARATOR", "", "signatureFromDescriptor", "", "formalDescriptor", "interner", "Lcom/intellij/util/containers/Interner;", "(Ljava/lang/String;Lcom/intellij/util/containers/Interner;)[Ljava/lang/String;", "simplifyGeneratedClassName", "className", "intellij.profiler.ultimate"})
    @SourceDebugExtension(value={"SMAP\nJavaCallStackElements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCallStackElements.kt\ncom/intellij/profiler/ultimate/model/BaseJavaMethodCall$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,322:1\n1563#2:323\n1634#2,3:324\n37#3:327\n36#3,3:328\n*S KotlinDebug\n*F\n+ 1 JavaCallStackElements.kt\ncom/intellij/profiler/ultimate/model/BaseJavaMethodCall$Companion\n*L\n201#1:323\n201#1:324,3\n202#1:327\n202#1:328,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String[] signatureFromDescriptor(@NotNull String formalDescriptor, @Nullable Interner<String> interner) {
            Intrinsics.checkNotNullParameter((Object)formalDescriptor, (String)"formalDescriptor");
            try {
                String argTypes = FormatToolkit.getParameters(formalDescriptor, false);
                Intrinsics.checkNotNull((Object)argTypes);
                if (StringsKt.startsWith$default((CharSequence)argTypes, (char)'(', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)argTypes, (char)')', (boolean)false, (int)2, null)) {
                    void $this$mapTo$iv$iv;
                    String[] stringArray = new String[]{BaseJavaMethodCall.METHOD_ARGS_SEPARATOR};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.dropLast((String)StringsKt.drop((String)argTypes, (int)1), (int)1), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(JavaCallStackElementsKt.access$tryIntern((String)it, interner));
                    }
                    List internedParts = (List)destination$iv$iv;
                    Collection $this$toTypedArray$iv = internedParts;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    return thisCollection$iv.toArray(new String[0]);
                }
                return null;
            }
            catch (Exception e) {
                JavaCallStackElementsKt.access$getLogger$p().error((Throwable)e);
                return null;
            }
        }

        public static /* synthetic */ String[] signatureFromDescriptor$default(Companion companion, String string, Interner interner, int n, Object object) {
            if ((n & 2) != 0) {
                interner = null;
            }
            return companion.signatureFromDescriptor(string, (Interner<String>)interner);
        }

        @JvmStatic
        @NotNull
        public final String simplifyGeneratedClassName(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            return StringsKt.contains$default((CharSequence)className, (CharSequence)"$Lambda$", (boolean)false, (int)2, null) ? StringsKt.substringBeforeLast$default((String)className, (String)"$", null, (int)2, null) : (StringsKt.contains$default((CharSequence)className, (CharSequence)"$$Lambda.", (boolean)false, (int)2, null) ? StringsKt.substringBeforeLast$default((String)className, (String)".", null, (int)2, null) : (StringsKt.contains$default((CharSequence)className, (CharSequence)"$$Lambda+", (boolean)false, (int)2, null) ? StringsKt.substringBeforeLast$default((String)className, (String)"+", null, (int)2, null) : (StringsKt.startsWith$default((String)className, (String)"LambdaForm$", (boolean)false, (int)2, null) ? "LambdaForm" : (StringsKt.startsWith$default((String)className, (String)"$Proxy", (boolean)false, (int)2, null) ? "$Proxy" : (StringsKt.startsWith$default((String)className, (String)"GeneratedMethodAccessor", (boolean)false, (int)2, null) ? "GeneratedMethodAccessor" : className)))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

