/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.visitors;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.RecordType;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.visitors.ClassVisitor;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0016J_\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\"H\u0016\u00a2\u0006\u0002\u0010(J(\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-H\u0016J0\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020-H\u0016J(\u00104\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u000207H\u0016J \u00108\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\t2\u0006\u00109\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0016J\u0018\u0010:\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006;"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/HistogramVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "classes", "Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;)V", "getClasses", "()Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;", "value", "", "totalInstances", "getTotalInstances", "()J", "minimumId", "maximumId", "threadSerialNumToObjectId", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "getThreadSerialNumToObjectId", "()Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "objectIdToThreadId", "getObjectIdToThreadId", "classloaders", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "getClassloaders", "()Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "preVisit", "", "visitClassDump", "classId", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitPrimitiveArrayDump", "arrayObjectId", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "primitiveArrayData", "visitObjectArrayDump", "arrayClassObjectId", "objects", "", "visitRootThreadObject", "threadSerialNumber", "visitRootObject", "intellij.profiler.ultimate"})
public final class HistogramVisitor
extends HProfVisitor {
    @NotNull
    private final ClassVisitor classes;
    private long totalInstances;
    private long minimumId;
    private long maximumId;
    @NotNull
    private final Long2LongOpenHashMap threadSerialNumToObjectId;
    @NotNull
    private final Long2LongOpenHashMap objectIdToThreadId;
    @NotNull
    private final LongOpenHashSet classloaders;

    public HistogramVisitor(@NotNull ClassVisitor classes) {
        Intrinsics.checkNotNullParameter((Object)((Object)classes), (String)"classes");
        this.classes = classes;
        this.minimumId = Long.MAX_VALUE;
        this.threadSerialNumToObjectId = new Long2LongOpenHashMap();
        this.objectIdToThreadId = new Long2LongOpenHashMap();
        this.classloaders = new LongOpenHashSet();
    }

    @NotNull
    public final ClassVisitor getClasses() {
        return this.classes;
    }

    public final long getTotalInstances() {
        return this.totalInstances;
    }

    @NotNull
    public final Long2LongOpenHashMap getThreadSerialNumToObjectId() {
        return this.threadSerialNumToObjectId;
    }

    @NotNull
    public final Long2LongOpenHashMap getObjectIdToThreadId() {
        return this.objectIdToThreadId;
    }

    @NotNull
    public final LongOpenHashSet getClassloaders() {
        return this.classloaders;
    }

    public void preVisit() {
        this.disableAll();
        this.enable(RecordType.HeapDump);
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.enable(HeapDumpRecordType.RootThreadObject);
        this.enable(HeapDumpRecordType.RootLocalJNI);
        this.enable(HeapDumpRecordType.RootJavaFrame);
        this.enable(HeapDumpRecordType.RootThreadBlock);
        this.enable(HeapDumpRecordType.RootNativeStack);
    }

    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        long l = this.totalInstances;
        this.totalInstances = l + 1L;
        this.minimumId = Math.min(classId, this.minimumId);
        this.maximumId = Math.max(classId, this.maximumId);
    }

    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        HprofClass hprofClass = this.classes.get(classObjectId);
        Intrinsics.checkNotNull((Object)hprofClass);
        HprofClass info = hprofClass;
        long l = info.getSoftRefCount();
        info.setSoftRefCount(l + 1L);
        l = this.totalInstances;
        this.totalInstances = l + 1L;
        this.minimumId = Math.min(objectId, this.minimumId);
        this.maximumId = Math.max(objectId, this.maximumId);
        if (classObjectId == this.classes.getIdOfThreadClass() || this.classes.isSubclassOf(classObjectId, this.classes.getIdOfThreadClass())) {
            int offset = 0;
            for (InstanceFieldEntry field : this.classes.collectInstanceFields(info.getClassId())) {
                if (Intrinsics.areEqual((Object)this.classes.getObjectString(field.getFieldNameStringId()), (Object)"tid")) {
                    this.objectIdToThreadId.put(objectId, bytes.getLong(offset));
                }
                offset += field.getType() == Type.OBJECT ? this.getSizeOfID() : field.getType().getSize();
            }
        }
        if (this.classes.isSubclassOf(classObjectId, this.classes.getIdOfClassLoaderClass())) {
            this.classloaders.add(objectId);
        }
    }

    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType, @NotNull ByteBuffer primitiveArrayData) {
        block0: {
            Int2IntOpenHashMap int2IntOpenHashMap;
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)primitiveArrayData, (String)"primitiveArrayData");
            HprofClass hprofClass = this.classes.get(this.classes.getClassForType(elementType));
            Intrinsics.checkNotNull((Object)hprofClass);
            HprofClass info = hprofClass;
            long l = info.getSoftRefCount();
            info.setSoftRefCount(l + 1L);
            l = this.totalInstances;
            this.totalInstances = l + 1L;
            this.minimumId = Math.min(arrayObjectId, this.minimumId);
            this.maximumId = Math.max(arrayObjectId, this.maximumId);
            Int2IntOpenHashMap int2IntOpenHashMap2 = info.getArrayLengths();
            if (int2IntOpenHashMap2 == null) break block0;
            Int2IntOpenHashMap $this$visitPrimitiveArrayDump_u24lambda_u241 = int2IntOpenHashMap = int2IntOpenHashMap2;
            boolean bl = false;
            $this$visitPrimitiveArrayDump_u24lambda_u241.computeIfPresent((int)numberOfElements, HistogramVisitor::visitPrimitiveArrayDump$lambda$1$lambda$0);
            $this$visitPrimitiveArrayDump_u24lambda_u241.putIfAbsent((int)numberOfElements, 1);
        }
    }

    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        block0: {
            Int2IntOpenHashMap int2IntOpenHashMap;
            Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
            HprofClass hprofClass = this.classes.get(arrayClassObjectId);
            Intrinsics.checkNotNull((Object)hprofClass);
            HprofClass info = hprofClass;
            long l = info.getSoftRefCount();
            info.setSoftRefCount(l + 1L);
            l = this.totalInstances;
            this.totalInstances = l + 1L;
            this.minimumId = Math.min(arrayObjectId, this.minimumId);
            this.maximumId = Math.max(arrayObjectId, this.maximumId);
            Int2IntOpenHashMap int2IntOpenHashMap2 = info.getArrayLengths();
            if (int2IntOpenHashMap2 == null) break block0;
            Int2IntOpenHashMap $this$visitObjectArrayDump_u24lambda_u243 = int2IntOpenHashMap = int2IntOpenHashMap2;
            boolean bl = false;
            $this$visitObjectArrayDump_u24lambda_u243.computeIfPresent(objects.length, HistogramVisitor::visitObjectArrayDump$lambda$3$lambda$2);
            $this$visitObjectArrayDump_u24lambda_u243.putIfAbsent(objects.length, 1);
        }
    }

    public void visitRootThreadObject(long objectId, long threadSerialNumber, long stackTraceSerialNumber) {
        this.visitRootObject(threadSerialNumber, objectId);
    }

    private final void visitRootObject(long threadSerialNumber, long objectId) {
        this.threadSerialNumToObjectId.put(threadSerialNumber, objectId);
    }

    private static final Integer visitPrimitiveArrayDump$lambda$1$lambda$0(Integer n, Integer u) {
        return u + 1;
    }

    private static final Integer visitObjectArrayDump$lambda$3$lambda$2(Integer n, Integer u) {
        return u + 1;
    }
}

