/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.unit;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import tec.uom.lib.common.function.Nameable;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.RationalConverter;
import tech.units.indriya.quantity.QuantityDimension;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.BaseUnit;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;

public class Units
extends AbstractSystemOfUnits
implements Nameable {
    private static final Units INSTANCE = new Units();
    public static final Unit<ElectricCurrent> AMPERE = Units.addUnit(new BaseUnit("A", QuantityDimension.ELECTRIC_CURRENT), ElectricCurrent.class);
    public static final Unit<LuminousIntensity> CANDELA = Units.addUnit(new BaseUnit("cd", QuantityDimension.LUMINOUS_INTENSITY), LuminousIntensity.class);
    public static final Unit<Temperature> KELVIN = Units.addUnit(new BaseUnit("K", QuantityDimension.TEMPERATURE), Temperature.class);
    public static final AbstractUnit<Mass> KILOGRAM = Units.addUnit(new BaseUnit("kg", QuantityDimension.MASS), Mass.class);
    public static final Unit<Length> METRE = Units.addUnit(new BaseUnit("m", QuantityDimension.LENGTH), Length.class);
    public static final Unit<AmountOfSubstance> MOLE = Units.addUnit(new BaseUnit("mol", QuantityDimension.AMOUNT_OF_SUBSTANCE), AmountOfSubstance.class);
    public static final Unit<Time> SECOND = Units.addUnit(new BaseUnit("s", QuantityDimension.TIME), Time.class);
    public static final Unit<Mass> GRAM = Units.addUnit(KILOGRAM.divide(1000.0));
    public static final Unit<Angle> RADIAN = Units.addUnit(new AlternateUnit(AbstractUnit.ONE, "rad"), Angle.class);
    public static final Unit<SolidAngle> STERADIAN = Units.addUnit(new AlternateUnit(AbstractUnit.ONE, "sr"), SolidAngle.class);
    public static final Unit<Frequency> HERTZ = Units.addUnit(new AlternateUnit(AbstractUnit.ONE.divide(SECOND), "Hz"), Frequency.class);
    public static final Unit<Force> NEWTON = Units.addUnit(new AlternateUnit(METRE.multiply(KILOGRAM).divide(SECOND.pow(2)), "N"), Force.class);
    public static final Unit<Pressure> PASCAL = Units.addUnit(new AlternateUnit(NEWTON.divide(METRE.pow(2)), "Pa"), Pressure.class);
    public static final Unit<Energy> JOULE = Units.addUnit(new AlternateUnit(NEWTON.multiply(METRE), "J"), Energy.class);
    public static final Unit<Power> WATT = Units.addUnit(new AlternateUnit(JOULE.divide(SECOND), "W"), Power.class);
    public static final Unit<ElectricCharge> COULOMB = Units.addUnit(new AlternateUnit(SECOND.multiply(AMPERE), "C"), ElectricCharge.class);
    public static final Unit<ElectricPotential> VOLT = Units.addUnit(new AlternateUnit(WATT.divide(AMPERE), "V"), ElectricPotential.class);
    public static final Unit<ElectricCapacitance> FARAD = Units.addUnit(new AlternateUnit(COULOMB.divide(VOLT), "F"), ElectricCapacitance.class);
    public static final AbstractUnit<ElectricResistance> OHM = Units.addUnit(new AlternateUnit(VOLT.divide(AMPERE), "\u03a9"), ElectricResistance.class);
    public static final Unit<ElectricConductance> SIEMENS = Units.addUnit(new AlternateUnit(AMPERE.divide(VOLT), "S"), ElectricConductance.class);
    public static final Unit<MagneticFlux> WEBER = Units.addUnit(new AlternateUnit(VOLT.multiply(SECOND), "Wb"), MagneticFlux.class);
    public static final Unit<MagneticFluxDensity> TESLA = Units.addUnit(new AlternateUnit(WEBER.divide(METRE.pow(2)), "T"), MagneticFluxDensity.class);
    public static final Unit<ElectricInductance> HENRY = Units.addUnit(new AlternateUnit(WEBER.divide(AMPERE), "H"), ElectricInductance.class);
    public static final AbstractUnit<Temperature> CELSIUS = Units.addUnit(new TransformedUnit<Temperature>(KELVIN, new AddConverter(273.15)));
    public static final Unit<LuminousFlux> LUMEN = Units.addUnit(new AlternateUnit(CANDELA.multiply(STERADIAN), "lm"), LuminousFlux.class);
    public static final Unit<Illuminance> LUX = Units.addUnit(new AlternateUnit(LUMEN.divide(METRE.pow(2)), "lx"), Illuminance.class);
    public static final Unit<Radioactivity> BECQUEREL = Units.addUnit(new AlternateUnit(AbstractUnit.ONE.divide(SECOND), "Bq"), Radioactivity.class);
    public static final Unit<RadiationDoseAbsorbed> GRAY = Units.addUnit(new AlternateUnit(JOULE.divide(KILOGRAM), "Gy"), RadiationDoseAbsorbed.class);
    public static final Unit<RadiationDoseEffective> SIEVERT = Units.addUnit(new AlternateUnit(JOULE.divide(KILOGRAM), "Sv"), RadiationDoseEffective.class);
    public static final Unit<CatalyticActivity> KATAL = Units.addUnit(new AlternateUnit(MOLE.divide(SECOND), "kat"), CatalyticActivity.class);
    public static final Unit<Speed> METRE_PER_SECOND = Units.addUnit(new ProductUnit(METRE.divide(SECOND)), Speed.class);
    public static final Unit<Acceleration> METRE_PER_SQUARE_SECOND = Units.addUnit(new ProductUnit(METRE_PER_SECOND.divide(SECOND)), Acceleration.class);
    public static final Unit<Area> SQUARE_METRE = Units.addUnit(new ProductUnit(METRE.multiply(METRE)), Area.class);
    public static final Unit<Volume> CUBIC_METRE = Units.addUnit(new ProductUnit(SQUARE_METRE.multiply(METRE)), Volume.class);
    public static final Unit<Speed> KILOMETRE_PER_HOUR = Units.addUnit(METRE_PER_SECOND.multiply(0.277778)).asType(Speed.class);
    public static final Unit<Dimensionless> PERCENT = Units.addUnit(new TransformedUnit<Dimensionless>(AbstractUnit.ONE, new RationalConverter(1L, 100L)));
    public static final Unit<Time> MINUTE = Units.addUnit(new TransformedUnit<Time>("min", SECOND, SECOND, new RationalConverter(60L, 1L)));
    public static final Unit<Time> HOUR = Units.addUnit(new TransformedUnit<Time>("h", SECOND, SECOND, new RationalConverter(3600L, 1L)));
    public static final Unit<Time> DAY = Units.addUnit(new TransformedUnit<Time>("d", SECOND, SECOND, new RationalConverter(86400L, 1L)));
    public static final Unit<Time> WEEK = Units.addUnit(DAY.multiply(7.0));
    public static final Unit<Time> YEAR = Units.addUnit(DAY.multiply(365.2425));
    public static final Unit<Volume> LITRE = AbstractSystemOfUnits.Helper.addUnit(Units.INSTANCE.units, new TransformedUnit<Volume>(CUBIC_METRE, new RationalConverter(1L, 1000L)), "Litre", "l");

    protected Units() {
    }

    @Override
    public String getName() {
        return Units.class.getSimpleName();
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        Units.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        Units.INSTANCE.units.add(unit);
        Units.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    static {
        Units.addUnit(AbstractUnit.ONE);
        Units.INSTANCE.quantityToUnit.put(Dimensionless.class, AbstractUnit.ONE);
    }
}

