/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.ModifiersCompatibilityUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.ModifierCheckerHelpersKt;
import org.jetbrains.kotlin.resolve.TargetAllowedPredicate;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J@\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J@\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u001d\u001a\u00020\u001e*\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0012\u0010\u001f\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkModifiers", "list", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "owner", "checkTarget", "", "modifierSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "actualTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "parent", "checkParent", "actualParents", "firstOrThis", "", "isFinalExpectClass", "d", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirModifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirModifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1#2:201\n94#3,5:202\n35#4:207\n74#4:208\n61#4:209\n17#4,2:216\n34#4:218\n1761#5,3:210\n1761#5,3:213\n2746#5,3:219\n1761#5,3:222\n*S KotlinDebug\n*F\n+ 1 FirModifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker\n*L\n57#1:202,5\n67#1:207\n68#1:208\n69#1:209\n197#1:216,2\n197#1:218\n154#1:210,3\n175#1:213,3\n109#1:219,3\n114#1:222,3\n*E\n"})
public final class FirModifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirModifierChecker INSTANCE = new FirModifierChecker();

    private FirModifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block1: {
            KtSourceElement source;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            KtSourceElement ktSourceElement = source = declaration instanceof FirFile ? ((FirFile)declaration).getPackageDirective().getSource() : declaration.getSource();
            if (source == null || source.getKind() instanceof KtFakeSourceElementKind) {
                return;
            }
            FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
            if (firModifierList == null) break block1;
            FirModifierList it = firModifierList;
            boolean bl = false;
            INSTANCE.checkModifiers(it, declaration, context, reporter);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkModifiers(FirModifierList list, FirDeclaration owner, CheckerContext context, DiagnosticReporter reporter) {
        block17: {
            if (list.getModifiers().isEmpty()) {
                return;
            }
            reportedNodes = new HashSet<E>();
            actualTargets = FirHelpersKt.getActualTargetList(owner).getDefaultTargets();
            $this$findClosest$iv = context;
            $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                v0 = it$iv;
                if (!(v0 instanceof FirDeclaration)) {
                    v0 = null;
                }
                if ((v1 = (FirElement)v0) == null) continue;
                var12_14 = v1;
                it = (FirDeclaration)var12_14;
                $i$a$-findClosest-FirModifierChecker$checkModifiers$parent$1 = false;
                if (it instanceof FirPrimaryConstructor || it instanceof FirProperty) ** GOTO lbl-1000
                v2 = it.getSource();
                if (!((v2 != null ? v2.getKind() : null) instanceof KtFakeSourceElementKind)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if ((v1 = v3 != false ? var12_14 : null) == null) {
                    continue;
                }
                break block17;
            }
            v1 = null;
        }
        if (($i$f$findClosest = (parent = (FirDeclaration)v1)) instanceof FirAnonymousObject) {
            v4 = KotlinTarget.Companion.getLOCAL_CLASS_LIST();
        } else if ($i$f$findClosest instanceof FirClass) {
            v5 = ((FirClass)parent).getClassKind();
            it$iv = parent;
            v6 = it$iv instanceof FirMemberDeclaration != false ? (FirMemberDeclaration)it$iv : null;
            if (v6 != null) {
                $this$isInner$iv = v6;
                $i$f$isInner = false;
                v7 = $this$isInner$iv.getStatus().isInner();
            } else {
                v7 = false;
            }
            it$iv = parent;
            v8 = it$iv instanceof FirRegularClass != false ? (FirRegularClass)it$iv : null;
            if (v8 != null) {
                $this$isCompanion$iv = v8;
                $i$f$isCompanion = false;
                v9 = $this$isCompanion$iv.getStatus().isCompanion();
            } else {
                v9 = false;
            }
            $this$isLocal$iv = (FirClassLikeDeclaration)parent;
            $i$f$isLocal = false;
            v4 = KotlinTarget.Companion.classActualTargets(v5, v7, v9, $this$isLocal$iv.getSymbol().getClassId().isLocal());
        } else {
            v4 = $i$f$findClosest instanceof FirPropertyAccessor ? (((FirPropertyAccessor)parent).isSetter() ? KotlinTarget.Companion.getPROPERTY_SETTER_LIST() : KotlinTarget.Companion.getPROPERTY_GETTER_LIST()) : ($i$f$findClosest instanceof FirFunction != false ? KotlinTarget.Companion.getFUNCTION_LIST() : ($i$f$findClosest instanceof FirEnumEntry != false ? KotlinTarget.Companion.getENUM_ENTRY_LIST() : KotlinTarget.Companion.getFILE_LIST()));
        }
        actualParents = v4;
        modifiers = list.getModifiers();
        var10_10 = ((Iterable)modifiers).iterator();
        var11_13 = 0;
        while (var10_10.hasNext()) {
            secondIndex = var11_13++;
            secondModifier = (FirModifier)var10_10.next();
            for (firstIndex = 0; firstIndex < secondIndex; ++firstIndex) {
                ModifiersCompatibilityUtilsKt.checkCompatibilityType(modifiers.get(firstIndex), secondModifier, reporter, (Set)reportedNodes, owner, context);
            }
            if (reportedNodes.contains(secondModifier)) continue;
            modifierSource = secondModifier.getSource();
            modifier = secondModifier.getToken();
            if (!this.checkTarget(modifierSource, modifier, actualTargets, parent, context, reporter)) {
                ((Collection)reportedNodes).add(secondModifier);
                continue;
            }
            if (this.checkParent(modifierSource, modifier, actualParents, parent, context, reporter)) continue;
            ((Collection)reportedNodes).add(secondModifier);
        }
    }

    private final boolean checkTarget(KtSourceElement modifierSource, KtModifierKeywordToken modifierToken, List<? extends KotlinTarget> actualTargets, FirDeclaration parent2, CheckerContext context, DiagnosticReporter reporter) {
        if (!FirModifierChecker.checkTarget$checkModifier(modifierToken, actualTargets, context, reporter, modifierSource, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET())) {
            return false;
        }
        if (parent2 instanceof FirRegularClass && Intrinsics.areEqual(modifierToken, KtTokens.EXPECT_KEYWORD)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifierSource, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)modifierToken, (Object)"nested class", (DiagnosticContext)context, null, 32, null);
            return false;
        }
        if (FirModifierChecker.checkTarget$checkModifier(modifierToken, actualTargets, context, reporter, modifierSource, FirErrors.INSTANCE.getDEPRECATED_MODIFIER_FOR_TARGET())) {
            FirModifierChecker.checkTarget$checkModifier(modifierToken, actualTargets, context, reporter, modifierSource, FirErrors.INSTANCE.getREDUNDANT_MODIFIER_FOR_TARGET());
        }
        return true;
    }

    private final boolean checkParent(KtSourceElement modifierSource, KtModifierKeywordToken modifierToken, List<? extends KotlinTarget> actualParents, FirDeclaration parent2, CheckerContext context, DiagnosticReporter reporter) {
        boolean bl;
        block14: {
            Set<KotlinTarget> deprecatedParents = ModifierCheckerHelpersKt.getDeprecatedParentTargetMap().get(modifierToken);
            if (deprecatedParents != null) {
                boolean bl2;
                block13: {
                    Iterable $this$any$iv = actualParents;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinTarget it = (KotlinTarget)((Object)element$iv);
                            boolean bl3 = false;
                            if (!deprecatedParents.contains((Object)it)) continue;
                            bl2 = true;
                            break block13;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifierSource, FirErrors.INSTANCE.getDEPRECATED_MODIFIER_CONTAINING_DECLARATION(), (Object)modifierToken, (Object)this.firstOrThis(actualParents), (DiagnosticContext)context, null, 32, null);
                    return true;
                }
            }
            if (Intrinsics.areEqual(modifierToken, KtTokens.PROTECTED_KEYWORD) && this.isFinalExpectClass(parent2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifierSource, FirErrors.INSTANCE.getWRONG_MODIFIER_CONTAINING_DECLARATION(), (Object)modifierToken, (Object)"final expect class", (DiagnosticContext)context, null, 32, null);
            }
            TargetAllowedPredicate targetAllowedPredicate = ModifierCheckerHelpersKt.getPossibleParentTargetPredicateMap().get(modifierToken);
            if (targetAllowedPredicate == null) {
                return true;
            }
            TargetAllowedPredicate possibleParentPredicate = targetAllowedPredicate;
            Iterable $this$any$iv = actualParents;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!possibleParentPredicate.isAllowed(it, FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()))) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        if (Intrinsics.areEqual(modifierToken, KtTokens.INNER_KEYWORD) && parent2 instanceof FirScript) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifierSource, FirErrors.INSTANCE.getINNER_ON_TOP_LEVEL_SCRIPT_CLASS(), (DiagnosticContext)context, null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifierSource, FirErrors.INSTANCE.getWRONG_MODIFIER_CONTAINING_DECLARATION(), (Object)modifierToken, (Object)this.firstOrThis(actualParents), (DiagnosticContext)context, null, 32, null);
        }
        return false;
    }

    private final String firstOrThis(List<? extends KotlinTarget> $this$firstOrThis) {
        Object object = CollectionsKt.firstOrNull($this$firstOrThis);
        if (object == null || (object = object.getDescription()) == null) {
            object = "this";
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFinalExpectClass(FirDeclaration d) {
        boolean bl;
        if (!(d instanceof FirClass)) return false;
        FirMemberDeclaration $this$isFinal$iv = (FirMemberDeclaration)d;
        boolean $i$f$isFinal = false;
        Modality modality = $this$isFinal$iv.getStatus().getModality();
        if (modality == null) {
            bl = true;
        } else {
            Modality modality$iv = modality;
            if (modality$iv != Modality.FINAL) return false;
            bl = true;
        }
        if (!bl) return false;
        FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)d;
        boolean $i$f$isExpect = false;
        if (!$this$isExpect$iv.getStatus().isExpect()) return false;
        return true;
    }

    private static final boolean checkTarget$checkModifier(KtModifierKeywordToken $modifierToken, List<? extends KotlinTarget> $actualTargets, CheckerContext $context, DiagnosticReporter $reporter, KtSourceElement $modifierSource, KtDiagnosticFactory2<KtModifierKeywordToken, String> factory) {
        boolean checkResult;
        block11: {
            boolean bl;
            KotlinTarget it;
            Set<KotlinTarget> set;
            Map<KtModifierKeywordToken, Set<KotlinTarget>> map;
            KtDiagnosticFactory2<KtModifierKeywordToken, String> ktDiagnosticFactory2 = factory;
            Map<KtKeywordToken, Set<KotlinTarget>> map2 = map = Intrinsics.areEqual(ktDiagnosticFactory2, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET()) ? ModifierCheckerHelpersKt.getPossibleTargetMap() : (Intrinsics.areEqual(ktDiagnosticFactory2, FirErrors.INSTANCE.getDEPRECATED_MODIFIER_FOR_TARGET()) ? ModifierCheckerHelpersKt.getDeprecatedTargetMap() : ModifierCheckerHelpersKt.getRedundantTargetMap());
            Set<KotlinTarget> set2 = map.get($modifierToken);
            if (set2 == null) {
                set2 = set = SetsKt.emptySet();
            }
            if (Intrinsics.areEqual(factory, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET())) {
                boolean bl2;
                block10: {
                    Iterable $this$none$iv = $actualTargets;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (KotlinTarget)((Object)element$iv);
                            boolean bl3 = false;
                            if (!set.contains((Object)it)) continue;
                            bl2 = false;
                            break block10;
                        }
                        bl2 = true;
                    }
                }
                bl = bl2 || Intrinsics.areEqual($modifierToken, KtTokens.DATA_KEYWORD) && $actualTargets.contains((Object)KotlinTarget.STANDALONE_OBJECT) && !$context.getLanguageVersionSettings().supportsFeature(LanguageFeature.DataObjects);
            } else {
                Iterable $this$any$iv = $actualTargets;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KotlinTarget)((Object)element$iv);
                        boolean bl4 = false;
                        if (!set.contains((Object)it)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = checkResult = false;
                }
            }
        }
        if (checkResult) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$modifierSource, factory, (Object)$modifierToken, (Object)INSTANCE.firstOrThis($actualTargets), (DiagnosticContext)$context, null, 32, null);
            return false;
        }
        return true;
    }
}

