/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.data;

import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.tools.data.ParsedFeature;
import com.jetbrains.ml.tools.data.ParsedFeatureKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\b\u0016\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007B-\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012J\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00050\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aR)\u0010\u0002\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/ml/tools/data/DataFrame;", "", "columns", "", "", "", "Lcom/jetbrains/ml/tools/data/ParsedFeature;", "(Ljava/util/Map;)V", "Lkotlin/Pair;", "size", "", "(Ljava/util/List;I)V", "getColumns", "()Ljava/util/List;", "getSize", "()I", "drop", "toDrop", "", "toFeatures", "Lcom/jetbrains/ml/api/feature/Feature;", "write", "", "outputStream", "Ljava/io/OutputStream;", "path", "Ljava/nio/file/Path;", "Companion", "ml-tools"})
@SourceDebugExtension(value={"SMAP\nDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrame.kt\ncom/jetbrains/ml/tools/data/DataFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n*L\n1#1,110:1\n819#2:111\n847#2,2:112\n1549#2:114\n1620#2,3:115\n1549#2:119\n1620#2,2:120\n1864#2,3:122\n1622#2:125\n1179#2,2:126\n1253#2,2:128\n1549#2:130\n1620#2,3:131\n1256#2:134\n1#3:118\n42#4:135\n*S KotlinDebug\n*F\n+ 1 DataFrame.kt\ncom/jetbrains/ml/tools/data/DataFrame\n*L\n20#1:111\n20#1:112,2\n23#1:114\n23#1:115,3\n27#1:119\n27#1:120,2\n28#1:122,3\n27#1:125\n44#1:126,2\n44#1:128,2\n45#1:130\n45#1:131,3\n44#1:134\n47#1:135\n*E\n"})
public final class DataFrame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pair<String, List<ParsedFeature>>> columns;
    private final int size;

    public DataFrame(@NotNull List<? extends Pair<String, ? extends List<? extends ParsedFeature>>> columns, int size) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columns = columns;
        this.size = size;
    }

    @NotNull
    public final List<Pair<String, List<ParsedFeature>>> getColumns() {
        return this.columns;
    }

    public final int getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame drop(@NotNull Iterable<String> toDrop) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(toDrop, (String)"toDrop");
        Iterable $this$filterNot$iv = this.columns;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (CollectionsKt.contains(toDrop, (Object)it.getFirst())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int n = this.size;
        List list = (List)destination$iv$iv;
        return new DataFrame(list, n);
    }

    /*
     * WARNING - void declaration
     */
    public DataFrame(@NotNull Map<String, ? extends List<? extends ParsedFeature>> columns) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Iterable iterable = columns.entrySet();
        DataFrame dataFrame = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_12 = it;
            collection.add(new Pair(var11_12.getKey(), var11_12.getValue()));
        }
        dataFrame((List)destination$iv$iv, columns.size());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<Feature>> toFeatures() {
        void $this$mapTo$iv$iv;
        Collection<Unit> collection;
        int n = this.size;
        ArrayList<List> arrayList = new ArrayList<List>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            collection = arrayList;
            boolean bl = false;
            ((ArrayList)collection).add((Unit)new ArrayList());
        }
        List features = arrayList;
        Iterable $this$map$iv = this.columns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String column = (String)pair.component1();
            List values = (List)pair.component2();
            Iterable $this$forEachIndexed$iv = values;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void dfValue;
                int n5;
                if ((n5 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ParsedFeature parsedFeature = (ParsedFeature)item$iv;
                int rowI = n5;
                boolean bl2 = false;
                Feature feature = dfValue.toFeature(column);
                ((List)features.get(rowI)).add(feature);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this, *options)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            OutputStream outputStream2 = (OutputStream)closeable;
            boolean bl = false;
            this.write(outputStream2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull OutputStream outputStream) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Iterable $this$associate$iv = this.columns;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map map = destination$iv$iv;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            String columnName = (String)pair.component1();
            List dfValues = (List)pair.component2();
            Iterable iterable2 = dfValues;
            String string = columnName;
            boolean $i$f$map = false;
            void var19_19 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ParsedFeature parsedFeature = (ParsedFeature)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.toJsonElement());
            }
            List list = (List)destination$iv$iv2;
            pair = TuplesKt.to((Object)string, (Object)new JsonArray(list));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        JsonObject jsonObject = new JsonObject(map);
        Json $this$encodeToStream$iv = (Json)Json.Default;
        boolean $i$f$encodeToStream = false;
        SerializersModule serializersModule = $this$encodeToStream$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonObject.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType)), (Object)jsonObject, (OutputStream)outputStream);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/ml/tools/data/DataFrame$Companion;", "", "()V", "fromFeatures", "Lcom/jetbrains/ml/tools/data/DataFrame;", "batch", "", "", "Lcom/jetbrains/ml/api/feature/Feature;", "read", "inputStream", "Ljava/io/InputStream;", "path", "Ljava/nio/file/Path;", "ml-tools"})
    @SourceDebugExtension(value={"SMAP\nDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrame.kt\ncom/jetbrains/ml/tools/data/DataFrame$Companion\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n80#2:111\n1549#3:112\n1620#3,2:113\n1549#3:115\n1620#3,3:116\n1622#3:119\n1549#3:120\n1620#3,3:121\n1179#3,2:124\n1253#3,4:126\n1864#3,2:130\n1855#3,2:132\n1866#3:134\n*S KotlinDebug\n*F\n+ 1 DataFrame.kt\ncom/jetbrains/ml/tools/data/DataFrame$Companion\n*L\n59#1:111\n64#1:112\n64#1:113,2\n74#1:115\n74#1:116,3\n64#1:119\n90#1:120\n90#1:121,3\n92#1:124,2\n92#1:126,4\n96#1:130,2\n97#1:132,2\n96#1:134\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final DataFrame read(@NotNull Path path) {
            DataFrame dataFrame;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                dataFrame = Companion.read(stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return dataFrame;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DataFrame read(@NotNull InputStream inputStream) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Json $this$decodeFromStream$iv = (Json)Json.Default;
            boolean $i$f$decodeFromStream = false;
            SerializersModule serializersModule = $this$decodeFromStream$iv.getSerializersModule();
            KType kType = Reflection.typeOf(JsonObject.class);
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            JsonObject obj = (JsonObject)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType)), (InputStream)inputStream);
            Set columns = obj.keySet();
            Integer size = null;
            Iterable $this$map$iv = columns;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void column;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsonArray jsonArray = JsonElementKt.getJsonArray((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)obj), (Object)column)));
                if (size != null) {
                    if (!(jsonArray.size() == size.intValue())) {
                        boolean $i$a$-check-DataFrame$Companion$read$columnToValues$1$22 = false;
                        String $i$a$-check-DataFrame$Companion$read$columnToValues$1$22 = "Inconsistent DataFrame: column " + (String)column + " has size " + jsonArray.size() + " elements, but the dataframe has length " + size;
                        throw new IllegalStateException($i$a$-check-DataFrame$Companion$read$columnToValues$1$22.toString());
                    }
                } else {
                    size = jsonArray.size();
                }
                Iterable $this$map$iv2 = (Iterable)jsonArray;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    ParsedFeature parsedFeature;
                    void element;
                    JsonElement jsonElement = (JsonElement)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    try {
                        parsedFeature = ParsedFeature.Companion.fromJsonElement((JsonElement)element);
                    }
                    catch (Throwable e) {
                        throw new Exception("Can't read value " + (JsonElement)element + " in column " + (String)column, e);
                    }
                    collection2.add(parsedFeature);
                }
                List fields = (List)destination$iv$iv2;
                collection.add(TuplesKt.to((Object)column, (Object)fields));
            }
            List columnToValues = (List)destination$iv$iv;
            Integer n = size;
            return new DataFrame(columnToValues, n != null ? n : 0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DataFrame fromFeatures(@NotNull List<? extends Collection<? extends Feature>> batch) {
            void $this$associateTo$iv$iv;
            Collection it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(batch, (String)"batch");
            if (batch.isEmpty()) {
                return new DataFrame(MapsKt.emptyMap());
            }
            Iterable $this$map$iv = (Iterable)CollectionsKt.first(batch);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Feature feature = (Feature)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            Set header = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$associate$iv = header;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable $i$f$mapTo22 = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                String column = (String)element$iv$iv;
                boolean bl = false;
                column = TuplesKt.to((Object)column, (Object)new ArrayList());
                map.put(column.getFirst(), column.getSecond());
            }
            Map columns = destination$iv$iv2;
            Iterable $this$forEachIndexed$iv = batch;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void row;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                it = (Collection)item$iv;
                int rowI = n;
                boolean bl = false;
                Iterable $this$forEach$iv = (Iterable)row;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Feature feature = (Feature)element$iv;
                    boolean bl2 = false;
                    if (!header.contains(feature.getName())) {
                        boolean bl3 = false;
                        String string = "Batch row " + rowI + " has feature " + feature + " which is not in the first row";
                        throw new IllegalStateException(string.toString());
                    }
                    ParsedFeature dfValue = ParsedFeatureKt.toSerializedFeature(feature);
                    ((List)MapsKt.getValue((Map)columns, (Object)feature.getName())).add(dfValue);
                }
            }
            return new DataFrame(columns);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

