/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.api.feature;

import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureDeclaration;
import com.jetbrains.ml.api.feature.FeatureDeclarator;
import com.jetbrains.ml.api.feature.FeatureSet;
import com.jetbrains.ml.api.feature.FeatureSignature;
import com.jetbrains.ml.api.feature.FeatureSignatureKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a(\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0002\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e*\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"fillNulls", "", "Lcom/jetbrains/ml/api/feature/Feature;", "Lcom/jetbrains/ml/api/feature/FeatureDeclarator;", "providedFeatures", "", "requiredOutput", "Lcom/jetbrains/ml/api/feature/FeatureSet;", "removeRedundantFeatures", "computedFeaturesWithRedundancies", "requireDeclared", "", "computedFeatures", "selectFeatureList", "", "ml-api"})
@SourceDebugExtension(value={"SMAP\nFeatureDeclarator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureDeclarator.kt\ncom/jetbrains/ml/api/feature/FeatureDeclaratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n766#2:136\n857#2,2:137\n1477#2:139\n1502#2,3:140\n1505#2,3:150\n1603#2,9:160\n1855#2:169\n1856#2:171\n1612#2:172\n372#3,7:143\n526#3:153\n511#3,6:154\n1#4:170\n*S KotlinDebug\n*F\n+ 1 FeatureDeclarator.kt\ncom/jetbrains/ml/api/feature/FeatureDeclaratorKt\n*L\n43#1:136\n43#1:137,2\n97#1:139\n97#1:140,3\n97#1:150,3\n107#1:160,9\n107#1:169\n107#1:171\n107#1:172\n97#1:143,7\n98#1:153\n98#1:154,6\n107#1:170\n*E\n"})
public final class FeatureDeclaratorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Feature> selectFeatureList(@NotNull FeatureDeclarator $this$selectFeatureList, @NotNull Iterable<? extends Feature> computedFeatures, @NotNull FeatureSet requiredOutput) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$selectFeatureList, (String)"<this>");
        Intrinsics.checkNotNullParameter(computedFeatures, (String)"computedFeatures");
        Intrinsics.checkNotNullParameter((Object)requiredOutput, (String)"requiredOutput");
        List<Feature> redundanciesFreeFeatures = FeatureDeclaratorKt.removeRedundantFeatures($this$selectFeatureList, requiredOutput, computedFeatures);
        FeatureDeclaratorKt.requireDeclared($this$selectFeatureList, redundanciesFreeFeatures);
        List<Feature> result = FeatureDeclaratorKt.fillNulls($this$selectFeatureList, (Iterable<? extends Feature>)redundanciesFreeFeatures, requiredOutput);
        Collection<FeatureSignature> missing = requiredOutput.selectMissingFeatures((Collection<? extends Feature>)result);
        Iterable $this$filter$iv = missing;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FeatureSignature it = (FeatureSignature)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)$this$selectFeatureList.getFeatureDeclarations(), (Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List knownAndMissing = (List)destination$iv$iv;
        if (!knownAndMissing.isEmpty()) {
            boolean bl = false;
            String string = StringsKt.trimIndent((String)("\n      Some features were expected from " + $this$selectFeatureList + ", but were not computed:\n        " + missing + "\n    "));
            throw new IllegalArgumentException(string.toString());
        }
        return result;
    }

    private static final List<Feature> fillNulls(FeatureDeclarator $this$fillNulls, Iterable<? extends Feature> providedFeatures, FeatureSet requiredOutput) {
        List result = CollectionsKt.toMutableList(providedFeatures);
        for (FeatureDeclaration<?> feature : $this$fillNulls.getFeatureDeclarations()) {
            if (FeatureSignatureKt.anyMatches(providedFeatures, feature) || !requiredOutput.contains(feature)) continue;
            if (!feature.isNullable()) {
                boolean $i$a$-require-FeatureDeclaratorKt$fillNulls$32 = false;
                String $i$a$-require-FeatureDeclaratorKt$fillNulls$32 = StringsKt.trimIndent((String)("\n        Feature " + feature + " should have been computed by " + $this$fillNulls + "\n         \n         !!! Solution: If your feature is actually nullable, then declare " + feature + " as nullable, by adding `.nullable()` to the declaration.\n             Then, either pass the `null` value explicitly to the result, or set `FeatureComputationPolicy.putNullImplicitly` to true.\n\n      "));
                throw new IllegalArgumentException($i$a$-require-FeatureDeclaratorKt$fillNulls$32.toString());
            }
            if (!$this$fillNulls.getFeatureComputationPolicy().getPutNullImplicitly()) {
                boolean bl = false;
                String string = StringsKt.trimIndent((String)("\n        Feature " + feature + " should have been computed by " + $this$fillNulls + ".\n        It is nullable, but any value is missing.\n        \n        !!! Solution: Either pass the `null` value to the result explicitly,\n            or set `FeatureComputationPolicy.putNullImplicitly` to true\n  \n      "));
                throw new IllegalArgumentException(string.toString());
            }
            FeatureDeclaratorKt.fillNulls$putNull(result, feature);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Feature> removeRedundantFeatures(FeatureDeclarator $this$removeRedundantFeatures, FeatureSet requiredOutput, Iterable<? extends Feature> computedFeaturesWithRedundancies) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable<? extends Feature> $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable<? extends Feature> iterable = computedFeaturesWithRedundancies;
        boolean $i$f$groupBy = false;
        void var6_6 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Feature it = (Feature)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            object = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            List features = (List)object.getValue();
            if (!(features.size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object duplicates = destination$iv$iv;
        if (!duplicates.isEmpty()) {
            boolean $i$a$-require-FeatureDeclaratorKt$removeRedundantFeatures$22 = false;
            String $i$a$-require-FeatureDeclaratorKt$removeRedundantFeatures$22 = StringsKt.trimIndent((String)("\n      " + $this$removeRedundantFeatures + " has produced duplicate features:\n        " + (Map)duplicates + "\n    "));
            throw new IllegalArgumentException($i$a$-require-FeatureDeclaratorKt$removeRedundantFeatures$22.toString());
        }
        Iterable<? extends Feature> $this$mapNotNull$iv = computedFeaturesWithRedundancies;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Feature feature;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Feature computedFeature = (Feature)element$iv$iv;
            boolean bl3 = false;
            if (!requiredOutput.contains(computedFeature.getSignature())) {
                if (!$this$removeRedundantFeatures.getFeatureComputationPolicy().getTolerateRedundantFeatures()) {
                    throw new IllegalArgumentException(StringsKt.trimIndent((String)("\n              Feature " + computedFeature + " of " + $this$removeRedundantFeatures + " must not have been computed.\n\n                !!! Solution: You could set FeatureComputationPolicy.tolerateRedundantFeatures to true, if this provider computes lightweight features,\n                and redundantly computed features could be tolerated.\n\n            ")));
                }
                feature = null;
            } else {
                feature = computedFeature;
            }
            if (feature == null) continue;
            Feature it$iv$iv = feature;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void requireDeclared(FeatureDeclarator $this$requireDeclared, List<? extends Feature> computedFeatures) {
        for (Feature feature : computedFeatures) {
            if (FeatureSignatureKt.isDeclaredBy(feature, (Iterable<? extends FeatureSignature>)$this$requireDeclared.getFeatureDeclarations())) continue;
            boolean bl = false;
            String string = "Feature " + feature + " has been computed, but was not declared by " + $this$requireDeclared;
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final <T> void fillNulls$putNull(List<Feature> result, FeatureDeclaration<T> declaration) {
        Intrinsics.checkNotNull(declaration, (String)"null cannot be cast to non-null type com.jetbrains.ml.api.feature.FeatureDeclaration<kotlin.Any?>");
        result.add(declaration.with(null));
    }
}

