/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.io.ConnectToChannelResult;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H&J(\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0007J\u001d\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010\u001bJ.\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0002H\u0014J\f\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "VmT", "Lorg/jetbrains/debugger/Vm;", "Lorg/jetbrains/debugger/connection/VmConnection;", "<init>", "()V", "address", "Ljava/net/InetSocketAddress;", "getAddress", "()Ljava/net/InetSocketAddress;", "setAddress", "(Ljava/net/InetSocketAddress;)V", "connectCancelHandler", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Function0;", "", "createBootstrap", "Lio/netty/bootstrap/Bootstrap;", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "open", "Lorg/jetbrains/concurrency/Promise;", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "connectionSucceeded", "it", "(Lorg/jetbrains/debugger/Vm;Ljava/net/InetSocketAddress;)V", "doOpen", "result", "connectedAddressToPresentation", "", "vm", "detachAndClose", "intellij.platform.scriptDebugger.ui"})
@SourceDebugExtension(value={"SMAP\nRemoteVmConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteVmConnection.kt\norg/jetbrains/debugger/connection/RemoteVmConnection\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,169:1\n24#2:170\n*S KotlinDebug\n*F\n+ 1 RemoteVmConnection.kt\norg/jetbrains/debugger/connection/RemoteVmConnection\n*L\n52#1:170\n*E\n"})
public abstract class RemoteVmConnection<VmT extends Vm>
extends VmConnection<VmT> {
    @Nullable
    private InetSocketAddress address;
    @NotNull
    private final AtomicReference<Function0<Unit>> connectCancelHandler = new AtomicReference();

    @Nullable
    public final InetSocketAddress getAddress() {
        return this.address;
    }

    public final void setAddress(@Nullable InetSocketAddress inetSocketAddress) {
        this.address = inetSocketAddress;
    }

    @NotNull
    public abstract Bootstrap createBootstrap(@NotNull InetSocketAddress var1, @NotNull AsyncPromise<VmT> var2);

    @JvmOverloads
    @NotNull
    public final Promise<VmT> open(@NotNull InetSocketAddress address, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (address.isUnresolved()) {
            String error = "Host " + address.getHostString() + " is unresolved";
            VmConnection.setState$default(this, ConnectionStatus.CONNECTION_FAILED, error, null, 4, null);
            return Promises.rejectedPromise((String)error);
        }
        this.address = address;
        VmConnection.setState$default(this, ConnectionStatus.WAITING_FOR_CONNECTION, "Connecting to " + address.getHostString() + ":" + address.getPort(), null, 4, null);
        AsyncPromise result = new AsyncPromise();
        result.onSuccess(arg_0 -> RemoteVmConnection.open$lambda$1(arg_0 -> RemoteVmConnection.open$lambda$0(this, address, arg_0), arg_0)).onError(arg_0 -> RemoteVmConnection.open$lambda$3(arg_0 -> RemoteVmConnection.open$lambda$2(this, arg_0), arg_0)).onProcessed(arg_0 -> RemoteVmConnection.open$lambda$5(arg_0 -> RemoteVmConnection.open$lambda$4(this, arg_0), arg_0));
        java.util.concurrent.Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> RemoteVmConnection.open$lambda$7(this, result, address, stopCondition));
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
        java.util.concurrent.Future future2 = future;
        this.connectCancelHandler.set((Function0<Unit>)((Function0)() -> RemoteVmConnection.open$lambda$8(future2, result)));
        return (Promise)result;
    }

    public static /* synthetic */ Promise open$default(RemoteVmConnection remoteVmConnection, InetSocketAddress inetSocketAddress, Condition condition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: open");
        }
        if ((n & 2) != 0) {
            condition = null;
        }
        return remoteVmConnection.open(inetSocketAddress, (Condition<Void>)condition);
    }

    protected final void connectionSucceeded(@NotNull VmT it, @NotNull InetSocketAddress address) {
        Intrinsics.checkNotNullParameter(it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.setVm(it);
        VmConnection.setState$default(this, ConnectionStatus.CONNECTED, "Connected to " + this.connectedAddressToPresentation(address, (Vm)it), null, 4, null);
        this.startProcessing();
    }

    protected void doOpen(@NotNull AsyncPromise<VmT> result, @NotNull InetSocketAddress address, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        int maxAttemptCount = stopCondition == null ? 20 : -1;
        Condition resultRejected = arg_0 -> RemoteVmConnection.doOpen$lambda$9(result, arg_0);
        Condition condition = stopCondition;
        if (condition == null) {
            condition = Conditions.alwaysFalse();
        }
        Condition condition2 = Conditions.or((Condition)condition, (Condition)resultRejected);
        Intrinsics.checkNotNullExpressionValue((Object)condition2, (String)"or(...)");
        Condition combinedCondition = condition2;
        ConnectToChannelResult connectResult = NettyKt.connectRetrying((Bootstrap)this.createBootstrap(address, result), (InetSocketAddress)address, (int)maxAttemptCount, (Condition)combinedCondition);
        connectResult.handleError(arg_0 -> RemoteVmConnection.doOpen$lambda$10(result, arg_0));
        connectResult.handleThrowable(arg_0 -> RemoteVmConnection.doOpen$lambda$11(result, arg_0));
        Channel channel = connectResult.getChannel();
        Channel channel2 = channel;
        if (channel2 != null && (channel2 = channel2.closeFuture()) != null) {
            channel2.addListener(arg_0 -> RemoteVmConnection.doOpen$lambda$12(result, this, arg_0));
        }
        if (channel != null) {
            this.stateChanged((Function1<ConnectionState, Unit>)((Function1)arg_0 -> RemoteVmConnection.doOpen$lambda$13(channel, arg_0)));
        }
    }

    @NotNull
    protected String connectedAddressToPresentation(@NotNull InetSocketAddress address, @NotNull Vm vm) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        return address.getHostString() + ":" + address.getPort();
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public Promise<?> detachAndClose() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Removing goto target
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.removeTarget(Op03SimpleStatement.java:365)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.nopOut(Op03SimpleStatement.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.PointlessExpressions.removePointlessExpressionStatements(PointlessExpressions.java:28)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.removePointlessExpressionStatements(Op03Rewriters.java:185)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:561)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @JvmOverloads
    @NotNull
    public final Promise<VmT> open(@NotNull InetSocketAddress address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return RemoteVmConnection.open$default(this, address, null, 2, null);
    }

    private static final Unit open$lambda$0(RemoteVmConnection this$0, InetSocketAddress $address, Vm it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.connectionSucceeded(it, $address);
        return Unit.INSTANCE;
    }

    private static final void open$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit open$lambda$2(RemoteVmConnection this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!(it instanceof ConnectException)) {
            RemoteVmConnection $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(RemoteVmConnection.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Promises.errorIfNotMessage((Logger)logger, (Throwable)it);
        }
        VmConnection.setState$default(this$0, ConnectionStatus.CONNECTION_FAILED, it.getMessage(), null, 4, null);
        return Unit.INSTANCE;
    }

    private static final void open$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit open$lambda$4(RemoteVmConnection this$0, Vm it) {
        this$0.connectCancelHandler.set(null);
        return Unit.INSTANCE;
    }

    private static final void open$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit open$lambda$7$lambda$6(AsyncPromise $result) {
        $result.setError("Closed explicitly");
        return Unit.INSTANCE;
    }

    private static final void open$lambda$7(RemoteVmConnection this$0, AsyncPromise $result, InetSocketAddress $address, Condition $stopCondition) {
        if (Thread.interrupted()) {
            return;
        }
        this$0.connectCancelHandler.set((Function0<Unit>)((Function0)() -> RemoteVmConnection.open$lambda$7$lambda$6($result)));
        this$0.doOpen($result, $address, (Condition<Void>)$stopCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit open$lambda$8(java.util.concurrent.Future $future, AsyncPromise $result) {
        try {
            $future.cancel(true);
        }
        finally {
            $result.setError("Cancelled");
        }
        return Unit.INSTANCE;
    }

    private static final boolean doOpen$lambda$9(AsyncPromise $result, Void it) {
        return $result.getState() == Promise.State.REJECTED;
    }

    private static final void doOpen$lambda$10(AsyncPromise $result, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $result.setError(it);
    }

    private static final void doOpen$lambda$11(AsyncPromise $result, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $result.setError(it);
    }

    private static final void doOpen$lambda$12(AsyncPromise $result, RemoteVmConnection this$0, Future it) {
        if ($result.isSucceeded()) {
            this$0.close("Process disconnected unexpectedly", ConnectionStatus.DISCONNECTED);
        }
    }

    private static final Unit doOpen$lambda$13(Channel $channel, ConnectionState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getStatus() == ConnectionStatus.DISCONNECTED) {
            $channel.close();
        }
        return Unit.INSTANCE;
    }
}

