/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import zmq.ZMQ;
import zmq.util.Clock;
import zmq.util.MultiMap;
import zmq.util.Utils;
import zmq.util.function.Supplier;

public final class Timers {
    private final MultiMap<Long, Timer> timers = new MultiMap();
    private final Supplier<Long> clock;

    public Timers() {
        this(() -> TimeUnit.NANOSECONDS.toMillis(Clock.nowNS()));
    }

    public Timers(Supplier<Long> clock) {
        this.clock = clock;
    }

    private long now() {
        return this.clock.get();
    }

    private boolean insert(Timer timer2) {
        return this.timers.insert(this.now() + timer2.interval, timer2);
    }

    public Timer add(long interval, Handler handler, Object ... args) {
        if (handler == null) {
            return null;
        }
        Utils.checkArgument(interval > 0L, "Delay of a timer has to be strictly greater than 0");
        Timer timer2 = new Timer(this, interval, handler, args);
        boolean rc = this.insert(timer2);
        assert (rc);
        return timer2;
    }

    @Deprecated
    public boolean setInterval(Timer timer2, long interval) {
        assert (timer2.parent == this);
        return timer2.setInterval(interval);
    }

    @Deprecated
    public boolean reset(Timer timer2) {
        assert (timer2.parent == this);
        return timer2.reset();
    }

    @Deprecated
    public boolean cancel(Timer timer2) {
        assert (timer2.parent == this);
        return timer2.cancel();
    }

    public long timeout() {
        long now = this.now();
        for (Map.Entry<Timer, Long> entry : this.entries()) {
            Timer timer2 = entry.getKey();
            Long expiration = entry.getValue();
            if (timer2.alive) {
                if (expiration - now > 0L) {
                    return expiration - now;
                }
                return 0L;
            }
            this.timers.remove(expiration, timer2);
        }
        return -1L;
    }

    public int execute() {
        int executed = 0;
        long now = this.now();
        for (Map.Entry<Timer, Long> entry : this.entries()) {
            Timer timer2 = entry.getKey();
            Long expiration = entry.getValue();
            if (!timer2.alive) {
                this.timers.remove(expiration, timer2);
                continue;
            }
            if (expiration - now > 0L) break;
            this.insert(timer2);
            timer2.handler.time(timer2.args);
            ++executed;
        }
        return executed;
    }

    Iterable<Map.Entry<Timer, Long>> entries() {
        return this.timers.entries();
    }

    public int sleepAndExecute() {
        long timeout = this.timeout();
        while (timeout > 0L) {
            ZMQ.msleep(timeout);
            timeout = this.timeout();
        }
        return this.execute();
    }

    public static final class Timer {
        private final Timers parent;
        private long interval;
        private boolean alive = true;
        private final Handler handler;
        private final Object[] args;

        private Timer(Timers parent, long interval, Handler handler, Object ... args) {
            assert (args != null);
            this.parent = parent;
            this.interval = interval;
            this.handler = handler;
            this.args = args;
        }

        public boolean setInterval(long interval) {
            if (this.alive) {
                this.interval = interval;
                return this.parent.insert(this);
            }
            return false;
        }

        public boolean reset() {
            if (this.alive) {
                return this.parent.insert(this);
            }
            return false;
        }

        public boolean cancel() {
            if (this.alive) {
                this.alive = false;
                return true;
            }
            return false;
        }
    }

    public static interface Handler {
        public void time(Object ... var1);
    }
}

