/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.usagesSearch.operators;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.analysis.KotlinBaseAnalysisBundle;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.search.ReceiverTypeSearcherInfo;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinRequestResultProcessor;
import org.jetbrains.kotlin.idea.search.usagesSearch.ExpressionsOfTypeProcessor;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.BinaryOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.ContainsOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.DestructuringDeclarationReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.IndexingOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.InvokeOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.IteratorOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.PropertyDelegationOperatorReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.UnaryOperatorReferenceSearcher;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u0000 (*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001(BE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH$J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u0002H$J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nH$J\u0015\u0010\"\u001a\u00020 2\u0006\u0010\u001e\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u001aJ\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0007H\u0002J\f\u0010'\u001a\u00020\u0011*\u00020\u0007H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher;", "TReferenceElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "", "targetDeclaration", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "optimizer", "Lcom/intellij/psi/search/SearchRequestCollector;", "options", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "wordsToSearch", "", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/search/SearchScope;Lcom/intellij/util/Processor;Lcom/intellij/psi/search/SearchRequestCollector;Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;Ljava/util/List;)V", "getTargetDeclaration", "()Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "processPossibleReceiverExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "extractReference", "element", "isReferenceToCheck", "", "ref", "processReferenceElement", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "run", "doPlainSearch", "scope", "logPresentation", "Companion", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nOperatorReferenceSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher\n+ 2 ExpressionsOfTypeProcessor.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/ExpressionsOfTypeProcessor$Companion\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 7 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,345:1\n80#2,2:346\n80#2,2:365\n80#2,2:367\n80#2,2:369\n11546#3,9:348\n13472#3:357\n13473#3:359\n11555#3:360\n11228#3:373\n11563#3,3:374\n1#4:358\n1#4:395\n1563#5:361\n1634#5,3:362\n1869#5,2:371\n428#6,14:377\n347#6,2:391\n359#6:393\n446#6:394\n125#7:396\n125#7:397\n*S KotlinDebug\n*F\n+ 1 OperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher\n*L\n63#1:346,2\n209#1:365,2\n218#1:367,2\n238#1:369,2\n68#1:348,9\n68#1:357\n68#1:359\n68#1:360\n321#1:373\n321#1:374,3\n68#1:358\n71#1:361\n71#1:362,3\n277#1:371,2\n249#1:377,14\n249#1:391,2\n249#1:393\n249#1:394\n256#1:396\n302#1:397\n*E\n"})
public abstract class OperatorReferenceSearcher<TReferenceElement extends KtElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement targetDeclaration;
    @NotNull
    private final SearchScope searchScope;
    @NotNull
    private final Processor<? super PsiReference> consumer;
    @NotNull
    private final SearchRequestCollector optimizer;
    @NotNull
    private final KotlinReferencesSearchOptions options;
    @NotNull
    private final List<String> wordsToSearch;
    @NotNull
    private final Project project;

    public OperatorReferenceSearcher(@NotNull PsiElement targetDeclaration, @NotNull SearchScope searchScope, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchRequestCollector optimizer, @NotNull KotlinReferencesSearchOptions options2, @NotNull List<String> wordsToSearch) {
        Intrinsics.checkNotNullParameter((Object)targetDeclaration, (String)"targetDeclaration");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter(wordsToSearch, (String)"wordsToSearch");
        this.targetDeclaration = targetDeclaration;
        this.searchScope = searchScope;
        this.consumer = consumer;
        this.optimizer = optimizer;
        this.options = options2;
        this.wordsToSearch = wordsToSearch;
        Project project = this.targetDeclaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
    }

    @NotNull
    protected final PsiElement getTargetDeclaration() {
        return this.targetDeclaration;
    }

    protected abstract void processPossibleReceiverExpression(@NotNull KtExpression var1);

    @Nullable
    protected abstract PsiReference extractReference(@NotNull KtElement var1);

    protected abstract boolean isReferenceToCheck(@NotNull PsiReference var1);

    /*
     * WARNING - void declaration
     */
    protected final boolean processReferenceElement(@NotNull TReferenceElement element) {
        void $this$mapTo$iv$iv;
        KtDeclaration $this$forEach$iv$iv$iv;
        Collection destination$iv$iv;
        Object $this$mapNotNull$iv;
        Collection collection;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        PsiReference psiReference = this.extractReference((KtElement)element);
        if (psiReference == null) {
            return true;
        }
        PsiReference reference = psiReference;
        ExpressionsOfTypeProcessor.Companion this_$iv = ExpressionsOfTypeProcessor.Companion;
        boolean $i$f$testLog = false;
        Collection collection2 = this_$iv.getTestLog();
        if (collection2 != null) {
            collection = collection2;
            boolean bl = false;
            collection.add((String)("Resolved " + ExpressionsOfTypeProcessor.Companion.logPresentation((PsiElement)element)));
        }
        if (reference.isReferenceTo(this.targetDeclaration)) {
            return this.consumer.process((Object)reference);
        }
        ResolveResult[] resolveResultArray = reference instanceof PsiPolyVariantReference ? (ResolveResult[])reference : null;
        if (resolveResultArray != null && (resolveResultArray = resolveResultArray.multiResolve(false)) != null) {
            void $this$mapNotNullTo$iv$iv;
            $this$mapNotNull$iv = resolveResultArray;
            boolean $i$f$mapNotNull = false;
            ResolveResult[] resolveResultArray2 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                KtDeclaration it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                PsiElement psiElement = it.getElement();
                if ((psiElement instanceof KtDeclaration ? (KtDeclaration)psiElement : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return true;
        }
        List currentTargets = (List)destination$iv$iv;
        if (!(this.targetDeclaration instanceof KtDeclaration)) {
            return true;
        }
        KtDeclaration ktDeclaration = ExpectActualUtils.INSTANCE.expectDeclarationIfAny((KtDeclaration)this.targetDeclaration);
        if (ktDeclaration == null) {
            ktDeclaration = (KtDeclaration)this.targetDeclaration;
        }
        KtDeclaration expectedTarget = ktDeclaration;
        Iterable $this$map$iv = currentTargets;
        boolean $i$f$map = false;
        $this$mapNotNull$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            $this$forEach$iv$iv$iv = (KtDeclaration)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            KtDeclaration ktDeclaration2 = ExpectActualUtils.INSTANCE.expectDeclarationIfAny((KtDeclaration)it);
            if (ktDeclaration2 == null) {
                ktDeclaration2 = it;
            }
            collection.add(ktDeclaration2);
        }
        return ((List)destination$iv$iv2).contains(expectedTarget) ? this.consumer.process((Object)reference) : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        PsiElement psiElement;
        ReceiverTypeSearcherInfo receiverTypeSearcherInfo = (ReceiverTypeSearcherInfo)ActionsKt.runReadAction(() -> OperatorReferenceSearcher.run$lambda$3(this));
        if (receiverTypeSearcherInfo == null) {
            return;
        }
        ReceiverTypeSearcherInfo receiverTypeSearcherInfo2 = receiverTypeSearcherInfo;
        PsiElement klass = receiverTypeSearcherInfo2.component1();
        Function1<KtDeclaration, Boolean> containsTypeOrDerivedInside = receiverTypeSearcherInfo2.component2();
        HashSet inProgress = (HashSet)Companion.SearchesInProgress.INSTANCE.get();
        if (klass != null) {
            if (!inProgress.add(klass)) {
                ExpressionsOfTypeProcessor.Companion this_$iv = ExpressionsOfTypeProcessor.Companion;
                boolean $i$f$testLog = false;
                Collection<String> collection = this_$iv.getTestLog();
                if (collection == null) return;
                Collection<String> collection2 = collection;
                boolean bl = false;
                collection2.add("ExpressionOfTypeProcessor is already started for " + ActionsKt.runReadAction(() -> OperatorReferenceSearcher.run$lambda$5$lambda$4(klass)) + ". Exit for operator " + ExpressionsOfTypeProcessor.Companion.logPresentation(this.targetDeclaration) + ".");
                return;
            }
        } else if (!inProgress.add(this.targetDeclaration)) {
            ExpressionsOfTypeProcessor.Companion this_$iv = ExpressionsOfTypeProcessor.Companion;
            boolean $i$f$testLog = false;
            Collection<String> collection = this_$iv.getTestLog();
            if (collection == null) return;
            Collection<String> collection3 = collection;
            boolean bl = false;
            collection3.add("ExpressionOfTypeProcessor is already started for operator " + ExpressionsOfTypeProcessor.Companion.logPresentation(this.targetDeclaration) + ". Exit.");
            return;
        }
        try {
            new ExpressionsOfTypeProcessor(containsTypeOrDerivedInside, klass, this.searchScope, this.project, (Function1<? super KtExpression, Unit>)((Function1)arg_0 -> OperatorReferenceSearcher.run$lambda$7(this, arg_0)), (Function1<? super SearchScope, Unit>)((Function1)arg_0 -> OperatorReferenceSearcher.run$lambda$8(this, arg_0))).run();
            psiElement = klass;
        }
        catch (Throwable throwable) {
            PsiElement psiElement2 = klass;
            if (psiElement2 == null) {
                psiElement2 = this.targetDeclaration;
            }
            inProgress.remove(psiElement2);
            throw throwable;
        }
        PsiElement psiElement3 = psiElement;
        if (psiElement == null) {
            psiElement3 = this.targetDeclaration;
        }
        inProgress.remove(psiElement3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPlainSearch(SearchScope scope) {
        ExpressionsOfTypeProcessor.Companion this_$iv = ExpressionsOfTypeProcessor.Companion;
        boolean $i$f$testLog = false;
        Collection<String> collection = this_$iv.getTestLog();
        if (collection != null) {
            Collection<String> collection2 = collection;
            int n = 0;
            collection2.add("Used plain search of " + ExpressionsOfTypeProcessor.Companion.logPresentation(this.targetDeclaration) + " in " + this.logPresentation(scope));
        }
        ProgressIndicator progress = ProgressWrapper.unwrap((ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator());
        if (scope instanceof LocalSearchScope) {
            for (PsiElement element : ((LocalSearchScope)scope).getScope()) {
                if (!(element instanceof KtElement)) continue;
                ActionsKt.runReadAction(() -> OperatorReferenceSearcher.doPlainSearch$lambda$12(element, progress, this));
            }
        } else {
            Intrinsics.checkNotNull((Object)scope, (String)"null cannot be cast to non-null type com.intellij.psi.search.GlobalSearchScope");
            GlobalSearchScope cfr_ignored_0 = (GlobalSearchScope)scope;
            if (!((Collection)this.wordsToSearch).isEmpty()) {
                PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)this.targetDeclaration);
                if (psiNamedElement == null) {
                    return;
                }
                PsiNamedElement unwrappedElement = psiNamedElement;
                KotlinRequestResultProcessor resultProcessor = new KotlinRequestResultProcessor((PsiElement)unwrappedElement, null, arg_0 -> OperatorReferenceSearcher.doPlainSearch$lambda$13(this, arg_0), this.options, 2, null);
                Iterable $this$forEach$iv = this.wordsToSearch;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    this.optimizer.searchWord(it, (SearchScope)KotlinScopeUtils.restrictToKotlinSources((GlobalSearchScope)scope), (short)1, true, (PsiElement)unwrappedElement, (RequestResultProcessor)resultProcessor);
                }
            } else {
                PsiManager psiManager = PsiManager.getInstance((Project)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
                PsiManager psiManager2 = psiManager;
                ProgressIndicator progressIndicator = progress;
                if (progressIndicator != null) {
                    progressIndicator.pushState();
                }
                ProgressIndicator progressIndicator2 = progress;
                if (progressIndicator2 != null) {
                    progressIndicator2.setText(KotlinBaseAnalysisBundle.message("searching.for.implicit.usages", new Object[0]));
                }
                ProgressIndicator progressIndicator3 = progress;
                if (progressIndicator3 != null) {
                    progressIndicator3.setIndeterminate(false);
                }
                try {
                    Object object = ActionsKt.runReadAction(() -> OperatorReferenceSearcher.doPlainSearch$lambda$15(scope));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                    Collection files = (Collection)object;
                    Iterator iterator2 = ((Iterable)files).iterator();
                    int n = 0;
                    while (iterator2.hasNext()) {
                        int index2 = n++;
                        VirtualFile file = (VirtualFile)iterator2.next();
                        ProgressIndicator progressIndicator4 = progress;
                        if (progressIndicator4 != null) {
                            progressIndicator4.checkCanceled();
                        }
                        ActionsKt.runReadAction(() -> OperatorReferenceSearcher.doPlainSearch$lambda$17(file, progress, index2, files, psiManager2, this));
                    }
                }
                finally {
                    ProgressIndicator progressIndicator5 = progress;
                    if (progressIndicator5 != null) {
                        progressIndicator5.popState();
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String logPresentation(SearchScope $this$logPresentation) {
        String string;
        SearchScope searchScope = $this$logPresentation;
        if (Intrinsics.areEqual((Object)searchScope, (Object)this.searchScope)) {
            string = "whole search scope";
        } else if (searchScope instanceof LocalSearchScope) {
            void $this$mapTo$iv$iv;
            PsiElement[] psiElementArray = ((LocalSearchScope)$this$logPresentation).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getScope(...)");
            Object[] $this$map$iv = psiElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void element;
                PsiElement psiElement = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add("    " + ActionsKt.runReadAction(() -> OperatorReferenceSearcher.logPresentation$lambda$20$lambda$19((PsiElement)element)));
            }
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)((List)destination$iv$iv))), (CharSequence)"\n", (CharSequence)"LocalSearchScope:\n", null, (int)0, null, null, (int)60, null);
        } else {
            String string2 = $this$logPresentation.getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        }
        return string;
    }

    private static final ReceiverTypeSearcherInfo run$lambda$3(OperatorReferenceSearcher this$0) {
        return KotlinSearchUsagesSupport.SearchUtils.INSTANCE.getReceiverTypeSearcherInfo(this$0.targetDeclaration, this$0 instanceof DestructuringDeclarationReferenceSearcher);
    }

    private static final String run$lambda$5$lambda$4(PsiElement $klass) {
        Object object = $klass instanceof PsiClass ? (PsiClass)$klass : null;
        if (object == null || (object = object.getQualifiedName()) == null) {
            PsiNamedElement psiNamedElement = $klass instanceof PsiNamedElement ? (PsiNamedElement)$klass : null;
            object = psiNamedElement != null ? psiNamedElement.getName() : null;
            if (object == null) {
                object = $klass.getText();
            }
        }
        return object;
    }

    private static final Unit run$lambda$7(OperatorReferenceSearcher this$0, KtExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this$0.processPossibleReceiverExpression(expression);
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$8(OperatorReferenceSearcher this$0, SearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        this$0.doPlainSearch(searchScope);
        return Unit.INSTANCE;
    }

    private static final boolean doPlainSearch$lambda$12$lambda$10(OperatorReferenceSearcher this$0, ArrayList $refs, KtElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiReference psiReference = this$0.extractReference(it);
        if (psiReference == null) {
            return false;
        }
        PsiReference ref = psiReference;
        $refs.add(ref);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit doPlainSearch$lambda$12(PsiElement $element, ProgressIndicator $progress, OperatorReferenceSearcher this$0) {
        if (((KtElement)$element).isValid()) {
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void to$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            void $this$collectDescendantsOfType$iv$iv;
            void $this$collectDescendantsOfType$iv;
            ProgressIndicator progressIndicator = $progress;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            ArrayList refs = new ArrayList();
            Object object = $element;
            Function1 predicate$iv = arg_0 -> OperatorReferenceSearcher.doPlainSearch$lambda$12$lambda$10(this$0, refs, arg_0);
            boolean $i$f$collectDescendantsOfType = false;
            void var8_8 = $this$collectDescendantsOfType$iv;
            Function1 predicate$iv$iv = predicate$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            void var11_11 = $this$collectDescendantsOfType$iv$iv;
            Collection collection = new ArrayList();
            Function1 predicate$iv$iv$iv = predicate$iv$iv;
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var15_15 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtElement, Unit>(predicate$iv$iv$iv, (Collection)to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtElement) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
            object = (List)to$iv$iv$iv;
            if (object.isEmpty()) {
                boolean bl = false;
                return Unit.INSTANCE;
            }
            List elements = (List)object;
            PsiFile $this$safeAs$iv = ((KtElement)$element).getContainingFile();
            boolean $i$f$safeAs = false;
            PsiFile psiFile = $this$safeAs$iv;
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile2 = (KtFile)psiFile;
            if (ktFile2 != null) {
                KotlinSearchUsagesSupport.SearchUtils.INSTANCE.forceResolveReferences(ktFile2, elements);
            }
            Iterator iterator2 = refs.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            object = iterator2;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                PsiReference ref = (PsiReference)e;
                ProgressIndicator progressIndicator2 = $progress;
                if (progressIndicator2 != null) {
                    progressIndicator2.checkCanceled();
                }
                if (!ref.isReferenceTo(this$0.targetDeclaration)) continue;
                this$0.consumer.process((Object)ref);
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean doPlainSearch$lambda$13(OperatorReferenceSearcher this$0, PsiReference ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return this$0.isReferenceToCheck(ref);
    }

    private static final Collection doPlainSearch$lambda$15(SearchScope $scope) {
        return FileTypeIndex.getFiles((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)((GlobalSearchScope)$scope));
    }

    private static final Unit doPlainSearch$lambda$17(VirtualFile $file, ProgressIndicator $progress, int $index, Collection $files, PsiManager $psiManager, OperatorReferenceSearcher this$0) {
        block4: {
            if (!$file.isValid()) break block4;
            ProgressIndicator progressIndicator = $progress;
            if (progressIndicator != null) {
                progressIndicator.setFraction((double)$index / (double)$files.size());
            }
            ProgressIndicator progressIndicator2 = $progress;
            if (progressIndicator2 != null) {
                progressIndicator2.setText2($file.getPath());
            }
            PsiFile $this$safeAs$iv = $psiManager.findFile($file);
            boolean $i$f$safeAs = false;
            PsiFile psiFile = $this$safeAs$iv;
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile2 = (KtFile)psiFile;
            if (ktFile2 != null) {
                KtFile it = ktFile2;
                boolean bl = false;
                this$0.doPlainSearch((SearchScope)new LocalSearchScope((PsiElement)it));
            }
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence logPresentation$lambda$20$lambda$19$lambda$18(KtWhenCondition it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final String logPresentation$lambda$20$lambda$19(PsiElement $element) {
        Object object;
        PsiElement psiElement = $element;
        if (psiElement instanceof KtFunctionLiteral) {
            object = ((KtFunctionLiteral)$element).getText();
        } else if (psiElement instanceof KtWhenEntry) {
            if (((KtWhenEntry)$element).isElse()) {
                object = "KtWhenEntry \"else\"";
            } else {
                KtWhenCondition[] ktWhenConditionArray = ((KtWhenEntry)$element).getConditions();
                Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
                object = "KtWhenEntry \"" + ArraysKt.joinToString$default((Object[])ktWhenConditionArray, (CharSequence)", ", null, null, (int)0, null, OperatorReferenceSearcher::logPresentation$lambda$20$lambda$19$lambda$18, (int)30, null) + "\"";
            }
        } else {
            object = psiElement instanceof KtNamedDeclaration ? ((KtNamedDeclaration)$element).getNode().getElementType() + ":" + ((KtNamedDeclaration)$element).getName() : $element.toString();
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J>\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JF\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher;", "declaration", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "optimizer", "Lcom/intellij/psi/search/SearchRequestCollector;", "options", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "createInReadAction", "name", "Lorg/jetbrains/kotlin/name/Name;", "SearchesInProgress", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nOperatorReferenceSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,345:1\n282#2:346\n*S KotlinDebug\n*F\n+ 1 OperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher$Companion\n*L\n86#1:346\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final OperatorReferenceSearcher<?> create(@NotNull PsiElement declaration, @NotNull SearchScope searchScope, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchRequestCollector optimizer, @NotNull KotlinReferencesSearchOptions options2) {
            OperatorReferenceSearcher<?> operatorReferenceSearcher;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            boolean $this$ifTrue$iv = declaration.isValid();
            boolean $i$f$ifTrue = false;
            if ($this$ifTrue$iv) {
                boolean bl = false;
                operatorReferenceSearcher = Companion.createInReadAction(declaration, searchScope, consumer, optimizer, options2);
            } else {
                operatorReferenceSearcher = null;
            }
            return operatorReferenceSearcher;
        }

        private final OperatorReferenceSearcher<?> createInReadAction(PsiElement declaration, SearchScope searchScope, Processor<? super PsiReference> consumer, SearchRequestCollector optimizer, KotlinReferencesSearchOptions options2) {
            PsiElement psiElement;
            PsiElement psiElement2 = declaration;
            String string = psiElement2 instanceof KtNamedFunction ? ((KtNamedFunction)declaration).getName() : (psiElement2 instanceof PsiMethod ? ((PsiMethod)declaration).getName() : null);
            if (string == null) {
                return null;
            }
            String functionName = string;
            if (!Name.isValidIdentifier((String)functionName)) {
                return null;
            }
            Name name2 = Name.identifier((String)functionName);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            Name name3 = name2;
            if (declaration instanceof KtLightMethod) {
                KtDeclaration ktDeclaration = (KtDeclaration)((KtLightMethod)declaration).getKotlinOrigin();
                if (ktDeclaration == null) {
                    return null;
                }
                psiElement = (PsiElement)ktDeclaration;
            } else {
                psiElement = declaration;
            }
            PsiElement declarationToUse = psiElement;
            return this.createInReadAction(declarationToUse, name3, consumer, optimizer, options2, searchScope);
        }

        private final OperatorReferenceSearcher<?> createInReadAction(PsiElement declaration, Name name2, Processor<? super PsiReference> consumer, SearchRequestCollector optimizer, KotlinReferencesSearchOptions options2, SearchScope searchScope) {
            OperatorReferenceSearcher operatorReferenceSearcher;
            if (DataClassResolver.INSTANCE.isComponentLike(name2)) {
                if (!options2.getSearchForComponentConventions()) {
                    return null;
                }
                String string = name2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                int componentIndex = DataClassResolver.INSTANCE.getComponentIndex(string);
                return new DestructuringDeclarationReferenceSearcher(declaration, componentIndex, searchScope, consumer, optimizer, options2);
            }
            if (!options2.getSearchForOperatorConventions()) {
                return null;
            }
            boolean operator = !(declaration instanceof KtElement) || declaration instanceof KtNamedFunction && KotlinPsiHeuristics.isPossibleOperator((KtNamedFunction)declaration);
            KtSingleValueToken binaryOp = (KtSingleValueToken)OperatorConventions.BINARY_OPERATION_NAMES.inverse().get((Object)name2);
            KtSingleValueToken assignmentOp = (KtSingleValueToken)OperatorConventions.ASSIGNMENT_OPERATIONS.inverse().get((Object)name2);
            KtSingleValueToken unaryOp = (KtSingleValueToken)OperatorConventions.UNARY_OPERATION_NAMES.inverse().get((Object)name2);
            if (operator && binaryOp != null) {
                KtSingleValueToken counterpartAssignmentOp = (KtSingleValueToken)OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.inverse().get((Object)binaryOp);
                Object[] objectArray = new KtSingleValueToken[]{binaryOp, counterpartAssignmentOp};
                List operationTokens = CollectionsKt.listOfNotNull((Object[])objectArray);
                operatorReferenceSearcher = new BinaryOperatorReferenceSearcher(declaration, operationTokens, searchScope, consumer, optimizer, options2);
            } else if (operator && assignmentOp != null) {
                operatorReferenceSearcher = new BinaryOperatorReferenceSearcher(declaration, CollectionsKt.listOf((Object)assignmentOp), searchScope, consumer, optimizer, options2);
            } else if (operator && unaryOp != null) {
                operatorReferenceSearcher = new UnaryOperatorReferenceSearcher(declaration, unaryOp, searchScope, consumer, optimizer, options2);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.INVOKE)) {
                operatorReferenceSearcher = new InvokeOperatorReferenceSearcher(declaration, searchScope, consumer, optimizer, options2);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.GET)) {
                operatorReferenceSearcher = new IndexingOperatorReferenceSearcher(declaration, searchScope, consumer, optimizer, options2, false);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.SET)) {
                operatorReferenceSearcher = new IndexingOperatorReferenceSearcher(declaration, searchScope, consumer, optimizer, options2, true);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.CONTAINS)) {
                operatorReferenceSearcher = new ContainsOperatorReferenceSearcher(declaration, searchScope, consumer, optimizer, options2);
            } else if (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.EQUALS)) {
                Object[] objectArray = new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ};
                operatorReferenceSearcher = new BinaryOperatorReferenceSearcher(declaration, CollectionsKt.listOf((Object[])objectArray), searchScope, consumer, optimizer, options2);
            } else if (operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.COMPARE_TO)) {
                Object[] objectArray = new KtSingleValueToken[]{KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ};
                operatorReferenceSearcher = new BinaryOperatorReferenceSearcher(declaration, CollectionsKt.listOf((Object[])objectArray), searchScope, consumer, optimizer, options2);
            } else {
                operatorReferenceSearcher = operator && Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.ITERATOR) ? (OperatorReferenceSearcher)new IteratorOperatorReferenceSearcher(declaration, searchScope, consumer, optimizer, options2) : (operator && (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.GET_VALUE) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.SET_VALUE) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.PROVIDE_DELEGATE)) ? (OperatorReferenceSearcher)new PropertyDelegationOperatorReferenceSearcher(declaration, searchScope, consumer, optimizer, options2) : null);
            }
            return operatorReferenceSearcher;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher$Companion$SearchesInProgress;", "Ljava/lang/ThreadLocal;", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "initialValue", "kotlin.base.analysis"})
        private static final class SearchesInProgress
        extends ThreadLocal<HashSet<PsiElement>> {
            @NotNull
            public static final SearchesInProgress INSTANCE = new SearchesInProgress();

            private SearchesInProgress() {
            }

            @Override
            @NotNull
            protected HashSet<PsiElement> initialValue() {
                return new HashSet<PsiElement>();
            }
        }
    }
}

