/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0005\u0013\u0014\u0015\u0016\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0005\u0018\u0019\u001a\u001b\u001c\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001d\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "", "targetContainerFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getTargetContainerFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "targetFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTargetFileOrDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateTargetPsi", "Lorg/jetbrains/kotlin/psi/KtElement;", "originalPsi", "Lcom/intellij/psi/PsiElement;", "getTargetPsiIfExists", "verify", "", "file", "Lcom/intellij/psi/PsiFile;", "Empty", "ExistingElement", "Companion", "DeferredFile", "Directory", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$Companion;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$DeferredFile;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$Directory;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$Empty;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$ExistingElement;", "kotlin.idea"})
public interface KotlinMoveTarget {
    @Nullable
    public FqName getTargetContainerFqName();

    @Nullable
    public VirtualFile getTargetFileOrDir();

    @NotNull
    public KtElement getOrCreateTargetPsi(@NotNull PsiElement var1);

    @Nullable
    public KtElement getTargetPsiIfExists(@NotNull PsiElement var1);

    @NlsContexts.DialogMessage
    @Nullable
    default public String verify(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$Companion;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getTargetClass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "targetContainerFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getTargetContainerFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "targetFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTargetFileOrDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateTargetPsi", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "originalPsi", "Lcom/intellij/psi/PsiElement;", "getTargetPsiIfExists", "kotlin.idea"})
    public static final class Companion
    implements KotlinMoveTarget {
        @NotNull
        private final KtClass targetClass;
        @Nullable
        private final FqName targetContainerFqName;
        @NotNull
        private final VirtualFile targetFileOrDir;

        public Companion(@NotNull KtClass targetClass) {
            Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
            this.targetClass = targetClass;
            Object object = (KtObjectDeclaration)CollectionsKt.firstOrNull((List)this.targetClass.getCompanionObjects());
            if (object == null || (object = object.getFqName()) == null) {
                FqName fqName2 = this.targetClass.getFqName();
                object = fqName2 != null ? fqName2.child(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT) : null;
            }
            this.targetContainerFqName = object;
            VirtualFile virtualFile = this.targetClass.getContainingKtFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            this.targetFileOrDir = virtualFile;
        }

        @NotNull
        public final KtClass getTargetClass() {
            return this.targetClass;
        }

        @Override
        @Nullable
        public FqName getTargetContainerFqName() {
            return this.targetContainerFqName;
        }

        @Override
        @NotNull
        public VirtualFile getTargetFileOrDir() {
            return this.targetFileOrDir;
        }

        @NotNull
        public KtObjectDeclaration getOrCreateTargetPsi(@NotNull PsiElement originalPsi) {
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            return KotlinPsiModificationUtils.getOrCreateCompanionObject(this.targetClass);
        }

        @Nullable
        public KtObjectDeclaration getTargetPsiIfExists(@NotNull PsiElement originalPsi) {
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            return (KtObjectDeclaration)CollectionsKt.firstOrNull((List)this.targetClass.getCompanionObjects());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0012j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$DeferredFile;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "targetPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "targetDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetFileProvider", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;)V", "targetFileOrDir", "getTargetFileOrDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "targetContainerFqName", "getTargetContainerFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "createdFiles", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getOrCreateTargetPsi", "Lorg/jetbrains/kotlin/psi/KtElement;", "originalPsi", "Lcom/intellij/psi/PsiElement;", "getTargetPsiIfExists", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinMoveTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMoveTarget.kt\norg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$DeferredFile\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,103:1\n382#2,7:104\n*S KotlinDebug\n*F\n+ 1 KotlinMoveTarget.kt\norg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$DeferredFile\n*L\n87#1:104,7\n*E\n"})
    public static final class DeferredFile
    implements KotlinMoveTarget {
        @NotNull
        private final Function1<KtFile, KtFile> targetFileProvider;
        @Nullable
        private final VirtualFile targetFileOrDir;
        @NotNull
        private final FqName targetContainerFqName;
        @NotNull
        private final HashMap<KtFile, KtFile> createdFiles;

        public DeferredFile(@NotNull FqName targetPackageFqName, @Nullable VirtualFile targetDir, @NotNull Function1<? super KtFile, ? extends KtFile> targetFileProvider) {
            Intrinsics.checkNotNullParameter((Object)targetPackageFqName, (String)"targetPackageFqName");
            Intrinsics.checkNotNullParameter(targetFileProvider, (String)"targetFileProvider");
            this.targetFileProvider = targetFileProvider;
            this.targetFileOrDir = targetDir;
            this.targetContainerFqName = targetPackageFqName;
            this.createdFiles = new HashMap();
        }

        public /* synthetic */ DeferredFile(FqName fqName2, VirtualFile virtualFile, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                function1 = DeferredFile::_init_$lambda$0;
            }
            this(fqName2, virtualFile, (Function1<? super KtFile, ? extends KtFile>)function1);
        }

        @Override
        @Nullable
        public VirtualFile getTargetFileOrDir() {
            return this.targetFileOrDir;
        }

        @Override
        @NotNull
        public FqName getTargetContainerFqName() {
            return this.targetContainerFqName;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public KtElement getOrCreateTargetPsi(@NotNull PsiElement originalPsi) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            PsiFile psiFile = originalPsi.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(("PSI element in not contained in any file: " + originalPsi).toString());
            }
            PsiFile file = psiFile;
            KtFile originalFile = (KtFile)file;
            Map map2 = this.createdFiles;
            KtFile key$iv = originalFile;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                KtFile answer$iv = (KtFile)this.targetFileProvider.invoke((Object)originalFile);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (KtElement)object;
        }

        @Override
        @Nullable
        public KtElement getTargetPsiIfExists(@NotNull PsiElement originalPsi) {
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            return null;
        }

        private static final KtFile _init_$lambda$0(KtFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$Directory;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "targetPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "targetFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getTargetFileOrDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "targetContainerFqName", "getTargetContainerFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getOrCreateTargetPsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "originalPsi", "Lcom/intellij/psi/PsiElement;", "getTargetPsiIfExists", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.idea"})
    public static final class Directory
    implements KotlinMoveTarget {
        @NotNull
        private final VirtualFile targetFileOrDir;
        @NotNull
        private final FqName targetContainerFqName;

        public Directory(@NotNull FqName targetPackageFqName, @NotNull VirtualFile targetFileOrDir) {
            Intrinsics.checkNotNullParameter((Object)targetPackageFqName, (String)"targetPackageFqName");
            Intrinsics.checkNotNullParameter((Object)targetFileOrDir, (String)"targetFileOrDir");
            this.targetFileOrDir = targetFileOrDir;
            this.targetContainerFqName = targetPackageFqName;
        }

        @Override
        @NotNull
        public VirtualFile getTargetFileOrDir() {
            return this.targetFileOrDir;
        }

        @Override
        @NotNull
        public FqName getTargetContainerFqName() {
            return this.targetContainerFqName;
        }

        @NotNull
        public KtFile getOrCreateTargetPsi(@NotNull PsiElement originalPsi) {
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            PsiFile psiFile = originalPsi.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(("PSI element in not contained in any file: " + originalPsi).toString());
            }
            PsiFile file = psiFile;
            return (KtFile)file;
        }

        @Override
        @Nullable
        public KtElement getTargetPsiIfExists(@NotNull PsiElement originalPsi) {
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$Empty;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "<init>", "()V", "targetContainerFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getTargetContainerFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "targetFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTargetFileOrDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateTargetPsi", "Lorg/jetbrains/kotlin/psi/KtElement;", "originalPsi", "Lcom/intellij/psi/PsiElement;", "getTargetPsiIfExists", "kotlin.idea"})
    public static final class Empty
    implements KotlinMoveTarget {
        @NotNull
        public static final Empty INSTANCE = new Empty();
        @Nullable
        private static final FqName targetContainerFqName;
        @Nullable
        private static final VirtualFile targetFileOrDir;

        private Empty() {
        }

        @Override
        @Nullable
        public FqName getTargetContainerFqName() {
            return targetContainerFqName;
        }

        @Override
        @Nullable
        public VirtualFile getTargetFileOrDir() {
            return targetFileOrDir;
        }

        @Override
        @NotNull
        public KtElement getOrCreateTargetPsi(@NotNull PsiElement originalPsi) {
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public KtElement getTargetPsiIfExists(@NotNull PsiElement originalPsi) {
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget$ExistingElement;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "targetElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getTargetElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "targetContainerFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getTargetContainerFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "targetFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTargetFileOrDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateTargetPsi", "originalPsi", "Lcom/intellij/psi/PsiElement;", "getTargetPsiIfExists", "kotlin.idea"})
    public static final class ExistingElement
    implements KotlinMoveTarget {
        @NotNull
        private final KtElement targetElement;
        @NotNull
        private final FqName targetContainerFqName;
        @NotNull
        private final VirtualFile targetFileOrDir;

        public ExistingElement(@NotNull KtElement targetElement) {
            Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
            this.targetElement = targetElement;
            this.targetContainerFqName = this.targetElement.getContainingKtFile().getPackageFqName();
            VirtualFile virtualFile = this.targetElement.getContainingKtFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            this.targetFileOrDir = virtualFile;
        }

        @NotNull
        public final KtElement getTargetElement() {
            return this.targetElement;
        }

        @Override
        @NotNull
        public FqName getTargetContainerFqName() {
            return this.targetContainerFqName;
        }

        @Override
        @NotNull
        public VirtualFile getTargetFileOrDir() {
            return this.targetFileOrDir;
        }

        @Override
        @NotNull
        public KtElement getOrCreateTargetPsi(@NotNull PsiElement originalPsi) {
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            return this.targetElement;
        }

        @Override
        @NotNull
        public KtElement getTargetPsiIfExists(@NotNull PsiElement originalPsi) {
            Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
            return this.targetElement;
        }
    }
}

