/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.k1.scratch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.K1KotlinScratchFile;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.ScratchFileAutoRunnerK1Kt;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.actions.RunScratchFromHereAction;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFileAutoRunner;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/ScratchFileAutoRunnerK1;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFileAutoRunner;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myAlarm", "Lcom/intellij/util/Alarm;", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "runScratch", "scratchFile", "Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/K1KotlinScratchFile;", "dispose", "kotlin.jvm.k1"})
@SourceDebugExtension(value={"SMAP\nScratchFileAutoRunnerK1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFileAutoRunnerK1.kt\norg/jetbrains/kotlin/idea/jvm/k1/scratch/ScratchFileAutoRunnerK1\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class ScratchFileAutoRunnerK1
implements ScratchFileAutoRunner,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Alarm myAlarm;

    public ScratchFileAutoRunnerK1(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        if (this.project.isDisposed()) {
            return;
        }
        ScratchFile scratchFile2 = ScratchFileAutoRunnerK1Kt.getScratchFile(file, this.project);
        K1KotlinScratchFile k1KotlinScratchFile = scratchFile2 instanceof K1KotlinScratchFile ? (K1KotlinScratchFile)scratchFile2 : null;
        if (k1KotlinScratchFile == null) {
            return;
        }
        K1KotlinScratchFile scratchFile3 = k1KotlinScratchFile;
        if (!scratchFile3.getOptions().isInteractiveMode()) {
            return;
        }
        CharSequence charSequence = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            this.runScratch(scratchFile3);
        }
    }

    private final void runScratch(K1KotlinScratchFile scratchFile2) {
        this.myAlarm.cancelAllRequests();
        if (ScratchCompilationSupport.INSTANCE.isInProgress(scratchFile2) && !scratchFile2.getOptions().isRepl()) {
            ScratchCompilationSupport.INSTANCE.forceStop();
        }
        this.myAlarm.addRequest(() -> ScratchFileAutoRunnerK1.runScratch$lambda$2(scratchFile2), 2000, true);
    }

    public void dispose() {
    }

    private static final void runScratch$lambda$2(K1KotlinScratchFile $scratchFile) {
        block3: {
            KtFile ktFile2;
            Object object = $scratchFile.getKtFile();
            if (object == null) break block3;
            KtFile it = ktFile2 = object;
            boolean bl = false;
            object = it.isValid() && !$scratchFile.hasErrors() ? ktFile2 : null;
            if (object != null) {
                it = object;
                boolean bl2 = false;
                if ($scratchFile.getOptions().isRepl()) {
                    RunScratchFromHereAction.Handler.INSTANCE.doAction($scratchFile);
                } else {
                    RunScratchAction.Handler.INSTANCE.doAction($scratchFile, true);
                }
            }
        }
    }
}

