/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertPropertyGetterToInitializerIntentionKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyGetterToInitializerIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "<init>", "()V", "hasExpectModifier", "", "element", "isApplicableTo", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class ConvertPropertyGetterToInitializerIntention
extends SelfTargetingIntention<KtPropertyAccessor> {
    public ConvertPropertyGetterToInitializerIntention() {
        super(KtPropertyAccessor.class, KotlinBundle.lazyMessage((String)"convert.property.getter.to.initializer", (Object[])new Object[0]), null, 4, null);
    }

    private final boolean hasExpectModifier(KtPropertyAccessor element) {
        PsiElement psiElement = element.getParent();
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (ktProperty == null) {
            return false;
        }
        KtProperty property = ktProperty;
        psiElement = SearchHelpersKt.getDescriptor((KtDeclaration)property);
        PropertyDescriptor propertyDescriptor = psiElement instanceof PropertyDescriptor ? (PropertyDescriptor)psiElement : null;
        return propertyDescriptor != null ? propertyDescriptor.isExpect() : false;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtPropertyAccessor element, int caretOffset) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!element.isGetter() || ConvertPropertyGetterToInitializerIntentionKt.access$singleExpression(element) == null) {
                    return false;
                }
                PsiElement psiElement = element.getParent();
                KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
                if (ktProperty == null) {
                    return false;
                }
                KtProperty property = ktProperty;
                if (property.hasInitializer() || property.getReceiverTypeReference() != null) break block5;
                KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)property));
                boolean bl = ktClass != null ? ktClass.isInterface() : false;
                if (!bl && !this.hasExpectModifier(element)) break block6;
            }
            return false;
        }
        return true;
    }

    @Override
    public void applyTo(@NotNull KtPropertyAccessor element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (ktProperty == null) {
            return;
        }
        KtProperty property = ktProperty;
        CommentSaver commentSaver = new CommentSaver((PsiElement)property, false, 2, null);
        property.setInitializer(ConvertPropertyGetterToInitializerIntentionKt.access$singleExpression(element));
        KtExpression ktExpression = property.getInitializer();
        property.deleteChildRange((PsiElement)(ktExpression != null ? ktExpression.getNextSibling() : null), (PsiElement)element);
        Editor editor2 = editor;
        if (editor2 != null && (editor2 = editor2.getCaretModel()) != null) {
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)property)));
        }
        CommentSaver.restore$default(commentSaver, (PsiElement)property, false, 2, null);
    }
}

