/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.ConvertScopeFunctionFix;
import org.jetbrains.kotlin.idea.inspections.ConvertScopeFunctionToReceiver;
import org.jetbrains.kotlin.idea.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionToReceiver;", "Lorg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionFix;", "counterpartName", "", "<init>", "(Ljava/lang/String;)V", "analyzeLambda", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "lambdaDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "replacements", "Lorg/jetbrains/kotlin/idea/inspections/ReplacementCollection;", "postprocessLambda", "kotlin.idea"})
public final class ConvertScopeFunctionToReceiver
extends ConvertScopeFunctionFix {
    public ConvertScopeFunctionToReceiver(@NotNull String counterpartName) {
        Intrinsics.checkNotNullParameter((Object)counterpartName, (String)"counterpartName");
        super(counterpartName);
    }

    @Override
    protected void analyzeLambda(@NotNull BindingContext bindingContext, @NotNull KtLambdaArgument lambda2, @NotNull SimpleFunctionDescriptor lambdaDescriptor, @NotNull ReplacementCollection replacements) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)lambdaDescriptor, (String)"lambdaDescriptor");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        lambda2.accept((PsiElementVisitor)new KtTreeVisitorVoid(lambdaDescriptor, replacements, bindingContext){
            final /* synthetic */ SimpleFunctionDescriptor $lambdaDescriptor;
            final /* synthetic */ ReplacementCollection $replacements;
            final /* synthetic */ BindingContext $bindingContext;
            {
                this.$lambdaDescriptor = $lambdaDescriptor;
                this.$replacements = $replacements;
                this.$bindingContext = $bindingContext;
            }

            public void visitSimpleNameExpression(KtSimpleNameExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitSimpleNameExpression(expression);
                if (Intrinsics.areEqual((Object)expression.getReferencedNameAsName(), (Object)StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME)) {
                    DeclarationDescriptor result2 = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)expression));
                    if (result2 instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)((ValueParameterDescriptor)result2).getContainingDeclaration(), (Object)this.$lambdaDescriptor)) {
                        this.$replacements.add((PsiElement)expression, analyzeLambda.1::visitSimpleNameExpression$lambda$0);
                    }
                } else {
                    ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.$bindingContext);
                    if (resolvedCall == null) {
                        return;
                    }
                    ResolvedCall resolvedCall2 = resolvedCall;
                    ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
                    if (dispatchReceiver instanceof ImplicitReceiver) {
                        PsiElement parent2 = expression.getParent();
                        String thisLabelName = KotlinRefactoringUtilKt.getThisLabelName(((ImplicitReceiver)dispatchReceiver).getDeclarationDescriptor());
                        if (parent2 instanceof KtCallExpression && Intrinsics.areEqual((Object)expression, (Object)((KtCallExpression)parent2).getCalleeExpression())) {
                            this.$replacements.add(parent2, (arg_0, arg_1) -> analyzeLambda.1.visitSimpleNameExpression$lambda$1(thisLabelName, arg_0, arg_1));
                        } else {
                            String referencedName = expression.getReferencedName();
                            this.$replacements.add((PsiElement)expression, (arg_0, arg_1) -> analyzeLambda.1.visitSimpleNameExpression$lambda$2(thisLabelName, referencedName, arg_0, arg_1));
                        }
                    }
                }
            }

            public void visitThisExpression(KtThisExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.$bindingContext);
                if (resolvedCall == null) {
                    return;
                }
                ResolvedCall resolvedCall2 = resolvedCall;
                Name name2 = resolvedCall2.getResultingDescriptor().getContainingDeclaration().getName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                Name qualifierName = name2;
                this.$replacements.add((PsiElement)expression, (arg_0, arg_1) -> analyzeLambda.1.visitThisExpression$lambda$3(qualifierName, arg_0, arg_1));
            }

            private static final PsiElement visitSimpleNameExpression$lambda$0(KtPsiFactory $this$add, KtSimpleNameExpression it) {
                Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (PsiElement)$this$add.createThisExpression();
            }

            private static final PsiElement visitSimpleNameExpression$lambda$1(String $thisLabelName, KtPsiFactory $this$add, KtCallExpression element) {
                Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Object[] objectArray = new Object[]{$thisLabelName, element};
                return (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)$this$add, (String)"this@$0.$1", (Object[])objectArray, (boolean)false, (int)4, null);
            }

            private static final PsiElement visitSimpleNameExpression$lambda$2(String $thisLabelName, String $referencedName, KtPsiFactory $this$add, KtSimpleNameExpression it) {
                Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (PsiElement)$this$add.createExpression("this@" + $thisLabelName + "." + $referencedName);
            }

            private static final PsiElement visitThisExpression$lambda$3(Name $qualifierName, KtPsiFactory $this$add, KtThisExpression it) {
                Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = $qualifierName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                return (PsiElement)$this$add.createThisExpression(string);
            }
        });
    }

    @Override
    protected void postprocessLambda(@NotNull KtLambdaArgument lambda2) {
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Function1 filter2 = ConvertScopeFunctionToReceiver::postprocessLambda$lambda$0;
        new ShortenReferences((Function1<? super KtElement, ShortenReferences.Options>)((Function1)ConvertScopeFunctionToReceiver::postprocessLambda$lambda$1)).process((KtElement)lambda2, (Function1<? super PsiElement, ? extends ShortenReferences.FilterResult>)filter2);
    }

    private static final ShortenReferences.FilterResult postprocessLambda$lambda$0(PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtThisExpression && ((KtThisExpression)element).getLabelName() != null ? ShortenReferences.FilterResult.PROCESS : (element instanceof KtQualifiedExpression && ((KtQualifiedExpression)element).getReceiverExpression() instanceof KtThisExpression ? ShortenReferences.FilterResult.PROCESS : ShortenReferences.FilterResult.GO_INSIDE);
    }

    private static final ShortenReferences.Options postprocessLambda$lambda$1(KtElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ShortenReferences.Options(true, true, false, false, false, false, 60, null);
    }
}

