/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.QualifierReceiver;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ClassQualifierReceiver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/QualifierReceiver;", "explicitReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "originalSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getClassSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getOriginalSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "callableScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "classifierScope", "resolve"})
public final class ClassQualifierReceiver
extends QualifierReceiver {
    @NotNull
    private final FirRegularClassSymbol classSymbol;
    @NotNull
    private final FirClassLikeSymbol<?> originalSymbol;
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final ScopeSession scopeSession;

    public ClassQualifierReceiver(@NotNull FirResolvedQualifier explicitReceiver, @NotNull FirRegularClassSymbol classSymbol, @NotNull FirClassLikeSymbol<?> originalSymbol, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)explicitReceiver, (String)"explicitReceiver");
        Intrinsics.checkNotNullParameter((Object)classSymbol, (String)"classSymbol");
        Intrinsics.checkNotNullParameter(originalSymbol, (String)"originalSymbol");
        Intrinsics.checkNotNullParameter((Object)((Object)useSiteSession), (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(explicitReceiver);
        this.classSymbol = classSymbol;
        this.originalSymbol = originalSymbol;
        this.useSiteSession = useSiteSession;
        this.scopeSession = scopeSession;
    }

    @NotNull
    public final FirRegularClassSymbol getClassSymbol() {
        return this.classSymbol;
    }

    @NotNull
    public final FirClassLikeSymbol<?> getOriginalSymbol() {
        return this.originalSymbol;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @Override
    @Nullable
    public FirScope callableScope() {
        FirRegularClass klass = (FirRegularClass)this.classSymbol.getFir();
        FirScopeProvider provider = klass.getScopeProvider();
        return provider.getStaticCallableMemberScope(klass, this.useSiteSession, this.scopeSession);
    }

    @Override
    @Nullable
    public FirScope classifierScope() {
        FirRegularClass klass = (FirRegularClass)this.classSymbol.getFir();
        return klass.getScopeProvider().getNestedClassifierScope(klass, this.useSiteSession, this.scopeSession);
    }
}

