/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNotNullAssertionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCheckNotNullCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCheckNotNullCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirCheckNotNullCall;)V", "checkers"})
public final class FirNotNullAssertionChecker
extends FirExpressionChecker<FirCheckNotNullCall> {
    @NotNull
    public static final FirNotNullAssertionChecker INSTANCE = new FirNotNullAssertionChecker();

    private FirNotNullAssertionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirCheckNotNullCall expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FirExpression firExpression = (FirExpression)CollectionsKt.singleOrNull(expression.getArgumentList().getArguments());
        if (firExpression == null) {
            return;
        }
        FirExpression argument2 = firExpression;
        FirExpression argumentWithoutSmartcast = FirExpressionUtilKt.unwrapSmartcastExpression(argument2);
        if (argumentWithoutSmartcast instanceof FirAnonymousFunctionExpression && ((FirAnonymousFunctionExpression)argumentWithoutSmartcast).getAnonymousFunction().isLambda()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getNOT_NULL_ASSERTION_ON_LAMBDA_EXPRESSION(), null, (int)8, null);
            return;
        }
        if (argumentWithoutSmartcast instanceof FirCallableReferenceAccess) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getNOT_NULL_ASSERTION_ON_CALLABLE_REFERENCE(), null, (int)8, null);
            return;
        }
        ConeKotlinType resolvedType = FirTypeUtilsKt.getResolvedType(argument2);
        if (argumentWithoutSmartcast instanceof FirResolvedQualifier && ConeBuiltinTypeUtilsKt.isUnit(resolvedType)) {
            return;
        }
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context, resolvedType);
        if (!TypeUtilsKt.canBeNull(type2, context.getSession()) && context.getLanguageVersionSettings().supportsFeature(LanguageFeature.EnableDfaWarningsInK2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirErrors.INSTANCE.getUNNECESSARY_NOT_NULL_ASSERTION(), (Object)type2, null, (int)16, null);
        }
    }
}

