/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ReverseRelationshipAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(ReverseRelationshipAction.class);

    public ReverseRelationshipAction(ArchitectFrame frame) {
        super(frame, Messages.getString("ReverseRelationshipAction.name"), Messages.getString("ReverseRelationshipAction.description"), "reverse");
        this.putValue("ActionCommandKey", "PlayPen");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<PlayPenComponent> selection = this.getPlaypen().getSelectedItems();
        if (selection.size() != 1) {
            JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("ReverseRelationshipAction.multipleSelected"));
        } else if (selection.get(0) instanceof Relationship) {
            this.reverseRelationship((Relationship)selection.get(0));
        } else {
            JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("ReverseRelationshipAction.noRelationshipsSelected"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseRelationship(Relationship relationship) {
        SQLTable fkTable = (SQLTable)relationship.getFkTable().getModel();
        SQLTable pkTable = (SQLTable)relationship.getPkTable().getModel();
        boolean identify = relationship.getModel().isIdentifying();
        try {
            this.getPlaypen().startCompoundEdit("Reverse Relationship");
            SQLRelationship sr = relationship.getModel();
            sr.getPkTable().removeExportedKey(sr);
            SQLRelationship model = new SQLRelationship();
            model.setName(pkTable.getName() + "_" + fkTable.getName() + "_fk");
            model.setIdentifying(identify);
            model.attachRelationship(fkTable, pkTable, true);
            model.setDeferrability(sr.getDeferrability());
            model.setFkCardinality(sr.getFkCardinality());
            model.setPkCardinality(sr.getPkCardinality());
            Relationship r = new Relationship(model, this.getPlaypen().getContentPane());
            this.getPlaypen().addRelationship(r);
            r.revalidate();
        }
        catch (SQLObjectException ex) {
            logger.error((Object)"Couldn't reverse relationship", (Throwable)ex);
            ASUtils.showExceptionDialogNoReport(this.getPlaypen(), Messages.getString("ReverseRelationshipAction.couldNotReverseRelationship"), ex);
        }
        finally {
            this.getPlaypen().endCompoundEdit("Reverse Relationship");
        }
    }
}

