/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3.counterstyle;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssRange
extends org.w3c.css.properties.css.counterstyle.CssRange {
    public static final CssIdent infinite = CssIdent.getIdent("infinite");
    public static final CssIdent auto = CssIdent.getIdent("auto");

    public CssRange() {
        this.value = initial;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CssRange(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        char op = ' ';
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        this.setByUser();
        if (expression.getCount() == 1) {
            CssValue val = expression.getValue();
            if (val.getType() != 0 || !auto.equals(val)) throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            this.value = auto;
            return;
        } else {
            if (expression.getCount() % 2 == 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            while (!expression.end()) {
                ArrayList<CssValue> range = new ArrayList<CssValue>();
                for (int i = 0; i < 2; ++i) {
                    CssValue val = expression.getValue();
                    op = expression.getOperator();
                    switch (val.getType()) {
                        case 5: {
                            range.add(val);
                            break;
                        }
                        case 0: {
                            if (!infinite.equals(val)) break;
                            range.add(infinite);
                            break;
                        }
                        default: {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                    }
                    if (i == 0 && op != ' ') {
                        throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
                    }
                    expression.next();
                }
                values.add(new CssValueList(range));
                if (op == 44 || expression.end()) continue;
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            if (values.isEmpty()) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
        }
    }

    public CssRange(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

