/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.security;

import com.google.inject.Injector;
import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.api.security.LoginResult;
import org.traccar.api.security.LoginService;
import org.traccar.api.security.PermissionsService;
import org.traccar.api.security.UserPrincipal;
import org.traccar.api.security.UserSecurityContext;
import org.traccar.database.StatisticsManager;
import org.traccar.model.User;
import org.traccar.storage.StorageException;

public class SecurityRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityRequestFilter.class);
    @Context
    private HttpServletRequest request;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private LoginService loginService;
    @Inject
    private StatisticsManager statisticsManager;
    @Inject
    private Injector injector;

    public void filter(ContainerRequestContext requestContext) {
        UserSecurityContext securityContext;
        block15: {
            if (requestContext.getMethod().equals("OPTIONS")) {
                return;
            }
            securityContext = null;
            try {
                String authHeader = requestContext.getHeaderString("Authorization");
                if (authHeader != null) {
                    try {
                        String[] auth = authHeader.split(" ");
                        LoginResult loginResult = this.loginService.login(auth[0], auth[1]);
                        if (loginResult != null) {
                            User user = loginResult.getUser();
                            this.statisticsManager.registerRequest(user.getId());
                            securityContext = new UserSecurityContext(new UserPrincipal(user.getId(), loginResult.getExpiration()));
                        }
                        break block15;
                    }
                    catch (IOException | GeneralSecurityException | StorageException e) {
                        throw new WebApplicationException((Throwable)e);
                    }
                }
                HttpSession session = this.request.getSession(false);
                if (session != null) {
                    User user;
                    Long userId = (Long)session.getAttribute("userId");
                    Date expiration = (Date)session.getAttribute("expiration");
                    if (expiration != null && expiration.before(new Date())) {
                        session.invalidate();
                    } else if (userId != null && (user = ((PermissionsService)this.injector.getInstance(PermissionsService.class)).getUser(userId)) != null) {
                        user.checkDisabled();
                        this.statisticsManager.registerRequest(userId);
                        securityContext = new UserSecurityContext(new UserPrincipal(userId, expiration));
                    }
                }
            }
            catch (SecurityException | StorageException e) {
                LOGGER.warn("Authentication error", (Throwable)e);
            }
        }
        if (securityContext != null) {
            requestContext.setSecurityContext(securityContext);
        } else {
            Method method = this.resourceInfo.getResourceMethod();
            if (!method.isAnnotationPresent(PermitAll.class)) {
                Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
                String accept = this.request.getHeader("Accept");
                if (accept != null && accept.contains("text/html")) {
                    responseBuilder.header("WWW-Authenticate", (Object)"Basic realm=\"api\"");
                }
                throw new WebApplicationException(responseBuilder.build());
            }
        }
    }
}

