/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.black;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.ui.LightweightHint;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.black.BlackFormatterAdvertiserService;
import com.jetbrains.python.black.BlackFormatterExecutor;
import com.jetbrains.python.black.BlackFormatterUtil;
import com.jetbrains.python.black.BlackFormatterVersionService;
import com.jetbrains.python.black.BlackFormattingRequest;
import com.jetbrains.python.black.BlackFormattingResponse;
import com.jetbrains.python.black.BlackFormattingService;
import com.jetbrains.python.black.BlackFormattingServiceKt;
import com.jetbrains.python.black.configuration.BlackFormatterConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001d\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J'\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u000b\u0010\u001a\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0014J\b\u0010\u001f\u001a\u00020\u0010H\u0014\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/black/BlackFormattingService;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService;", "<init>", "()V", "getFeatures", "", "Lcom/intellij/formatting/service/FormattingService$Feature;", "canFormat", "", "source", "Lcom/intellij/psi/PsiFile;", "createFormattingTask", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "formattingRequest", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "buildNotificationMessage", "", "Lorg/jetbrains/annotations/Nls;", "document", "Lcom/intellij/openapi/editor/Document;", "textBefore", "", "showFormattedLinesInfo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "isError", "isFormatFragmentAction", "documentText", "getNotificationGroupId", "getName", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nBlackFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackFormattingService.kt\ncom/jetbrains/python/black/BlackFormattingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1869#2,2:220\n*S KotlinDebug\n*F\n+ 1 BlackFormattingService.kt\ncom/jetbrains/python/black/BlackFormattingService\n*L\n93#1:220,2\n*E\n"})
public final class BlackFormattingService
extends AsyncDocumentFormattingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String NOTIFICATION_GROUP_ID = "Black Formatter Integration";

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        return BlackFormattingServiceKt.access$getFEATURES$p();
    }

    public boolean canFormat(@NotNull PsiFile source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!Registry.Companion.is("black.formatter.support.enabled")) {
            return false;
        }
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        BlackFormatterConfiguration blackConfiguration = BlackFormatterConfiguration.Companion.getBlackConfiguration(project2);
        VirtualFile virtualFile = source.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vFile = virtualFile;
        boolean isApplicable = BlackFormatterUtil.Companion.isFileApplicable(vFile);
        if (isApplicable) {
            Project project3 = source.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            BlackFormatterAdvertiserService.Companion.getInstance(project3).suggestBlack(source, blackConfiguration);
        }
        if (!blackConfiguration.getEnabledOnReformat()) {
            return false;
        }
        return isApplicable;
    }

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(@NotNull AsyncFormattingRequest formattingRequest) {
        BlackFormattingRequest blackFormattingRequest;
        Intrinsics.checkNotNullParameter((Object)formattingRequest, (String)"formattingRequest");
        FormattingContext formattingContext = formattingRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)formattingContext, (String)"getContext(...)");
        FormattingContext formattingContext2 = formattingContext;
        PsiFile psiFile = formattingContext2.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        VirtualFile virtualFile = formattingContext2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        Project project = formattingContext2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        BlackFormatterConfiguration blackConfig = BlackFormatterConfiguration.Companion.getBlackConfiguration(project2);
        Sdk sdk2 = blackConfig.getSdk();
        Editor editor2 = PsiEditorUtil.findEditor((PsiElement)((PsiElement)file));
        if (sdk2 == null) {
            Object[] objectArray = new Object[]{project2.getName()};
            String string = PyBundle.message("black.sdk.not.configured.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            LOG.warn(message);
            formattingRequest.onError(PyBundle.message("black.sdk.not.configured.error.title", new Object[0]), message);
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
        if (document == null) {
            LOG.warn("Document for file " + file.getName() + " is null");
            return null;
        }
        String string = formattingRequest.getDocumentText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDocumentText(...)");
        String documentText = string;
        boolean isFormatFragmentAction = this.isFormatFragmentAction(documentText, formattingRequest);
        if (isFormatFragmentAction) {
            List lineRanges = new ArrayList();
            List list = formattingRequest.getFormattingRanges();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFormattingRanges(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TextRange range = (TextRange)element$iv;
                boolean bl = false;
                int startLine = document.getLineNumber(range.getStartOffset()) + 1;
                int endLine = document.getLineNumber(range.getEndOffset()) + 1;
                lineRanges.add(new IntRange(startLine, endLine));
            }
            blackFormattingRequest = new BlackFormattingRequest.Fragment(vFile, documentText, lineRanges);
        } else {
            blackFormattingRequest = new BlackFormattingRequest.File(vFile, documentText);
        }
        BlackFormattingRequest blackFormattingRequest2 = blackFormattingRequest;
        return new AsyncDocumentFormattingService.FormattingTask(isFormatFragmentAction, this, editor2, formattingRequest, project2, sdk2, blackConfig, blackFormattingRequest2, document, documentText, vFile){
            final /* synthetic */ boolean $isFormatFragmentAction;
            final /* synthetic */ BlackFormattingService this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ AsyncFormattingRequest $formattingRequest;
            final /* synthetic */ Project $project;
            final /* synthetic */ Sdk $sdk;
            final /* synthetic */ BlackFormatterConfiguration $blackConfig;
            final /* synthetic */ BlackFormattingRequest $blackFormattingRequest;
            final /* synthetic */ Document $document;
            final /* synthetic */ String $documentText;
            final /* synthetic */ VirtualFile $vFile;
            {
                this.$isFormatFragmentAction = $isFormatFragmentAction;
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$formattingRequest = $formattingRequest;
                this.$project = $project;
                this.$sdk = $sdk;
                this.$blackConfig = $blackConfig;
                this.$blackFormattingRequest = $blackFormattingRequest;
                this.$document = $document;
                this.$documentText = $documentText;
                this.$vFile = $vFile;
            }

            public void run() {
                block14: {
                    Object object;
                    Object object2 = this;
                    boolean bl = this.$isFormatFragmentAction;
                    Object object3 = this.this$0;
                    Editor editor2 = this.$editor;
                    AsyncFormattingRequest asyncFormattingRequest = this.$formattingRequest;
                    Project project = this.$project;
                    Sdk sdk2 = this.$sdk;
                    BlackFormatterConfiguration blackFormatterConfiguration = this.$blackConfig;
                    BlackFormattingRequest blackFormattingRequest = this.$blackFormattingRequest;
                    Document document = this.$document;
                    String string = this.$documentText;
                    VirtualFile virtualFile = this.$vFile;
                    try {
                        var $this$run_u24lambda_u240 = object2;
                        boolean bl2 = false;
                        Version blackVersion2 = (Version)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Version>, Object>(project, null){
                            int label;
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = BlackFormatterVersionService.Companion.getVersion(this.$project, (Continuation<? super Version>)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Version> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        if (bl && blackVersion2.compareTo(BlackFormatterUtil.Companion.getMINIMAL_LINE_RANGES_COMPATIBLE_VERSION()) < 0) {
                            BlackFormattingService.access$getLOG$cp().debug("Black version " + blackVersion2 + " is lower than minimal version that supports fragments' formatting, falling back to embedded formatter for fragment formatting");
                            String string2 = PyBundle.message("black.format.fragments.supported.info", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                            BlackFormattingService.access$showFormattedLinesInfo((BlackFormattingService)((Object)object3), editor2, string2, false);
                            $this$run_u24lambda_u240.fallbackToEmbeddedFormatter(asyncFormattingRequest);
                            return;
                        }
                        BlackFormatterExecutor executor = new BlackFormatterExecutor(project, sdk2, blackFormatterConfiguration);
                        java.time.Duration duration = BlackFormattingService.access$getTimeout((BlackFormattingService)((Object)object3));
                        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"access$getTimeout(...)");
                        Object object4 = duration;
                        BlackFormattingResponse response = executor.getBlackFormattingResponse-HG0u8IE(blackFormattingRequest, Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)((java.time.Duration)object4).getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)((java.time.Duration)object4).getNano(), (DurationUnit)DurationUnit.NANOSECONDS)));
                        if (response instanceof BlackFormattingResponse.Success) {
                            String formattedDocumentText = ((BlackFormattingResponse.Success)response).getFormattedText();
                            String message = BlackFormattingService.access$buildNotificationMessage((BlackFormattingService)((Object)object3), document, formattedDocumentText);
                            BlackFormattingService.access$showFormattedLinesInfo((BlackFormattingService)((Object)object3), editor2, message, false);
                            if (Intrinsics.areEqual((Object)formattedDocumentText, (Object)string)) {
                                asyncFormattingRequest.onTextReady(null);
                            } else {
                                asyncFormattingRequest.onTextReady(formattedDocumentText);
                            }
                        } else if (response instanceof BlackFormattingResponse.Failure) {
                            BlackFormattingService.access$getLOG$cp().debug(((BlackFormattingResponse.Failure)response).getLoggingMessage());
                            if (bl) {
                                Object[] objectArray = new Object[]{((BlackFormattingResponse.Failure)response).getInlineNotificationMessage()};
                                object4 = PyBundle.message("black.format.fragment.inline.error", objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"message(...)");
                                BlackFormattingService.access$showFormattedLinesInfo((BlackFormattingService)((Object)object3), editor2, (String)object4, true);
                                asyncFormattingRequest.onTextReady(string);
                            } else {
                                asyncFormattingRequest.onError(((BlackFormattingResponse.Failure)response).getTitle(), ((BlackFormattingResponse.Failure)response).getPopupMessage());
                            }
                        } else if (response instanceof BlackFormattingResponse.Ignored) {
                            Object[] objectArray = new Object[]{virtualFile.getName()};
                            String string3 = PyBundle.message("black.file.ignored.notification.message", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                            BlackFormattingService.access$showFormattedLinesInfo((BlackFormattingService)((Object)object3), editor2, string3, false);
                            asyncFormattingRequest.onTextReady(string);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object2 = object;
                    AsyncFormattingRequest asyncFormattingRequest2 = this.$formattingRequest;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable == null) break block14;
                    Object exception = object3 = throwable;
                    boolean bl3 = false;
                    if (!(exception instanceof ProcessCanceledException)) {
                        BlackFormattingService.access$getLOG$cp().warn((Throwable)exception);
                        asyncFormattingRequest2.onError(PyBundle.message("black.exception.error.message", new Object[0]), ((Throwable)exception).getLocalizedMessage());
                    }
                }
            }

            private final void fallbackToEmbeddedFormatter(AsyncFormattingRequest formattingRequest) {
                FormattingContext formattingContext = formattingRequest.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)formattingContext, (String)"getContext(...)");
                FormattingContext context = formattingContext;
                Project project = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                PsiFile psiFile = context.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                PsiFile psiFile2 = psiFile;
                PsiFile[] psiFileArray = new PsiFile[]{psiFile2};
                WriteCommandAction.runWriteCommandAction((Project)project2, (String)PyBundle.message("black.format.fragment.fallback.title", new Object[0]), (String)"Black Formatter Integration", () -> createFormattingTask.1.fallbackToEmbeddedFormatter$lambda$4(psiFile2, formattingRequest), (PsiFile[])psiFileArray);
                formattingRequest.onTextReady(context.getContainingFile().getText());
            }

            public boolean cancel() {
                return true;
            }

            public boolean isRunUnderProgress() {
                return true;
            }

            private static final void fallbackToEmbeddedFormatter$lambda$4(PsiFile $psiFile, AsyncFormattingRequest $formattingRequest) {
                FormatTextRanges formatTextRanges;
                CoreFormattingService formatter = (CoreFormattingService)AsyncDocumentFormattingService.EP_NAME.findExtensionOrFail(CoreFormattingService.class);
                FormatTextRanges $this$fallbackToEmbeddedFormatter_u24lambda_u244_u24lambda_u243 = formatTextRanges = new FormatTextRanges();
                boolean bl = false;
                List list = $formattingRequest.getFormattingRanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFormattingRanges(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TextRange it = (TextRange)element$iv;
                    boolean bl2 = false;
                    $this$fallbackToEmbeddedFormatter_u24lambda_u244_u24lambda_u243.add(it, false);
                }
                FormatTextRanges ranges = formatTextRanges;
                formatter.formatRanges($psiFile, (FormattingRangesInfo)ranges, false, false);
            }
        };
    }

    private final String buildNotificationMessage(Document document, CharSequence textBefore) {
        String string;
        int diff = VcsFacade.getInstance().calculateChangedLinesNumber(document, textBefore);
        if (diff == 0) {
            String string2 = PyBundle.message("black.no.lines.changed", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{diff, diff == 1 ? 1 : 0};
            String string3 = PyBundle.message("black.formatted.n.lines", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final void showFormattedLinesInfo(Editor editor2, String text, boolean isError) {
        if (editor2 != null) {
            ApplicationManager.getApplication().invokeLater(() -> BlackFormattingService.showFormattedLinesInfo$lambda$1(isError, text, editor2), ModalityState.defaultModalityState(), arg_0 -> BlackFormattingService.showFormattedLinesInfo$lambda$2(editor2, arg_0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFormatFragmentAction(CharSequence documentText, AsyncFormattingRequest formattingRequest) {
        if (formattingRequest.getFormattingRanges().size() != 1) return true;
        int n = documentText.length();
        List list = formattingRequest.getFormattingRanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFormattingRanges(...)");
        if (n == ((TextRange)CollectionsKt.first((List)list)).getLength()) return false;
        return true;
    }

    @NotNull
    protected String getNotificationGroupId() {
        return NOTIFICATION_GROUP_ID;
    }

    @NotNull
    protected String getName() {
        return BlackFormattingServiceKt.access$getNAME$p();
    }

    private static final void showFormattedLinesInfo$lambda$1(boolean $isError, String $text, Editor $editor) {
        JComponent component2 = $isError ? HintUtil.createErrorLabel((String)$text) : HintUtil.createInformationLabel((String)$text);
        LightweightHint hint = new LightweightHint(component2);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, $editor, (short)1, 34, 0, false);
    }

    private static final boolean showFormattedLinesInfo$lambda$2(Editor $editor, Object it) {
        return $editor.isDisposed() || !$editor.getComponent().isShowing();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$showFormattedLinesInfo(BlackFormattingService $this, Editor editor2, String text, boolean isError) {
        $this.showFormattedLinesInfo(editor2, text, isError);
    }

    public static final /* synthetic */ java.time.Duration access$getTimeout(BlackFormattingService $this) {
        return $this.getTimeout();
    }

    public static final /* synthetic */ String access$buildNotificationMessage(BlackFormattingService $this, Document document, CharSequence textBefore) {
        return $this.buildNotificationMessage(document, textBefore);
    }

    static {
        Logger logger = Logger.getInstance(BlackFormattingService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/black/BlackFormattingService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOTIFICATION_GROUP_ID", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

