/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> 0ul) => u64vec3(1333333333333333259ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> 1ul) => u64vec3(666666666666666629ul, 42ul, 47ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> 2ul) => u64vec3(333333333333333314ul, 21ul, 23ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> 5ul) => u64vec3(41666666666666664ul, 2ul, 2ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> 25ul) => u64vec3(39736429850ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> 31ul) => u64vec3(620881716ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> 32ul) => u64vec3(310440858ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> 47ul) => u64vec3(9473ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> 63ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) >> 0ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) >> 1ul) => u64vec3(83ul, 33ul, 93ul)
 * (u64vec3(167ul, 66ul, 187ul) >> 2ul) => u64vec3(41ul, 16ul, 46ul)
 * (u64vec3(167ul, 66ul, 187ul) >> 5ul) => u64vec3(5ul, 2ul, 5ul)
 * (u64vec3(167ul, 66ul, 187ul) >> 25ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) >> 31ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) >> 32ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) >> 47ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) >> 63ul) => u64vec3(0ul, 0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> 0ul), u64vec3(1333333333333333259ul, 85ul, 94ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> 1ul), u64vec3(666666666666666629ul, 42ul, 47ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> 2ul), u64vec3(333333333333333314ul, 21ul, 23ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> 5ul), u64vec3(41666666666666664ul, 2ul, 2ul))) ? 1 : -1] array3;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> 25ul), u64vec3(39736429850ul, 0ul, 0ul))) ? 1 : -1] array4;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> 31ul), u64vec3(620881716ul, 0ul, 0ul))) ? 1 : -1] array5;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> 32ul), u64vec3(310440858ul, 0ul, 0ul))) ? 1 : -1] array6;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> 47ul), u64vec3(9473ul, 0ul, 0ul))) ? 1 : -1] array7;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> 63ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array8;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> 0ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array9;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> 1ul), u64vec3(83ul, 33ul, 93ul))) ? 1 : -1] array10;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> 2ul), u64vec3(41ul, 16ul, 46ul))) ? 1 : -1] array11;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> 5ul), u64vec3(5ul, 2ul, 5ul))) ? 1 : -1] array12;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> 25ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array13;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> 31ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array14;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> 32ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array15;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> 47ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array16;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> 63ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
