/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.password;

import com.google.common.base.Strings;
import java.util.Optional;
import org.logstash.secret.password.Validator;

public class LengthValidator
implements Validator {
    private static final int MINIMUM_LENGTH = 8;
    private static final int MAXIMUM_LENGTH = 1024;
    private int minimumLength = 8;

    public LengthValidator(int minimumLength) {
        if (minimumLength < 8 || minimumLength > 1024) {
            throw new IllegalArgumentException("Password length should be between 8 and 1024.");
        }
        this.minimumLength = minimumLength;
    }

    @Override
    public Optional<String> validate(String password) {
        String LENGTH_REASONING = "must be length of between " + this.minimumLength + " and 1024";
        return Strings.isNullOrEmpty((String)password) || password.length() < this.minimumLength ? Optional.of(LENGTH_REASONING) : Optional.empty();
    }
}

