/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.reflect.UpdateLoader;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

final class JarLoader
extends SecureClassLoader {
    private final String[] name;
    private StorageFile installedJar;
    private JarFile jar;
    private boolean isStream;
    private UpdateLoader updateLoader;
    private HeaderPrintWriter vs;

    JarLoader(UpdateLoader updateLoader, String[] name, HeaderPrintWriter vs) {
        this.updateLoader = updateLoader;
        this.name = name;
        this.vs = vs;
    }

    void initialize() {
        Throwable e;
        String schemaName = this.name[0];
        String sqlName = this.name[1];
        try {
            this.installedJar = this.updateLoader.getJarReader().getJarFile(schemaName, sqlName);
            if (this.installedJar instanceof File) {
                try {
                    this.jar = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                        @Override
                        public JarFile run() throws IOException {
                            return new JarFile((File)((Object)JarLoader.this.installedJar));
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (IOException)pae.getException();
                }
                return;
            }
            this.isStream = true;
            return;
        }
        catch (IOException ioe) {
            e = ioe;
        }
        catch (StandardException se) {
            e = se;
        }
        if (this.vs != null) {
            this.vs.println(MessageService.getTextMessage((String)"C003", (Object[])new Object[]{this.getJarName(), e}));
        }
        this.setInvalid();
    }

    protected Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (!(!className.startsWith("org.apache.derby.") || this.isDerbyDriver(className) || className.startsWith("org.apache.derby.jdbc.") || className.startsWith("org.apache.derby.vti.") || className.startsWith("org.apache.derby.agg.") || className.startsWith("org.apache.derby.optional.") || className.startsWith("org.apache.derby.impl.tools.optional."))) {
            ClassNotFoundException cnfe = new ClassNotFoundException(className);
            throw cnfe;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.updateLoader == null) {
                throw new ClassNotFoundException(MessageService.getTextMessage((String)"C004", (Object[])new Object[]{className}));
            }
            Class c = this.updateLoader.loadClass(className, resolve);
            if (c == null) {
                throw cnfe;
            }
            return c;
        }
    }

    private boolean isDerbyDriver(String className) {
        return className.startsWith("org.apache.derby.iapi.jdbc.AutoloadedDriver") || className.startsWith("org.apache.derby.iapi.client.ClientAutoloadedDriver");
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.updateLoader == null) {
            return null;
        }
        return this.updateLoader.getResourceAsStream(name);
    }

    final String getJarName() {
        return IdUtil.mkQualifiedName(this.name);
    }

    Class loadClassData(String className, String jvmClassName, boolean resolve) {
        if (this.updateLoader == null) {
            return null;
        }
        try {
            if (this.jar != null) {
                return this.loadClassDataFromJar(className, jvmClassName, resolve);
            }
            if (this.isStream) {
                return this.loadClassData(this.installedJar.getInputStream(), className, jvmClassName, resolve);
            }
            return null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        catch (IOException ioe) {
            if (this.vs != null) {
                this.vs.println(MessageService.getTextMessage((String)"C007", (Object[])new Object[]{className, this.getJarName(), ioe}));
            }
            return null;
        }
    }

    InputStream getStream(String name) {
        if (this.updateLoader == null) {
            return null;
        }
        if (this.jar != null) {
            return this.getRawStream(name);
        }
        if (this.isStream) {
            try {
                return this.getRawStream(this.installedJar.getInputStream(), name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassDataFromJar(String className, String jvmClassName, boolean resolve) throws IOException {
        JarEntry e = this.jar.getJarEntry(jvmClassName);
        if (e == null) {
            return null;
        }
        try (InputStream in = this.jar.getInputStream(e);){
            Class clazz = this.loadClassData(e, in, className, resolve);
            return clazz;
        }
    }

    private Class loadClassData(InputStream in, String className, String jvmClassName, boolean resolve) throws IOException {
        JarEntry e;
        JarInputStream jarIn = new JarInputStream(in);
        do {
            if ((e = jarIn.getNextJarEntry()) != null) continue;
            jarIn.close();
            return null;
        } while (!e.getName().equals(jvmClassName));
        Class c = this.loadClassData(e, jarIn, className, resolve);
        jarIn.close();
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassData(JarEntry e, InputStream in, String className, boolean resolve) throws IOException {
        byte[] data = this.readData(e, in, className);
        Object[] signers = this.getSigners(className, e);
        UpdateLoader updateLoader = this.updateLoader;
        synchronized (updateLoader) {
            Class<?> c = this.updateLoader.checkLoaded(className, resolve);
            if (c == null) {
                c = this.defineClass(className, data, 0, data.length, (CodeSource)null);
                if (signers != null) {
                    this.setSigners(c, signers);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
            }
            return c;
        }
    }

    Class checkLoaded(String className, boolean resolve) {
        if (this.updateLoader == null) {
            return null;
        }
        Class<?> c = this.findLoadedClass(className);
        if (c != null && resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    void setInvalid() {
        this.updateLoader = null;
        if (this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jar = null;
        }
        this.isStream = false;
    }

    private InputStream getRawStream(String name) {
        try {
            JarEntry e = this.jar.getJarEntry(name);
            if (e == null) {
                return null;
            }
            return this.jar.getInputStream(e);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getRawStream(InputStream in, String name) {
        JarInputStream jarIn = null;
        try {
            JarEntry e;
            jarIn = new JarInputStream(in);
            while ((e = jarIn.getNextJarEntry()) != null) {
                if (!e.getName().equals(name)) continue;
                int size = (int)e.getSize();
                if (size == -1) {
                    size = 8192;
                }
                InputStream inputStream = AccessibleByteArrayOutputStream.copyStream(jarIn, size);
                return inputStream;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarIn != null) {
                try {
                    jarIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    byte[] readData(JarEntry ze, InputStream in, String className) throws IOException {
        try {
            int r;
            int size = (int)ze.getSize();
            if (size != -1) {
                byte[] data = new byte[size];
                InputStreamUtil.readFully(in, data, 0, size);
                return data;
            }
            byte[] data = new byte[1024];
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            while ((r = in.read(data)) != -1) {
                os.write(data, 0, r);
            }
            data = os.toByteArray();
            return data;
        }
        catch (SecurityException se) {
            throw this.handleException(se, className);
        }
    }

    private Certificate[] getSigners(String className, JarEntry je) throws IOException {
        try {
            Certificate[] list = je.getCertificates();
            if (list == null || list.length == 0) {
                return null;
            }
            for (int i = 0; i < list.length; ++i) {
                if (!(list[i] instanceof X509Certificate)) {
                    String msg = MessageService.getTextMessage((String)"C001", (Object[])new Object[]{className, this.getJarName()});
                    throw new SecurityException(msg);
                }
                X509Certificate cert = (X509Certificate)list[i];
                cert.checkValidity();
            }
            return list;
        }
        catch (GeneralSecurityException gse) {
            throw this.handleException(gse, className);
        }
    }

    private SecurityException handleException(Exception e, String className) {
        String msg = MessageService.getTextMessage((String)"C002", (Object[])new Object[]{className, this.getJarName(), e.getLocalizedMessage()});
        return new SecurityException(msg);
    }

    public String toString() {
        return this.getJarName() + ":" + super.toString();
    }
}

