/*
 * Decompiled with CFR 0.152.
 */
package murmurhash3;

import murmurhash3.MurmurBase;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"MurmurHash3::Native32"})
public class Native32
extends MurmurBase {
    static final int _fmix(int n) {
        n ^= n >>> 16;
        n *= -2048144789;
        n ^= n >>> 13;
        n *= -1028477387;
        n ^= n >>> 16;
        return n;
    }

    static final int _mmix(int n) {
        n *= -862048943;
        n = n << 15 | n >>> 17;
        return n * 461845907;
    }

    static final int _hash(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5 = n3;
        int n6 = n2 & 0xFFFFFFFC;
        for (n4 = 0; n4 < n6; n4 += 4) {
            n5 ^= Native32._mmix(Native32.read32(byArray, n4 + n));
            n5 = n5 << 13 | n5 >>> 19;
            n5 = n5 * 5 + -430675100;
        }
        if (n2 % 4 != 0) {
            n5 ^= Native32._mmix(Native32.read24(byArray, n4 + n, n2 & 3));
        }
        return Native32._fmix(n5 ^= n2);
    }

    @JRubyMethod(name={"murmur3_32_fmix"})
    public static IRubyObject fmix32(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = (int)RubyNumeric.num2long((IRubyObject)iRubyObject2);
        n = Native32._fmix(n);
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)((long)n & 0xFFFFFFFFL));
    }

    @JRubyMethod(name={"murmur3_32_str_hash"})
    public static IRubyObject hash(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.asString();
        ByteList byteList = rubyString.getByteList();
        int n = Native32._hash(byteList.getUnsafeBytes(), byteList.begin(), byteList.getRealSize(), 0);
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)((long)n & 0xFFFFFFFFL));
    }

    @JRubyMethod(name={"murmur3_32_str_hash"})
    public static IRubyObject hash(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyString rubyString = iRubyObject2.asString();
        ByteList byteList = rubyString.getByteList();
        int n = (int)RubyNumeric.num2long((IRubyObject)iRubyObject3);
        int n2 = Native32._hash(byteList.getUnsafeBytes(), byteList.begin(), byteList.getRealSize(), n);
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)((long)n2 & 0xFFFFFFFFL));
    }

    @JRubyMethod(name={"murmur3_32_str_digest"})
    public static IRubyObject digest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.asString();
        ByteList byteList = rubyString.getByteList();
        int n = Native32._hash(byteList.getUnsafeBytes(), byteList.begin(), byteList.getRealSize(), 0);
        byte[] byArray = Native32.digest32(n);
        return RubyString.newStringNoCopy((Ruby)threadContext.runtime, (byte[])byArray);
    }

    @JRubyMethod(name={"murmur3_32_str_digest"})
    public static IRubyObject digest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyString rubyString = iRubyObject2.asString();
        ByteList byteList = rubyString.getByteList();
        int n = (int)RubyNumeric.num2long((IRubyObject)iRubyObject3);
        int n2 = Native32._hash(byteList.getUnsafeBytes(), byteList.begin(), byteList.getRealSize(), n);
        byte[] byArray = Native32.digest32(n2);
        return RubyString.newStringNoCopy((Ruby)threadContext.runtime, (byte[])byArray);
    }

    @JRubyMethod(name={"murmur3_32_str_hexdigest"})
    public static IRubyObject hexdigest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.asString();
        ByteList byteList = rubyString.getByteList();
        int n = Native32._hash(byteList.getUnsafeBytes(), byteList.begin(), byteList.getRealSize(), 0);
        byte[] byArray = Native32.digest32(n);
        return Native32.hexdigest(threadContext, byArray);
    }

    @JRubyMethod(name={"murmur3_32_str_hexdigest"})
    public static IRubyObject hexdigest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyString rubyString = iRubyObject2.asString();
        ByteList byteList = rubyString.getByteList();
        int n = (int)RubyNumeric.num2long((IRubyObject)iRubyObject3);
        int n2 = Native32._hash(byteList.getUnsafeBytes(), byteList.begin(), byteList.getRealSize(), n);
        byte[] byArray = Native32.digest32(n2);
        return Native32.hexdigest(threadContext, byArray);
    }

    @JRubyMethod(name={"murmur3_32_str_base64digest"})
    public static IRubyObject base64digest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.asString();
        ByteList byteList = rubyString.getByteList();
        int n = Native32._hash(byteList.getUnsafeBytes(), byteList.begin(), byteList.getRealSize(), 0);
        byte[] byArray = Native32.digest32(n);
        return Native32.base64digest(threadContext, byArray);
    }

    @JRubyMethod(name={"murmur3_32_str_base64digest"})
    public static IRubyObject base64digest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyString rubyString = iRubyObject2.asString();
        ByteList byteList = rubyString.getByteList();
        int n = (int)RubyNumeric.num2long((IRubyObject)iRubyObject3);
        int n2 = Native32._hash(byteList.getUnsafeBytes(), byteList.begin(), byteList.getRealSize(), n);
        byte[] byArray = Native32.digest32(n2);
        return Native32.base64digest(threadContext, byArray);
    }

    @JRubyMethod(name={"murmur3_32_int32_hash"})
    public static IRubyObject int32_hash(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = (int)RubyNumeric.num2long((IRubyObject)iRubyObject2);
        byte[] byArray = Native32.digest32(n);
        int n2 = Native32._hash(byArray, 0, 4, 0);
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)((long)n2 & 0xFFFFFFFFL));
    }

    @JRubyMethod(name={"murmur3_32_int32_hash"})
    public static IRubyObject int32_hash(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        int n = (int)RubyNumeric.num2long((IRubyObject)iRubyObject2);
        int n2 = (int)RubyNumeric.num2long((IRubyObject)iRubyObject3);
        byte[] byArray = Native32.digest32(n);
        int n3 = Native32._hash(byArray, 0, 4, n2);
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)((long)n3 & 0xFFFFFFFFL));
    }

    @JRubyMethod(name={"murmur3_32_int64_hash"})
    public static IRubyObject int64_hash(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        long l = Native32.num2ulong(iRubyObject2);
        byte[] byArray = Native32.digest64(l);
        int n = Native32._hash(byArray, 0, 8, 0);
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)((long)n & 0xFFFFFFFFL));
    }

    @JRubyMethod(name={"murmur3_32_int64_hash"})
    public static IRubyObject int64_hash(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        long l = Native32.num2ulong(iRubyObject2);
        int n = (int)RubyNumeric.num2long((IRubyObject)iRubyObject3);
        byte[] byArray = Native32.digest64(l);
        int n2 = Native32._hash(byArray, 0, 8, n);
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)((long)n2 & 0xFFFFFFFFL));
    }
}

