<?php
/**
 * TasksService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * TasksService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TasksService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteTasksID
     *
     * Delete a task
     *
     * @param  string $task_id The ID of the task to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTasksID($task_id, $zap_trace_span = null)
    {
        $this->deleteTasksIDWithHttpInfo($task_id, $zap_trace_span);
    }

    /**
     * Operation deleteTasksIDWithHttpInfo
     *
     * Delete a task
     *
     * @param  string $task_id The ID of the task to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTasksIDWithHttpInfo($task_id, $zap_trace_span = null)
    {
        $request = $this->deleteTasksIDRequest($task_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteTasksID'
     *
     * @param  string $task_id The ID of the task to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteTasksIDRequest($task_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling deleteTasksID'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteTasksIDLabelsID
     *
     * Delete a label from a task
     *
     * @param  string $task_id The ID of the task to delete the label from. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTasksIDLabelsID($task_id, $label_id, $zap_trace_span = null)
    {
        $this->deleteTasksIDLabelsIDWithHttpInfo($task_id, $label_id, $zap_trace_span);
    }

    /**
     * Operation deleteTasksIDLabelsIDWithHttpInfo
     *
     * Delete a label from a task
     *
     * @param  string $task_id The ID of the task to delete the label from. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTasksIDLabelsIDWithHttpInfo($task_id, $label_id, $zap_trace_span = null)
    {
        $request = $this->deleteTasksIDLabelsIDRequest($task_id, $label_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteTasksIDLabelsID'
     *
     * @param  string $task_id The ID of the task to delete the label from. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteTasksIDLabelsIDRequest($task_id, $label_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling deleteTasksIDLabelsID'
            );
        }
        // verify the required parameter 'label_id' is set
        if ($label_id === null || (is_array($label_id) && count($label_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_id when calling deleteTasksIDLabelsID'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/labels/{labelID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }
        // path params
        if ($label_id !== null) {
            $resourcePath = str_replace(
                '{' . 'labelID' . '}',
                ObjectSerializer::toPathValue($label_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteTasksIDMembersID
     *
     * Remove a member from a task
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTasksIDMembersID($user_id, $task_id, $zap_trace_span = null)
    {
        $this->deleteTasksIDMembersIDWithHttpInfo($user_id, $task_id, $zap_trace_span);
    }

    /**
     * Operation deleteTasksIDMembersIDWithHttpInfo
     *
     * Remove a member from a task
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTasksIDMembersIDWithHttpInfo($user_id, $task_id, $zap_trace_span = null)
    {
        $request = $this->deleteTasksIDMembersIDRequest($user_id, $task_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteTasksIDMembersID'
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteTasksIDMembersIDRequest($user_id, $task_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteTasksIDMembersID'
            );
        }
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling deleteTasksIDMembersID'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/members/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteTasksIDOwnersID
     *
     * Remove an owner from a task
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTasksIDOwnersID($user_id, $task_id, $zap_trace_span = null)
    {
        $this->deleteTasksIDOwnersIDWithHttpInfo($user_id, $task_id, $zap_trace_span);
    }

    /**
     * Operation deleteTasksIDOwnersIDWithHttpInfo
     *
     * Remove an owner from a task
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTasksIDOwnersIDWithHttpInfo($user_id, $task_id, $zap_trace_span = null)
    {
        $request = $this->deleteTasksIDOwnersIDRequest($user_id, $task_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteTasksIDOwnersID'
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteTasksIDOwnersIDRequest($user_id, $task_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteTasksIDOwnersID'
            );
        }
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling deleteTasksIDOwnersID'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/owners/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteTasksIDRunsID
     *
     * Cancel a running task
     *
     * @param  string $task_id The ID of the task to cancel. (required)
     * @param  string $run_id The ID of the task run to cancel. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTasksIDRunsID($task_id, $run_id, $zap_trace_span = null)
    {
        $this->deleteTasksIDRunsIDWithHttpInfo($task_id, $run_id, $zap_trace_span);
    }

    /**
     * Operation deleteTasksIDRunsIDWithHttpInfo
     *
     * Cancel a running task
     *
     * @param  string $task_id The ID of the task to cancel. (required)
     * @param  string $run_id The ID of the task run to cancel. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTasksIDRunsIDWithHttpInfo($task_id, $run_id, $zap_trace_span = null)
    {
        $request = $this->deleteTasksIDRunsIDRequest($task_id, $run_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteTasksIDRunsID'
     *
     * @param  string $task_id The ID of the task to cancel. (required)
     * @param  string $run_id The ID of the task run to cancel. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteTasksIDRunsIDRequest($task_id, $run_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling deleteTasksIDRunsID'
            );
        }
        // verify the required parameter 'run_id' is set
        if ($run_id === null || (is_array($run_id) && count($run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $run_id when calling deleteTasksIDRunsID'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/runs/{runID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }
        // path params
        if ($run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'runID' . '}',
                ObjectSerializer::toPathValue($run_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTasks
     *
     * List tasks
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $name Task name. Only returns tasks with this name. Different tasks may have the same name. (optional)
     * @param  string $after Task ID. Only returns tasks created after this task. (optional)
     * @param  string $user User ID. Only returns tasks owned by this user. (optional)
     * @param  string $org Organization name. Only returns tasks owned by this organization. (optional)
     * @param  string $org_id Organization ID. Only returns tasks owned by this organization. (optional)
     * @param  string $status Task status (&#x60;active&#x60; or &#x60;inactive&#x60;). Only returns tasks with this status. (optional)
     * @param  int $limit Limits the number of tasks returned. The minimum is &#x60;1&#x60;, the maximum is &#x60;500&#x60;, and the default is &#x60;100&#x60;. (optional, default to 100)
     * @param  string $type Task type (&#x60;basic&#x60; or &#x60;system&#x60;).  The default (&#x60;system&#x60;) response contains all the metadata properties for tasks. To reduce the payload size, pass &#x60;basic&#x60; to omit some task properties (&#x60;flux&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;) from the response. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Tasks|object|\InfluxDB2\Model\Error|string
     */
    public function getTasks($zap_trace_span = null, $name = null, $after = null, $user = null, $org = null, $org_id = null, $status = null, $limit = 100, $type = null)
    {
        list($response) = $this->getTasksWithHttpInfo($zap_trace_span, $name, $after, $user, $org, $org_id, $status, $limit, $type);
        return $response;
    }

    /**
     * Operation getTasksWithHttpInfo
     *
     * List tasks
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $name Task name. Only returns tasks with this name. Different tasks may have the same name. (optional)
     * @param  string $after Task ID. Only returns tasks created after this task. (optional)
     * @param  string $user User ID. Only returns tasks owned by this user. (optional)
     * @param  string $org Organization name. Only returns tasks owned by this organization. (optional)
     * @param  string $org_id Organization ID. Only returns tasks owned by this organization. (optional)
     * @param  string $status Task status (&#x60;active&#x60; or &#x60;inactive&#x60;). Only returns tasks with this status. (optional)
     * @param  int $limit Limits the number of tasks returned. The minimum is &#x60;1&#x60;, the maximum is &#x60;500&#x60;, and the default is &#x60;100&#x60;. (optional, default to 100)
     * @param  string $type Task type (&#x60;basic&#x60; or &#x60;system&#x60;).  The default (&#x60;system&#x60;) response contains all the metadata properties for tasks. To reduce the payload size, pass &#x60;basic&#x60; to omit some task properties (&#x60;flux&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;) from the response. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Tasks|object|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTasksWithHttpInfo($zap_trace_span = null, $name = null, $after = null, $user = null, $org = null, $org_id = null, $status = null, $limit = 100, $type = null)
    {
        $request = $this->getTasksRequest($zap_trace_span, $name, $after, $user, $org, $org_id, $status, $limit, $type);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Tasks';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTasks'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $name Task name. Only returns tasks with this name. Different tasks may have the same name. (optional)
     * @param  string $after Task ID. Only returns tasks created after this task. (optional)
     * @param  string $user User ID. Only returns tasks owned by this user. (optional)
     * @param  string $org Organization name. Only returns tasks owned by this organization. (optional)
     * @param  string $org_id Organization ID. Only returns tasks owned by this organization. (optional)
     * @param  string $status Task status (&#x60;active&#x60; or &#x60;inactive&#x60;). Only returns tasks with this status. (optional)
     * @param  int $limit Limits the number of tasks returned. The minimum is &#x60;1&#x60;, the maximum is &#x60;500&#x60;, and the default is &#x60;100&#x60;. (optional, default to 100)
     * @param  string $type Task type (&#x60;basic&#x60; or &#x60;system&#x60;).  The default (&#x60;system&#x60;) response contains all the metadata properties for tasks. To reduce the payload size, pass &#x60;basic&#x60; to omit some task properties (&#x60;flux&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;) from the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTasksRequest($zap_trace_span = null, $name = null, $after = null, $user = null, $org = null, $org_id = null, $status = null, $limit = 100, $type = null)
    {
        if ($limit !== null && $limit > 500) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling TasksService.getTasks, must be smaller than or equal to 500.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling TasksService.getTasks, must be bigger than or equal to 1.');
        }


        $resourcePath = '/api/v2/tasks';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($name !== null) {
            $queryParams['name'] = ObjectSerializer::toQueryValue($name);
        }
        // query params
        if ($after !== null) {
            $queryParams['after'] = ObjectSerializer::toQueryValue($after);
        }
        // query params
        if ($user !== null) {
            $queryParams['user'] = ObjectSerializer::toQueryValue($user);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($status !== null) {
            $queryParams['status'] = ObjectSerializer::toQueryValue($status);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($type !== null) {
            $queryParams['type'] = ObjectSerializer::toQueryValue($type);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTasksID
     *
     * Retrieve a task
     *
     * @param  string $task_id The ID of the task to retrieve. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Task|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function getTasksID($task_id, $zap_trace_span = null)
    {
        list($response) = $this->getTasksIDWithHttpInfo($task_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTasksIDWithHttpInfo
     *
     * Retrieve a task
     *
     * @param  string $task_id The ID of the task to retrieve. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Task|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTasksIDWithHttpInfo($task_id, $zap_trace_span = null)
    {
        $request = $this->getTasksIDRequest($task_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Task';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTasksID'
     *
     * @param  string $task_id The ID of the task to retrieve. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTasksIDRequest($task_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling getTasksID'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTasksIDLabels
     *
     * List labels for a task
     *
     * @param  string $task_id The ID of the task to retrieve labels for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function getTasksIDLabels($task_id, $zap_trace_span = null)
    {
        list($response) = $this->getTasksIDLabelsWithHttpInfo($task_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTasksIDLabelsWithHttpInfo
     *
     * List labels for a task
     *
     * @param  string $task_id The ID of the task to retrieve labels for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTasksIDLabelsWithHttpInfo($task_id, $zap_trace_span = null)
    {
        $request = $this->getTasksIDLabelsRequest($task_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelsResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTasksIDLabels'
     *
     * @param  string $task_id The ID of the task to retrieve labels for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTasksIDLabelsRequest($task_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling getTasksIDLabels'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTasksIDLogs
     *
     * Retrieve all logs for a task
     *
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Logs|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function getTasksIDLogs($task_id, $zap_trace_span = null)
    {
        list($response) = $this->getTasksIDLogsWithHttpInfo($task_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTasksIDLogsWithHttpInfo
     *
     * Retrieve all logs for a task
     *
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Logs|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTasksIDLogsWithHttpInfo($task_id, $zap_trace_span = null)
    {
        $request = $this->getTasksIDLogsRequest($task_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Logs';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTasksIDLogs'
     *
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTasksIDLogsRequest($task_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling getTasksIDLogs'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/logs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTasksIDMembers
     *
     * List all task members
     *
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error
     */
    public function getTasksIDMembers($task_id, $zap_trace_span = null)
    {
        list($response) = $this->getTasksIDMembersWithHttpInfo($task_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTasksIDMembersWithHttpInfo
     *
     * List all task members
     *
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTasksIDMembersWithHttpInfo($task_id, $zap_trace_span = null)
    {
        $request = $this->getTasksIDMembersRequest($task_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMembers';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTasksIDMembers'
     *
     * @param  string $task_id The task ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTasksIDMembersRequest($task_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling getTasksIDMembers'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTasksIDOwners
     *
     * List all owners of a task
     *
     * @param  string $task_id The ID of the task to retrieve owners for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwners|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getTasksIDOwners($task_id, $zap_trace_span = null)
    {
        list($response) = $this->getTasksIDOwnersWithHttpInfo($task_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTasksIDOwnersWithHttpInfo
     *
     * List all owners of a task
     *
     * @param  string $task_id The ID of the task to retrieve owners for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwners|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTasksIDOwnersWithHttpInfo($task_id, $zap_trace_span = null)
    {
        $request = $this->getTasksIDOwnersRequest($task_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwners';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTasksIDOwners'
     *
     * @param  string $task_id The ID of the task to retrieve owners for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTasksIDOwnersRequest($task_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling getTasksIDOwners'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTasksIDRuns
     *
     * List runs for a task
     *
     * @param  string $task_id The ID of the task to get runs for. Only returns runs for this task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $after A task run ID. Only returns runs created after this run. (optional)
     * @param  int $limit Limits the number of task runs returned. Default is &#x60;100&#x60;. (optional, default to 100)
     * @param  \DateTime $after_time A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled after this time. (optional)
     * @param  \DateTime $before_time A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled before this time. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Runs|object|\InfluxDB2\Model\Error|string
     */
    public function getTasksIDRuns($task_id, $zap_trace_span = null, $after = null, $limit = 100, $after_time = null, $before_time = null)
    {
        list($response) = $this->getTasksIDRunsWithHttpInfo($task_id, $zap_trace_span, $after, $limit, $after_time, $before_time);
        return $response;
    }

    /**
     * Operation getTasksIDRunsWithHttpInfo
     *
     * List runs for a task
     *
     * @param  string $task_id The ID of the task to get runs for. Only returns runs for this task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $after A task run ID. Only returns runs created after this run. (optional)
     * @param  int $limit Limits the number of task runs returned. Default is &#x60;100&#x60;. (optional, default to 100)
     * @param  \DateTime $after_time A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled after this time. (optional)
     * @param  \DateTime $before_time A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled before this time. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Runs|object|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTasksIDRunsWithHttpInfo($task_id, $zap_trace_span = null, $after = null, $limit = 100, $after_time = null, $before_time = null)
    {
        $request = $this->getTasksIDRunsRequest($task_id, $zap_trace_span, $after, $limit, $after_time, $before_time);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Runs';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTasksIDRuns'
     *
     * @param  string $task_id The ID of the task to get runs for. Only returns runs for this task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $after A task run ID. Only returns runs created after this run. (optional)
     * @param  int $limit Limits the number of task runs returned. Default is &#x60;100&#x60;. (optional, default to 100)
     * @param  \DateTime $after_time A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled after this time. (optional)
     * @param  \DateTime $before_time A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled before this time. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTasksIDRunsRequest($task_id, $zap_trace_span = null, $after = null, $limit = 100, $after_time = null, $before_time = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling getTasksIDRuns'
            );
        }
        if ($limit !== null && $limit > 500) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling TasksService.getTasksIDRuns, must be smaller than or equal to 500.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling TasksService.getTasksIDRuns, must be bigger than or equal to 1.');
        }


        $resourcePath = '/api/v2/tasks/{taskID}/runs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($after !== null) {
            $queryParams['after'] = ObjectSerializer::toQueryValue($after);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($after_time !== null) {
            $queryParams['afterTime'] = ObjectSerializer::toQueryValue($after_time);
        }
        // query params
        if ($before_time !== null) {
            $queryParams['beforeTime'] = ObjectSerializer::toQueryValue($before_time);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTasksIDRunsID
     *
     * Retrieve a run for a task.
     *
     * @param  string $task_id The ID of the task to retrieve runs for. (required)
     * @param  string $run_id The ID of the run to retrieve. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Run|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function getTasksIDRunsID($task_id, $run_id, $zap_trace_span = null)
    {
        list($response) = $this->getTasksIDRunsIDWithHttpInfo($task_id, $run_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTasksIDRunsIDWithHttpInfo
     *
     * Retrieve a run for a task.
     *
     * @param  string $task_id The ID of the task to retrieve runs for. (required)
     * @param  string $run_id The ID of the run to retrieve. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Run|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTasksIDRunsIDWithHttpInfo($task_id, $run_id, $zap_trace_span = null)
    {
        $request = $this->getTasksIDRunsIDRequest($task_id, $run_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Run';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTasksIDRunsID'
     *
     * @param  string $task_id The ID of the task to retrieve runs for. (required)
     * @param  string $run_id The ID of the run to retrieve. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTasksIDRunsIDRequest($task_id, $run_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling getTasksIDRunsID'
            );
        }
        // verify the required parameter 'run_id' is set
        if ($run_id === null || (is_array($run_id) && count($run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $run_id when calling getTasksIDRunsID'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/runs/{runID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }
        // path params
        if ($run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'runID' . '}',
                ObjectSerializer::toPathValue($run_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTasksIDRunsIDLogs
     *
     * Retrieve all logs for a run
     *
     * @param  string $task_id The ID of the task to get logs for. (required)
     * @param  string $run_id The ID of the run to get logs for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Logs|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function getTasksIDRunsIDLogs($task_id, $run_id, $zap_trace_span = null)
    {
        list($response) = $this->getTasksIDRunsIDLogsWithHttpInfo($task_id, $run_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTasksIDRunsIDLogsWithHttpInfo
     *
     * Retrieve all logs for a run
     *
     * @param  string $task_id The ID of the task to get logs for. (required)
     * @param  string $run_id The ID of the run to get logs for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Logs|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTasksIDRunsIDLogsWithHttpInfo($task_id, $run_id, $zap_trace_span = null)
    {
        $request = $this->getTasksIDRunsIDLogsRequest($task_id, $run_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Logs';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTasksIDRunsIDLogs'
     *
     * @param  string $task_id The ID of the task to get logs for. (required)
     * @param  string $run_id The ID of the run to get logs for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTasksIDRunsIDLogsRequest($task_id, $run_id, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling getTasksIDRunsIDLogs'
            );
        }
        // verify the required parameter 'run_id' is set
        if ($run_id === null || (is_array($run_id) && count($run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $run_id when calling getTasksIDRunsIDLogs'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/runs/{runID}/logs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }
        // path params
        if ($run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'runID' . '}',
                ObjectSerializer::toPathValue($run_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchTasksID
     *
     * Update a task
     *
     * @param  string $task_id The ID of the task to update. (required)
     * @param  \InfluxDB2\Model\TaskUpdateRequest $task_update_request An object that contains updated task properties to apply. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Task|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function patchTasksID($task_id, $task_update_request, $zap_trace_span = null)
    {
        list($response) = $this->patchTasksIDWithHttpInfo($task_id, $task_update_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchTasksIDWithHttpInfo
     *
     * Update a task
     *
     * @param  string $task_id The ID of the task to update. (required)
     * @param  \InfluxDB2\Model\TaskUpdateRequest $task_update_request An object that contains updated task properties to apply. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Task|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchTasksIDWithHttpInfo($task_id, $task_update_request, $zap_trace_span = null)
    {
        $request = $this->patchTasksIDRequest($task_id, $task_update_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Task';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchTasksID'
     *
     * @param  string $task_id The ID of the task to update. (required)
     * @param  \InfluxDB2\Model\TaskUpdateRequest $task_update_request An object that contains updated task properties to apply. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchTasksIDRequest($task_id, $task_update_request, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling patchTasksID'
            );
        }
        // verify the required parameter 'task_update_request' is set
        if ($task_update_request === null || (is_array($task_update_request) && count($task_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_update_request when calling patchTasksID'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($task_update_request)) {
            $_tempBody = $task_update_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTasks
     *
     * Create a task
     *
     * @param  \InfluxDB2\Model\TaskCreateRequest $task_create_request The task to create. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Task|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postTasks($task_create_request, $zap_trace_span = null)
    {
        list($response) = $this->postTasksWithHttpInfo($task_create_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postTasksWithHttpInfo
     *
     * Create a task
     *
     * @param  \InfluxDB2\Model\TaskCreateRequest $task_create_request The task to create. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Task|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTasksWithHttpInfo($task_create_request, $zap_trace_span = null)
    {
        $request = $this->postTasksRequest($task_create_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Task';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTasks'
     *
     * @param  \InfluxDB2\Model\TaskCreateRequest $task_create_request The task to create. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTasksRequest($task_create_request, $zap_trace_span = null)
    {
        // verify the required parameter 'task_create_request' is set
        if ($task_create_request === null || (is_array($task_create_request) && count($task_create_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_create_request when calling postTasks'
            );
        }

        $resourcePath = '/api/v2/tasks';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($task_create_request)) {
            $_tempBody = $task_create_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTasksIDLabels
     *
     * Add a label to a task
     *
     * @param  string $task_id The ID of the task to label. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping An object that contains a _&#x60;labelID&#x60;_ to add to the task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function postTasksIDLabels($task_id, $label_mapping, $zap_trace_span = null)
    {
        list($response) = $this->postTasksIDLabelsWithHttpInfo($task_id, $label_mapping, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postTasksIDLabelsWithHttpInfo
     *
     * Add a label to a task
     *
     * @param  string $task_id The ID of the task to label. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping An object that contains a _&#x60;labelID&#x60;_ to add to the task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTasksIDLabelsWithHttpInfo($task_id, $label_mapping, $zap_trace_span = null)
    {
        $request = $this->postTasksIDLabelsRequest($task_id, $label_mapping, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTasksIDLabels'
     *
     * @param  string $task_id The ID of the task to label. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping An object that contains a _&#x60;labelID&#x60;_ to add to the task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTasksIDLabelsRequest($task_id, $label_mapping, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling postTasksIDLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling postTasksIDLabels'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTasksIDMembers
     *
     * Add a member to a task
     *
     * @param  string $task_id The task ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body A user to add as a member of the task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error
     */
    public function postTasksIDMembers($task_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postTasksIDMembersWithHttpInfo($task_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postTasksIDMembersWithHttpInfo
     *
     * Add a member to a task
     *
     * @param  string $task_id The task ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body A user to add as a member of the task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTasksIDMembersWithHttpInfo($task_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postTasksIDMembersRequest($task_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMember';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTasksIDMembers'
     *
     * @param  string $task_id The task ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body A user to add as a member of the task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTasksIDMembersRequest($task_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling postTasksIDMembers'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postTasksIDMembers'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTasksIDOwners
     *
     * Add an owner for a task
     *
     * @param  string $task_id The task ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body A user to add as an owner of the task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwner|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postTasksIDOwners($task_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postTasksIDOwnersWithHttpInfo($task_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postTasksIDOwnersWithHttpInfo
     *
     * Add an owner for a task
     *
     * @param  string $task_id The task ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body A user to add as an owner of the task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwner|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTasksIDOwnersWithHttpInfo($task_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postTasksIDOwnersRequest($task_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwner';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTasksIDOwners'
     *
     * @param  string $task_id The task ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body A user to add as an owner of the task. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTasksIDOwnersRequest($task_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling postTasksIDOwners'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postTasksIDOwners'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTasksIDRuns
     *
     * Start a task run, overriding the schedule
     *
     * @param  string $task_id task_id (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  \InfluxDB2\Model\RunManually $run_manually run_manually (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Run|object|\InfluxDB2\Model\Error|string
     */
    public function postTasksIDRuns($task_id, $zap_trace_span = null, $run_manually = null)
    {
        list($response) = $this->postTasksIDRunsWithHttpInfo($task_id, $zap_trace_span, $run_manually);
        return $response;
    }

    /**
     * Operation postTasksIDRunsWithHttpInfo
     *
     * Start a task run, overriding the schedule
     *
     * @param  string $task_id (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  \InfluxDB2\Model\RunManually $run_manually (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Run|object|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTasksIDRunsWithHttpInfo($task_id, $zap_trace_span = null, $run_manually = null)
    {
        $request = $this->postTasksIDRunsRequest($task_id, $zap_trace_span, $run_manually);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Run';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTasksIDRuns'
     *
     * @param  string $task_id (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  \InfluxDB2\Model\RunManually $run_manually (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTasksIDRunsRequest($task_id, $zap_trace_span = null, $run_manually = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling postTasksIDRuns'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/runs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($run_manually)) {
            $_tempBody = $run_manually;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTasksIDRunsIDRetry
     *
     * Retry a task run
     *
     * @param  string $task_id The ID of the task to retry. (required)
     * @param  string $run_id The ID of the task run to retry. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $body body (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Run|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function postTasksIDRunsIDRetry($task_id, $run_id, $zap_trace_span = null, $body = null)
    {
        list($response) = $this->postTasksIDRunsIDRetryWithHttpInfo($task_id, $run_id, $zap_trace_span, $body);
        return $response;
    }

    /**
     * Operation postTasksIDRunsIDRetryWithHttpInfo
     *
     * Retry a task run
     *
     * @param  string $task_id The ID of the task to retry. (required)
     * @param  string $run_id The ID of the task run to retry. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $body (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Run|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTasksIDRunsIDRetryWithHttpInfo($task_id, $run_id, $zap_trace_span = null, $body = null)
    {
        $request = $this->postTasksIDRunsIDRetryRequest($task_id, $run_id, $zap_trace_span, $body);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Run';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTasksIDRunsIDRetry'
     *
     * @param  string $task_id The ID of the task to retry. (required)
     * @param  string $run_id The ID of the task run to retry. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTasksIDRunsIDRetryRequest($task_id, $run_id, $zap_trace_span = null, $body = null)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling postTasksIDRunsIDRetry'
            );
        }
        // verify the required parameter 'run_id' is set
        if ($run_id === null || (is_array($run_id) && count($run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $run_id when calling postTasksIDRunsIDRetry'
            );
        }

        $resourcePath = '/api/v2/tasks/{taskID}/runs/{runID}/retry';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskID' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }
        // path params
        if ($run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'runID' . '}',
                ObjectSerializer::toPathValue($run_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json; charset=utf-8']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
