/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.List;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;

public class TypeVariableDetailsImpl
implements TypeVariableDetails {
    private final String identifier;
    private final ClassDetails declaringType;
    private final List<TypeDetails> bounds;
    private final String name;

    public TypeVariableDetailsImpl(String identifier, ClassDetails declaringType, List<TypeDetails> bounds) {
        this.identifier = identifier;
        this.declaringType = declaringType;
        this.bounds = bounds;
        this.name = this.calculateName(bounds);
    }

    private String calculateName(List<TypeDetails> bounds) {
        if (!bounds.isEmpty()) {
            return bounds.get(0).getName();
        }
        return Object.class.getName();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public List<TypeDetails> getBounds() {
        return this.bounds;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isImplementor(Class<?> checkType) {
        if (this.bounds.size() == 1) {
            return this.bounds.get(0).isImplementor(checkType);
        }
        return checkType == Object.class;
    }

    @Override
    public TypeDetails resolveTypeVariable(TypeVariableDetails typeVariable) {
        return this.identifier.equals(typeVariable.getIdentifier()) ? this : null;
    }

    public String toString() {
        return "TypeVariableDetails(" + this.identifier + " : " + this.name + ")";
    }
}

