/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Predicate;

public final class MultiSkipFirstUntilOp<T>
extends AbstractMultiOperator<T, T> {
    private final Predicate<? super T> predicate;

    public MultiSkipFirstUntilOp(Multi<? extends T> upstream, Predicate<? super T> predicate) {
        super(upstream);
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        ParameterValidation.nonNullNpe(subscriber, "subscriber");
        this.upstream.subscribe(new MultiSkipFirstUntilProcessor<T>(subscriber, this.predicate));
    }

    static final class MultiSkipFirstUntilProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Predicate<? super T> predicate;
        private boolean gateOpen = false;

        MultiSkipFirstUntilProcessor(MultiSubscriber<? super T> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        @Override
        public void onItem(T t) {
            boolean toBeSkipped;
            if (this.isDone()) {
                return;
            }
            if (this.gateOpen) {
                this.downstream.onItem(t);
                return;
            }
            try {
                toBeSkipped = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.failAndCancel(e);
                return;
            }
            if (!toBeSkipped) {
                this.gateOpen = true;
                this.downstream.onItem(t);
                return;
            }
            this.request(1L);
        }
    }
}

