/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u0002\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"markElement", "", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "markSingleElement", "markNode", "node", "Lcom/intellij/lang/ASTNode;", "markRange", "range", "from", "to", "getStartOffset", "", "getEndOffset", "hasSyntaxErrors", "", "psiElement", "frontend.common-psi"})
public final class PositioningStrategyKt {
    @NotNull
    public static final List<TextRange> markElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return CollectionsKt.listOf((Object)new TextRange(PositioningStrategyKt.getStartOffset(element), PositioningStrategyKt.getEndOffset(element)));
    }

    @NotNull
    public static final TextRange markSingleElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new TextRange(PositioningStrategyKt.getStartOffset(element), PositioningStrategyKt.getEndOffset(element));
    }

    @NotNull
    public static final List<TextRange> markNode(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        return PositioningStrategyKt.markElement(psiElement);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return CollectionsKt.listOf((Object)range);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull PsiElement from, @NotNull PsiElement to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return PositioningStrategyKt.markRange(new TextRange(PositioningStrategyKt.getStartOffset(from), PositioningStrategyKt.getEndOffset(to)));
    }

    private static final int getStartOffset(PsiElement element) {
        PsiElement child = element.getFirstChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child != null) {
                return PositioningStrategyKt.getStartOffset(child);
            }
        }
        return PsiUtilsKt.getStartOffset(element);
    }

    private static final int getEndOffset(PsiElement element) {
        PsiElement child = element.getLastChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getPrevSibling();
            }
            if (child != null) {
                return PositioningStrategyKt.getEndOffset(child);
            }
        }
        return PsiUtilsKt.getEndOffset(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasSyntaxErrors(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (psiElement instanceof PsiErrorElement) {
            return true;
        }
        Object[] objectArray = psiElement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
        Object[] children = objectArray;
        if (children.length == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Object object = ArraysKt.last((Object[])children);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        if (!PositioningStrategyKt.hasSyntaxErrors((PsiElement)object)) return false;
        return true;
    }
}

