/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.dom;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.intern.observable.property.WritableProperty;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAttributeSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgColor;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPlatformPeer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformable;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001'B\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bB\u0005\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0015J\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0015J\u0010\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0015H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0015J\u0010\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0015H\u0016J\u0010\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0016J\u0010\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0015H\u0016J\u0010\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0015H\u0016J\u0010\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0015H\u0016J\u0010\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0015H\u0016J\u0010\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0\u0015H\u0016R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgCircleElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGraphicsElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransformable;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgShape;", "cx", "", "cy", "r", "(DDD)V", "p", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;D)V", "()V", "bBox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getBBox", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "elementName", "", "getElementName", "()Ljava/lang/String;", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "fill", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgColor;", "fillColor", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/WritableProperty;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "fillOpacity", "pointToAbsoluteCoordinates", "point", "pointToTransformedCoordinates", "stroke", "strokeColor", "strokeDashArray", "strokeDashOffset", "strokeOpacity", "strokeWidth", "transform", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransform;", "Companion", "datamodel"})
public final class SvgCircleElement
extends SvgGraphicsElement
implements SvgTransformable,
SvgShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String elementName;
    @NotNull
    private static final SvgAttributeSpec<Double> CX = SvgAttributeSpec.Companion.createSpec("cx");
    @NotNull
    private static final SvgAttributeSpec<Double> CY = SvgAttributeSpec.Companion.createSpec("cy");
    @NotNull
    private static final SvgAttributeSpec<Double> R = SvgAttributeSpec.Companion.createSpec("r");

    public SvgCircleElement() {
        this.elementName = "circle";
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    @NotNull
    public DoubleRectangle getBBox() {
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.getBBox(this);
    }

    public SvgCircleElement(double cx, double cy, double r) {
        this();
        this.setAttribute(CX, cx);
        this.setAttribute(CY, cy);
        this.setAttribute(R, r);
    }

    public SvgCircleElement(@NotNull DoubleVector p, double r) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this(p.getX(), p.getY(), r);
    }

    @NotNull
    public final Property<Double> cx() {
        return this.getAttribute(CX);
    }

    @NotNull
    public final Property<Double> cy() {
        return this.getAttribute(CY);
    }

    @NotNull
    public final Property<Double> r() {
        return this.getAttribute(R);
    }

    @Override
    @NotNull
    public Property<SvgTransform> transform() {
        return this.getAttribute(SvgTransformable.Companion.getTRANSFORM());
    }

    @Override
    @NotNull
    public Property<SvgColor> fill() {
        return this.getAttribute(SvgShape.Companion.getFILL());
    }

    @Override
    @NotNull
    public WritableProperty<Color> fillColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$datamodel(this.fill(), this.fillOpacity());
    }

    @Override
    @NotNull
    public Property<Double> fillOpacity() {
        return this.getAttribute(SvgShape.Companion.getFILL_OPACITY());
    }

    @Override
    @NotNull
    public Property<SvgColor> stroke() {
        return this.getAttribute(SvgShape.Companion.getSTROKE());
    }

    @Override
    @NotNull
    public WritableProperty<Color> strokeColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$datamodel(this.stroke(), this.strokeOpacity());
    }

    @Override
    @NotNull
    public Property<Double> strokeOpacity() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_OPACITY());
    }

    @Override
    @NotNull
    public Property<Double> strokeWidth() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_WIDTH());
    }

    @Override
    @NotNull
    public Property<String> strokeDashArray() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_DASHARRAY());
    }

    @Override
    @NotNull
    public Property<Double> strokeDashOffset() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_DASHOFFSET());
    }

    @Override
    @NotNull
    public DoubleVector pointToTransformedCoordinates(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.invertTransform(this, point);
    }

    @Override
    @NotNull
    public DoubleVector pointToAbsoluteCoordinates(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.applyTransform(this, point);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgCircleElement$Companion;", "", "()V", "CX", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "", "getCX", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "CY", "getCY", "R", "getR", "datamodel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgAttributeSpec<Double> getCX() {
            return CX;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getCY() {
            return CY;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getR() {
            return R;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

