/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v1;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.IDataInput;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.SeekableInputStream;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.StructTypes;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.ValueReaders;

public class SpecificReaders {
    private static Logger LOG = Logger.getLogger(SpecificReaders.class.getName());

    static class StackFrame2Reader
    extends ValueReaders.ReflectiveReader {
        boolean fallback;
        int methodIdx;
        int lineNumberIdx;
        int bytecodeIndexIdx;
        int typeIdx;
        private final Map<FrameData, StructTypes.JfrFrame> frames = new HashMap<FrameData, StructTypes.JfrFrame>();

        <T> StackFrame2Reader(Class<T> klass, int fieldCount, ContentType<? super T> ct) {
            super(klass, fieldCount, ct);
        }

        @Override
        void addField(String identifier, String name, String description, ValueReaders.IValueReader reader) throws InvalidJfrFileException {
            super.addField(identifier, name, description, reader);
            int currentIdx = this.valueReaders.size() - 1;
            switch (identifier) {
                case "method": {
                    this.methodIdx = currentIdx;
                    break;
                }
                case "lineNumber": {
                    this.lineNumberIdx = currentIdx;
                    break;
                }
                case "bytecodeIndex": {
                    this.bytecodeIndexIdx = currentIdx;
                    break;
                }
                case "type": {
                    this.typeIdx = currentIdx;
                    break;
                }
                default: {
                    this.fallback = true;
                    LOG.warning("unexpected fields for StackFrame2Reader: " + identifier);
                }
            }
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            if (this.fallback) {
                return super.read(in, allowUnresolvedReference);
            }
            if (!(in instanceof SeekableInputStream)) {
                return this.readFrameFair(in, allowUnresolvedReference);
            }
            long initialPosition = in.getPosition();
            long methodConstantIndex = in.readLong();
            int lineNumber = in.readInt();
            int bytecodeIndex = in.readInt();
            long frameTypeConstantIndex = in.readLong();
            return this.frames.computeIfAbsent(new FrameData(methodConstantIndex, lineNumber, bytecodeIndex, frameTypeConstantIndex), __ -> {
                try {
                    ((SeekableInputStream)in).seek(initialPosition);
                    return this.readFrameFair(in, allowUnresolvedReference);
                }
                catch (IOException | InvalidJfrFileException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private StructTypes.JfrFrame readFrameFair(IDataInput in, boolean allowUnresolvedReference) throws InvalidJfrFileException, IOException {
            StructTypes.JfrFrame jfrFrame = new StructTypes.JfrFrame();
            jfrFrame.method = ((ValueReaders.IValueReader)this.valueReaders.get(this.methodIdx)).read(in, allowUnresolvedReference);
            jfrFrame.lineNumber = ((ValueReaders.IValueReader)this.valueReaders.get(this.lineNumberIdx)).read(in, allowUnresolvedReference);
            jfrFrame.bytecodeIndex = ((ValueReaders.IValueReader)this.valueReaders.get(this.bytecodeIndexIdx)).read(in, allowUnresolvedReference);
            jfrFrame.type = ((ValueReaders.IValueReader)this.valueReaders.get(this.typeIdx)).read(in, allowUnresolvedReference);
            return jfrFrame;
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            if (!(value instanceof StructTypes.JfrFrame)) {
                throw new RuntimeException("Invalid object type, expected JfrFrame");
            }
            StructTypes.JfrFrame jfrFrame = (StructTypes.JfrFrame)value;
            jfrFrame.method = ((ValueReaders.IValueReader)this.valueReaders.get(0)).resolve(jfrFrame.method);
            jfrFrame.lineNumber = ((ValueReaders.IValueReader)this.valueReaders.get(1)).resolve(jfrFrame.lineNumber);
            jfrFrame.bytecodeIndex = ((ValueReaders.IValueReader)this.valueReaders.get(2)).resolve(jfrFrame.bytecodeIndex);
            jfrFrame.type = ((ValueReaders.IValueReader)this.valueReaders.get(3)).resolve(jfrFrame.type);
            return value;
        }

        private static class FrameData {
            private final long methodIndex;
            private final int lineNumber;
            private final int bytecodeIndex;
            private final long frameTypeIndex;

            public FrameData(long methodIndex, int lineNumber, int bytecodeIndex, long frameTypeIndex) {
                this.methodIndex = methodIndex;
                this.lineNumber = lineNumber;
                this.bytecodeIndex = bytecodeIndex;
                this.frameTypeIndex = frameTypeIndex;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                FrameData frameData = (FrameData)o;
                return this.methodIndex == frameData.methodIndex && this.lineNumber == frameData.lineNumber && this.bytecodeIndex == frameData.bytecodeIndex && this.frameTypeIndex == frameData.frameTypeIndex;
            }

            public int hashCode() {
                int result = 1;
                result = 31 * result + Long.hashCode(this.methodIndex);
                result = 31 * result + this.lineNumber;
                result = 31 * result + this.bytecodeIndex;
                result = 31 * result + Long.hashCode(this.frameTypeIndex);
                return result;
            }
        }
    }

    static class StackTrace2Reader
    extends ValueReaders.ReflectiveReader {
        int truncatedIdx;
        int framesIdx;

        <T> StackTrace2Reader(Class<T> klass, int fieldCount, ContentType<? super T> ct) {
            super(klass, fieldCount, ct);
        }

        @Override
        void addField(String identifier, String name, String description, ValueReaders.IValueReader reader) throws InvalidJfrFileException {
            super.addField(identifier, name, description, reader);
            int currentIdx = this.valueReaders.size() - 1;
            switch (identifier) {
                case "frames": {
                    this.framesIdx = currentIdx;
                    break;
                }
                case "truncated": {
                    this.truncatedIdx = currentIdx;
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected fields for StackTrace2Reader: " + identifier);
                }
            }
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            Object truncationState = ((ValueReaders.IValueReader)this.valueReaders.get(this.truncatedIdx)).read(in, allowUnresolvedReference);
            Object frames = ((ValueReaders.IValueReader)this.valueReaders.get(this.framesIdx)).read(in, allowUnresolvedReference);
            return new StructTypes.JfrStackTrace(frames, truncationState);
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            if (!(value instanceof StructTypes.JfrStackTrace)) {
                throw new RuntimeException("Invalid object type, expected JfrFrame");
            }
            StructTypes.JfrStackTrace stackTrace = (StructTypes.JfrStackTrace)value;
            Object truncationState = ((ValueReaders.IValueReader)this.valueReaders.get(this.truncatedIdx)).resolve(stackTrace.truncated);
            Object frames = ((ValueReaders.IValueReader)this.valueReaders.get(this.framesIdx)).resolve(stackTrace.frames);
            return new StructTypes.JfrStackTrace(frames, truncationState);
        }
    }
}

