/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependsOnMethodInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private static final Pattern PATTERN = Pattern.compile("\"([a-zA-Z1-9_()*]*)\"");

    @NotNull
    public String getGroupDisplayName() {
        return "TestNG";
    }

    @NotNull
    public String getShortName() {
        return "dependsOnMethodTestNG";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiAnnotation[] annotations;
        if (psiClass == null) {
            DependsOnMethodInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DependsOnMethodInspection.$$$reportNull$$$0(1);
        }
        if ((annotations = TestNGUtil.getTestNGAnnotations((PsiElement)psiClass)).length == 0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        for (PsiAnnotation annotation : annotations) {
            PsiExpression initializer;
            PsiElement resolve;
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("dependsOnMethods");
            if (value == null || TestNGUtil.isDisabled(annotation)) continue;
            String text = value.getText();
            if (value instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)value).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("static") && ((PsiField)resolve).hasModifierProperty("final") && (initializer = ((PsiField)resolve).getInitializer()) != null) {
                text = initializer.getText();
            }
            HashSet<String> names = new HashSet<String>();
            Matcher matcher = PATTERN.matcher(text);
            int idx = 0;
            while (matcher.find()) {
                String methodName = matcher.group(1);
                if (!names.add(methodName)) {
                    PsiAnnotationMemberValue[] initializers;
                    PsiAnnotationMemberValue element2Highlight = value;
                    if (value instanceof PsiArrayInitializerMemberValue && idx < (initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()).length) {
                        element2Highlight = initializers[idx];
                    }
                    problemDescriptors.add(manager.createProblemDescriptor((PsiElement)element2Highlight, TestngBundle.message("inspection.depends.on.method.duplicated.name.problem", methodName), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                }
                DependsOnMethodInspection.checkMethodNameDependency(manager, psiClass, methodName, value, problemDescriptors, isOnTheFly);
                ++idx;
            }
        }
        return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static void checkMethodNameDependency(InspectionManager manager, PsiClass psiClass, String methodName, PsiAnnotationMemberValue value, List<ProblemDescriptor> problemDescriptors, boolean onTheFly) {
        LOGGER.debug("Found dependsOnMethods with text: " + methodName);
        if (!methodName.isEmpty() && methodName.charAt(methodName.length() - 1) == ')') {
            LOGGER.debug("dependsOnMethods contains ()" + psiClass.getName());
            String template = TestngBundle.message("inspection.depends.on.method.check", methodName);
            problemDescriptors.add(manager.createProblemDescriptor((PsiElement)value, template, (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly));
        } else {
            PsiMethod[] foundMethods;
            String configAnnotation = TestNGUtil.getConfigAnnotation((PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class));
            if (methodName.endsWith("*")) {
                String methodNameMask = StringUtil.trimEnd((String)methodName, (String)"*");
                PsiMethod[] methods = ContainerUtil.filter((Object[])psiClass.getMethods(), method -> method.getName().startsWith(methodNameMask));
                foundMethods = methods.toArray(PsiMethod.EMPTY_ARRAY);
            } else {
                foundMethods = psiClass.findMethodsByName(methodName, true);
            }
            if (foundMethods.length == 0) {
                LOGGER.debug("dependsOnMethods method doesn't exist:" + methodName);
                problemDescriptors.add(manager.createProblemDescriptor((PsiElement)value, TestngBundle.message("inspection.depends.on.method.unknown.method.problem", methodName), (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly));
            } else {
                boolean hasTestsOrConfigs = false;
                for (PsiMethod foundMethod : foundMethods) {
                    if (configAnnotation != null) {
                        hasTestsOrConfigs |= AnnotationUtil.isAnnotated((PsiModifierListOwner)foundMethod, (String)configAnnotation, (int)1);
                        continue;
                    }
                    hasTestsOrConfigs |= TestNGUtil.hasTest((PsiModifierListOwner)foundMethod);
                }
                if (!hasTestsOrConfigs) {
                    String template = configAnnotation == null ? TestngBundle.message("inspection.depends.on.method.is.not.test", methodName) : TestngBundle.message("inspection.depends.on.method.is.not.annotated", methodName, configAnnotation);
                    problemDescriptors.add(manager.createProblemDescriptor((PsiElement)value, template, (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/theoryinpractice/testng/inspection/DependsOnMethodInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

